/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.checker;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.Set;

public class StorageInfoIntegralityProcessChecker
implements IRecoveryProcessChecker {
    private static final Log logger = LogFactory.getInstance(StorageInfoIntegralityProcessChecker.class);

    public void check(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        Set<String> newStorageInfos;
        if (null == context || null == procType) {
            logger.error((Object)"Invalid parameters.");
            return;
        }
        if (!DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.equals((Object)procType)) {
            return;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        if (null == protectGroup) {
            throw new LegoCheckedException(1073947394L);
        }
        ExecuteReplicaManager mgr = ExecuteReplicaManager.getInstance();
        if (!mgr.getRealTimeReplicaPolicyType().contains(protectGroup.getTemplate().getType())) {
            return;
        }
        Set posInReplica = context.getRecoveryProtectObjects();
        Set posOfLatest = protectGroup.getPolist();
        Set<String> oldStorageInfos = this.getStorageInfos(posInReplica);
        if (!this.isStorageInfoIntegrated(oldStorageInfos, newStorageInfos = this.getStorageInfos(posOfLatest))) {
            throw new LegoCheckedException(1073948765L);
        }
    }

    public String getName() {
        return StorageInfoIntegralityProcessChecker.class.getName();
    }

    private Set<String> getStorageInfos(Set<ProtectObject> protectObjects) {
        HashSet<String> storageInfos = new HashSet<String>();
        if (VerifyUtil.isEmpty(protectObjects)) {
            return storageInfos;
        }
        for (ProtectObject protectObject : protectObjects) {
            Set poStorageInfos = protectObject.getUsedStorageResourceSet();
            if (null == poStorageInfos) continue;
            for (ProtectObjectStorageInfo storageInfo : poStorageInfos) {
                String storageInfoKey = DrmEnumDefine.ResourceTypeE.LUN.getValue() == storageInfo.getResourceType().intValue() ? storageInfo.getLunWWN() : storageInfo.getResourceProviderSN() + ":" + storageInfo.getResourceId();
                storageInfos.add(storageInfoKey);
            }
        }
        return storageInfos;
    }

    private boolean isStorageInfoIntegrated(Set<String> oldStorageInfos, Set<String> newStorageInfos) {
        boolean isIntegrated = true;
        for (String storageInfoKey : oldStorageInfos) {
            if (newStorageInfos.contains(storageInfoKey)) continue;
            isIntegrated = false;
            break;
        }
        return isIntegrated;
    }
}

