/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageReprotectManagerProxy;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class RefreshStorageSubProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = 2462925564560426284L;
    private static final Log logger = LogFactory.getInstance(RefreshStorageSubProcessor.class);
    private String recoveryArray;
    private String arrayName;

    public RefreshStorageSubProcessor() {
        this.setIsNeedSave(false);
    }

    public RefreshStorageSubProcessor(RecoveryProcessor parrentProcessor, String recoveryArray, String arrayName) {
        super(parrentProcessor);
        this.recoveryArray = recoveryArray;
        this.arrayName = arrayName;
        this.setIsNeedSave(false);
    }

    public String getRecoveryArray() {
        return this.recoveryArray;
    }

    public void setRecoveryArray(String recoveryArray) {
        this.recoveryArray = recoveryArray;
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.arrayName});
        ProtectGroup pg = context.getProtectGroup();
        try {
            if (VerifyUtil.isEmpty((Object)pg)) {
                logger.error((Object)"pg is null: arrayName=%s", new Object[]{this.arrayName});
                throw new LegoCheckedException(1073947394L);
            }
            boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
            String consistencyGroupId = this.getConsistencyGroupId(pg);
            if (isVasa && !VerifyUtil.isEmpty((String)consistencyGroupId)) {
                StorageReprotectManagerProxy.getInstance().refreshVasaProtectGroupStorage(this.recoveryArray, consistencyGroupId);
            } else if (pg.hasMultiCg()) {
                this.refreshProtectGroupWithMultiCg(context);
            } else if (PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
                Set<String> pairIds = this.getProtectGroupPairIds(pg);
                if (VerifyUtil.isEmpty(pairIds)) {
                    StorageReprotectManagerProxy.getInstance().refreshStorage(this.recoveryArray);
                } else {
                    StorageReprotectManagerProxy.getInstance().refreshProtectGroupStorage(this.recoveryArray, pairIds);
                }
            } else {
                StorageReprotectManagerProxy.getInstance().refreshStorage(this.recoveryArray);
            }
            logger.info((Object)("Refreshing storage successed. Name\uff1a" + this.arrayName + ",SN:" + this.recoveryArray), 90160758784000L);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Refreshing storage failed.", (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Refreshing storage failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.updateProcessDetail("lego.err.-1", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void refreshProtectGroupWithMultiCg(RecoveryProcessorContext context) {
        logger.debug((Object)"start refresh pg with multi cg");
        Collection tasks = (Collection)context.getAttribute("recoveryTasks");
        StorageReprotectManagerProxy reprotectManagerProxy = StorageReprotectManagerProxy.getInstance();
        Set cgIdSetOfArray = tasks.parallelStream().filter(this::isRecoveryTaskContainsTargetArray).map(RecoveryTask::getProtectId).collect(Collectors.toSet());
        for (String cgId : cgIdSetOfArray) {
            logger.info((Object)"Refresh cg id: %s, devSn=%s", new Object[]{cgId, this.recoveryArray});
            reprotectManagerProxy.refreshVasaProtectGroupStorage(this.recoveryArray, cgId);
        }
    }

    private boolean isRecoveryTaskContainsTargetArray(RecoveryTask recoveryTask) {
        return Objects.equals(recoveryTask.getSrcDeviceId(), this.recoveryArray) || Objects.equals(recoveryTask.getTgtDevcieId(), this.recoveryArray);
    }

    private String getConsistencyGroupId(ProtectGroup pg) {
        Set replicas = pg.getReplicaList();
        String consistencyGroupId = null;
        if (VerifyUtil.isEmpty((Collection)replicas)) {
            return null;
        }
        List filterRep = replicas.stream().filter(replica -> replica.getType() == 2 || replica.getType() == 1).collect(Collectors.toList());
        if (!VerifyUtil.isEmpty(filterRep)) {
            String meteData = ((ProtectGroupReplica)filterRep.get(0)).getPoReplicaMateData();
            JSONArray jsonArray = JSONArray.fromObject((Object)meteData);
            block0: for (Object obj : jsonArray) {
                JSONArray array = JSONObject.fromObject(obj).getJSONArray("storageInfos");
                for (Object objReplica : array) {
                    JSONObject remoteJson = JSONObject.fromObject(objReplica).getJSONObject("RemoteStorageReplica");
                    if (remoteJson == null || !remoteJson.containsKey((Object)"consistentGroupId") || VerifyUtil.isEmpty((String)(consistencyGroupId = remoteJson.getString("consistentGroupId")))) continue;
                    break block0;
                }
            }
        }
        return consistencyGroupId;
    }

    private Set<String> getProtectGroupPairIds(ProtectGroup protectGroup) {
        HashSet<String> pairIds = new HashSet<String>();
        protectGroup.getReplicaList().stream().filter(protectGroupReplica -> !protectGroupReplica.isLocalStorageSnapshotReplica()).forEach(protectGroupReplica -> protectGroupReplica.getReplicas().forEach(protectObjectReplica -> protectObjectReplica.getStorageInfos().forEach(relicaStorageInfo -> {
            if (!(relicaStorageInfo instanceof RemoteStorageReplica)) {
                return;
            }
            RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)relicaStorageInfo;
            pairIds.add(remoteStorageReplica.getReplicationPairId());
        })));
        return pairIds;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

