/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.task.IBackTaskListener;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;

public abstract class ReplicaOperationTask
extends AbstractBackTask {
    protected static final String REPLICA_LOCK_PREFIX = "REPLICA_LOCK_PREFIX_";
    protected static final String HOST_LOCK_PREFIX = "HOST_LOCK_PREFIX_";
    private static Log logger = LogFactory.getInstance(ReplicaOperationTask.class);
    private static final int DEFAULT_TIMEOUT = 14400;
    private ProtectGroupReplica replica;
    private String mountHost;
    private User operator;
    private String taskDescription;
    private boolean needLock = true;

    public ReplicaOperationTask(ProtectGroupReplica replica, String mountHost, User operator, String taskName, boolean isNeedUpdateDb) {
        this(replica, mountHost, operator, taskName, isNeedUpdateDb, null);
    }

    public ReplicaOperationTask(ProtectGroupReplica replica, String mountHost, User operator, String taskName, boolean isNeedUpdateDb, IBackTaskListener listener) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)replica.getName(), (String)taskName, (String)operator.getUserName(), (String)"", null), 14400, isNeedUpdateDb, listener);
        this.replica = replica;
        this.operator = operator;
        this.mountHost = mountHost;
    }

    protected void waitTaskCompleted(String planId, DrmEnumDefine.RecoveryPlanStatusE expectedStatus, long errCode) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        this.setTaskLink(planId, planService);
        boolean result = RecoveryTaskUtil.waitRecoveryPlanCompleted((String)planId, (DrmEnumDefine.RecoveryPlanStatusE)expectedStatus);
        this.setTaskLink(planId, planService);
        if (!result) {
            String[] parameters = new String[]{this.replica.getId(), this.mountHost};
            logger.error((Object)this.taskDescription, new Object[]{90160758784001L, this.replica.getId(), this.mountHost});
            throw new LegoCheckedException(errCode, parameters, this.taskDescription);
        }
    }

    private void setTaskLink(String planId, IRecoveryPlanService planService) {
        String taskLink = String.format("/recoveryplans/%s/logs/%s/details", planId, planService.getLatestRecoveryLogIdBy(planId));
        this.getBackTask().setTaskLink(taskLink);
    }

    protected void tryLock(String lockId) {
        if (!this.needLock) {
            return;
        }
        ProtectionJobUtil.getInstance().checkIsNeedLock(lockId);
    }

    protected void releaseLock(String lockId) {
        if (!this.needLock) {
            return;
        }
        ProtectionJobUtil.getInstance().releaseLockPg(lockId);
    }

    public ProtectGroupReplica getReplica() {
        return this.replica;
    }

    public void setReplica(ProtectGroupReplica replica) {
        this.replica = replica;
    }

    public String getMountHost() {
        return this.mountHost;
    }

    public void setMountHost(String mountHost) {
        this.mountHost = mountHost;
    }

    public User getOperator() {
        return this.operator;
    }

    public void setOperator(User operator) {
        this.operator = operator;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public boolean isNeedLock() {
        return this.needLock;
    }

    public void setNeedLock(boolean needLock) {
        this.needLock = needLock;
    }
}

