/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class SyncLockManager {
    private static final int ONE_SECOND = 1000;
    private static final int MAX_RETRIES = 600;
    private static final Map<String, ReentrantLock> syncLocks = new ConcurrentHashMap<String, ReentrantLock>();

    private SyncLockManager() {
    }

    public static synchronized boolean tryLock(String key) {
        ReentrantLock lock = syncLocks.get(key);
        if (null == lock) {
            lock = new ReentrantLock(true);
            syncLocks.put(key, lock);
        }
        return lock.tryLock();
    }

    public static boolean tryLock(String key, int retries) {
        boolean locked = SyncLockManager.tryLock(key);
        int count = 0;
        while (!locked) {
            CommonUtil.sleep((long)1000L);
            locked = SyncLockManager.tryLock(key);
            if (++count != retries && count != 600) continue;
            break;
        }
        return locked;
    }

    public static synchronized void unLock(String key) {
        ReentrantLock lock = syncLocks.get(key);
        if (null != lock) {
            lock.unlock();
            syncLocks.remove(key);
        }
    }

    public static synchronized boolean isLocked(String key) {
        ReentrantLock lock = syncLocks.get(key);
        if (null != lock) {
            return lock.isLocked();
        }
        return false;
    }

    public static synchronized void putSyncLock(String key, ReentrantLock lock) {
        if (syncLocks.containsKey(key)) {
            throw new LegoCheckedException(-1L);
        }
        syncLocks.put(key, lock);
    }

    public static synchronized ReentrantLock getSyncLock(String key) {
        return syncLocks.get(key);
    }

    public static synchronized void removeSyncLock(String key) {
        syncLocks.remove(key);
    }
}

