/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.poll;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;

public class ServerPollerInitializer
implements SystemStatusChangedListener {
    private final Log logger = LogFactory.getInstance(this.getClass());
    private ILicenseInter licenseService = null;

    public ILicenseInter getLicenseService() {
        return this.licenseService;
    }

    public void setLicenseService(ILicenseInter licenseService) {
        this.licenseService = licenseService;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() != Status.STATUS_STARTED) {
            return;
        }
        try {
            this.initLocalServerInfo();
            this.upgradeSitesInfo();
            this.launchPoll();
            this.launchGlobalPoller();
        }
        catch (Exception e) {
            this.logger.error((Object)("init server poller fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786876L);
        }
        try {
            this.licenseService.getLicenseNotUpdateUseNum();
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"license invalid. start delete license....");
            this.deleteLicense();
            this.logger.error((Object)("delete old version basic license" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786876L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLicense() {
        String deleteString = "delete from T_licenseinfo";
        Session session = null;
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            transaction = session.beginTransaction();
            NativeQuery query = session.createNativeQuery(deleteString);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception ex) {
            try {
                this.logger.error((Object)"delete license got error.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                DBOperationUtil.rollbackSession((Session)session);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    private void initLocalServerInfo() {
        ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "serverType", (Object)0);
        if (null != server) {
            return;
        }
        this.logger.info((Object)"Start Init LocalServer Info", 90160758784000L);
        server = new ManagementServer();
        server.setUuid(UUIDGenerator.getUUID());
        server.setName("LocalServer");
        server.setStatus(Integer.valueOf(0));
        server.setServerType(0);
        CommonDAOLocator.getMoDao().save((Object)server);
        this.logger.info((Object)("End Init LocalServer Info, uuid=" + server.getUuid()), 90160758784000L);
    }

    private void upgradeSitesInfo() {
        this.upgradeLocalSiteInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSiteNotExist(int siteType) {
        String sql = "select * from ti_site where (serverUuid is null or serverUuid='') and siteType=?";
        Session session = null;
        List list = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery sqlQuery = session.createSQLQuery(sql);
            sqlQuery.setInteger(0, siteType);
            list = sqlQuery.list();
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("Query site failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return VerifyUtil.isEmpty((Collection)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeLocalSiteInfo() {
        if (this.isSiteNotExist(0)) {
            return;
        }
        String upgradeLocalSiteSql = "update ti_site set serverUuid=(select mo.uuid from t_managedobject mo, ti_managementserver ms where mo.moid=ms.moid and ms.serverType=?) where (serverUuid is null or serverUuid='') and siteType=?";
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Transaction transaction = session.beginTransaction();
            NativeQuery sqlQuery = session.createSQLQuery(upgradeLocalSiteSql);
            sqlQuery.setInteger(0, 0);
            sqlQuery.setInteger(1, 0);
            int count = sqlQuery.executeUpdate();
            this.logger.info((Object)("Update local count is " + count), 90160758784000L);
            transaction.commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                this.logger.error((Object)("Upgrade site failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784000L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    private void launchPoll() {
    }

    private void launchGlobalPoller() {
    }
}

