/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.HashMap;
import java.util.Map;

public class StorageSnapshotScheduleManagerProxy
extends BaseStorageManagerProxy {
    private static StorageSnapshotScheduleManagerProxy proxy = new StorageSnapshotScheduleManagerProxy();
    private Map<String, IStorageSnapshotScheduleManager> storageSnapManagers = new HashMap<String, IStorageSnapshotScheduleManager>();

    public static StorageSnapshotScheduleManagerProxy getInstance() {
        return proxy;
    }

    public void onBind(IStorageSnapshotScheduleManager handler, Map<String, Object> properties) {
        this.storageSnapManagers.put(handler.getStorageType() + handler.getSnapshotType(), handler);
    }

    public IStorageSnapshotScheduleManager getStorageSnapshotMgrByDevType(String deviceType) {
        return this.storageSnapManagers.get(deviceType);
    }

    public IStorageSnapshotScheduleManager getStorageSnapshotMgrByDevId(String deviceId, int oriSnapshotType) {
        int snapshotType = oriSnapshotType;
        if (oriSnapshotType == ScheduleProtectedType.SNAPSHOT.getValue()) {
            snapshotType = SnapshotSchedule.SCHEDULE_TYPE.SNAPSHOT.getValue();
        } else if (oriSnapshotType == ScheduleProtectedType.HYPERCDP.getValue()) {
            snapshotType = SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue();
        } else if (oriSnapshotType == ScheduleProtectedType.SECURE_SNAPSHOT.getValue()) {
            snapshotType = SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue();
        }
        String deviceType = this.getStorageType(deviceId);
        IStorageSnapshotScheduleManager manager = this.storageSnapManagers.get(deviceType + snapshotType);
        if (null == manager) {
            throw new LegoCheckedException(1073948253L);
        }
        return manager;
    }
}

