/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.base.sdk.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidateUtil {
    public static void validate(String regex, String str) {
        if (null == str || null == regex) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!ValidateUtil.match(regex, str)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static boolean match(String regex, String str) {
        if (null == regex) {
            throw new IllegalArgumentException("Regular expression can not be null.");
        }
        if (null == str) {
            throw new IllegalArgumentException("The input string can not be null.");
        }
        Pattern pat = Pattern.compile(regex);
        String normalize = Normalizer.normalize(str, Normalizer.Form.NFKC);
        Matcher mat = pat.matcher(normalize);
        return mat.matches();
    }

    public static boolean checkLength(String str, int min, int max) {
        if (null == str) {
            throw new IllegalArgumentException("The input string can not be null.");
        }
        if (min < 0 || min > max) {
            throw new IllegalArgumentException("The range is error.");
        }
        int length = str.length();
        return length >= min && length <= max;
    }

    public static boolean checkPort(long port) {
        return port >= 1L && port <= 65535L;
    }
}

