/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.sdk.bo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Page
implements Serializable {
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final long serialVersionUID = 4762001460129289767L;
    private List data;
    private int pageSize = 20;
    private long totalCount;
    private long start;

    public Page() {
        this(0L, 0L, 20, new ArrayList());
    }

    public Page(long start, long totalSize, int pageSize, List data) {
        this.pageSize = pageSize;
        this.start = start;
        this.totalCount = totalSize;
        this.data = data;
    }

    public static Page createPage(int pageNo, int pageSize, List allObjList) {
        int totalCount = allObjList.size();
        int from = Page.getStartOfPage(pageNo, pageSize);
        from = from > totalCount ? totalCount : from;
        int to = from + pageSize;
        to = to > totalCount ? totalCount : to;
        ArrayList objList = new ArrayList();
        objList.addAll(allObjList.subList(from, to));
        return new Page(from, totalCount, pageSize, objList);
    }

    public static int getStartOfPage(int pageNo, int pageSize) {
        return pageNo * pageSize;
    }

    public long getCurrentPageNo() {
        return this.start / (long)this.pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List getResult() {
        return this.data;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getTotalPageCount() {
        return (this.totalCount + (long)this.pageSize - 1L) / (long)this.pageSize;
    }

    public boolean hasNextPage() {
        return this.getCurrentPageNo() < this.getTotalPageCount() - 1L;
    }

    public boolean hasPreviousPage() {
        return this.getCurrentPageNo() > 0L;
    }

    public void setResult(List tmpData) {
        this.data = tmpData;
    }
}

