/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class CapacityUnitUtil {
    public static final String UNKNOWN_DISPLAY_STRING = "--";
    private static final int DOUBLE_MIN_PRECISION = 2;
    private static final int DOUBLE_MAX_PRECISION = 2;

    public static String getCapacityAndUnit(Double capacity, String capacityUnit) {
        if (VerifyUtil.isEmpty(capacity) || capacity < 0.0 || VerifyUtil.isEmpty(capacityUnit)) {
            return UNKNOWN_DISPLAY_STRING;
        }
        return UnitConvert.autoConvertToAdaptedValueAndUnit(capacity, CapabilityUnitType.valueOf(capacityUnit));
    }

    public static String getCapacityAndUnit(Double capacity, CapabilityUnitType capacityUnit) {
        if (VerifyUtil.isEmpty(capacity) || capacity < 0.0 || VerifyUtil.isEmpty(capacityUnit)) {
            return UNKNOWN_DISPLAY_STRING;
        }
        return UnitConvert.autoConvertToAdaptedValueAndUnit(capacity, capacityUnit);
    }

    public static Double getFreeCapacity(Double totalCapacity, Double usedCapacity) {
        if (null == totalCapacity || totalCapacity < 0.0) {
            return null;
        }
        if (null == usedCapacity || usedCapacity <= 0.0) {
            return totalCapacity;
        }
        Double freeCapacity = totalCapacity - usedCapacity;
        return freeCapacity < 0.0 ? Double.valueOf(0.0) : freeCapacity;
    }

    public static Double getTotalCapacity(Double usedCapacity, Double freeCapacity) {
        if (null == usedCapacity && null == freeCapacity) {
            return null;
        }
        if (null == usedCapacity || usedCapacity <= 0.0) {
            usedCapacity = 0.0;
        } else if (null == freeCapacity || freeCapacity <= 0.0) {
            freeCapacity = 0.0;
        }
        return usedCapacity + freeCapacity;
    }

    public static String getTotalCapacityAndUnit(Double usedCapacity, Double freeCapacity, String capacityUnit) {
        return CapacityUnitUtil.getCapacityAndUnit(CapacityUnitUtil.getTotalCapacity(usedCapacity, freeCapacity), capacityUnit);
    }

    public static String getFreeCapacityAndUnit(Double totalCapacity, Double usedCapacity, String capacityUnit) {
        return CapacityUnitUtil.getCapacityAndUnit(CapacityUnitUtil.getFreeCapacity(totalCapacity, usedCapacity), capacityUnit);
    }

    public static String getFreeCapacityAndUnit(Double totalCapacity, Double usedCapacity, CapabilityUnitType capacityUnit) {
        return CapacityUnitUtil.getCapacityAndUnit(CapacityUnitUtil.getFreeCapacity(totalCapacity, usedCapacity), capacityUnit);
    }

    public static String formatValue(Double value) {
        return CapacityUnitUtil.formatValue(value, 2, 2);
    }

    public static String formatValue(Double value, int minFraction, int maxFraction) {
        if (null == value || value < 0.0) {
            return UNKNOWN_DISPLAY_STRING;
        }
        DecimalFormat nf = new DecimalFormat();
        ((NumberFormat)nf).setMinimumFractionDigits(minFraction);
        ((NumberFormat)nf).setMaximumFractionDigits(maxFraction);
        return nf.format(value);
    }

    public static final String getCapacityAndUnit(Double capacity, String capUnit, CapabilityUnitType defaultUnitType) {
        boolean capacityIsNull;
        boolean capUnitNotExist = !CapacityUnitUtil.isExistCapabilityUnitName(capUnit);
        boolean bl = capacityIsNull = null == capacity;
        if (capUnitNotExist && capacityIsNull) {
            return UNKNOWN_DISPLAY_STRING;
        }
        CapabilityUnitType targetUnitType = capUnitNotExist && !capacityIsNull ? defaultUnitType : CapabilityUnitType.valueOf(capUnit);
        return UnitConvert.autoConvertToAdaptedValueAndUnit(capacity, targetUnitType);
    }

    public static final boolean isExistCapabilityUnitName(String capabilityUnitName) {
        CapabilityUnitType[] capabilityUnitNames;
        if (CapacityUnitUtil.isEmpty(capabilityUnitName)) {
            return false;
        }
        for (CapabilityUnitType capType : capabilityUnitNames = CapabilityUnitType.values()) {
            if (!capType.name().equals(capabilityUnitName.trim())) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmpty(String capabilityUnitName) {
        return null == capabilityUnitName || capabilityUnitName.trim().length() == 0;
    }
}

