/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import java.text.Normalizer;
import java.util.regex.Pattern;

public final class DiscParamValidator {
    public static final String INTEGER_NEGATIVE = "^[1-9]\\d*|0$";
    private static final int VALUE_65536 = 65536;

    public static synchronized boolean stringisNull(String str) {
        return null == str || str.length() <= 0;
    }

    public static String decodeByLength(String encodedChar) {
        if (null == encodedChar) {
            return "";
        }
        return encodedChar.replaceAll("&quot;", "\"").replaceAll("&#39;", "'").replaceAll("&#96;", "`").replaceAll("&#37;", "%").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&#40;", "(").replaceAll("&#41;", ")").replaceAll("&nbsp;", " ").replaceAll("&#58;", ":").replaceAll("&#46;", ".").replaceAll("&#58;", ":").replaceAll("&#46;", ".");
    }

    public static boolean checkStringLength(String str, int length) {
        if (null == str) {
            return true;
        }
        String convertStr = DiscParamValidator.decodeByLength(str);
        return convertStr.length() <= length;
    }

    public static boolean isNum(String str) {
        return DiscParamValidator.regExpCheck(str, INTEGER_NEGATIVE);
    }

    public static boolean regExpCheck(String str, String pattern) {
        if (VerifyUtil.isEmpty(str)) {
            return false;
        }
        String normalize = Normalizer.normalize(str, Normalizer.Form.NFKC);
        return Pattern.compile(pattern).matcher(normalize).matches();
    }

    public static boolean isPort(int port) {
        return port > 0 && port < 65536;
    }
}

