/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroPairConfiguration;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.protection.replica.StorageDiskHelper;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.ism.drm.storage.service.impl.DrmStorageBaseServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;

public class CreateHypermetroPairTask
implements Callable<HypermetroPair> {
    private static final Log LOGGER = LogFactory.getInstance(CreateHypermetroPairTask.class);
    private final HypermetroPair pair;
    private final HypermetroPairConfiguration config;
    private final StorageHyperMetroManagerProxy hyperProxy = StorageHyperMetroManagerProxy.getInstance();
    private LegoCheckedException exception;

    public CreateHypermetroPairTask(HypermetroPair pair, HypermetroPairConfiguration config) {
        this.pair = pair;
        this.config = config;
    }

    public LegoCheckedException getException() {
        return this.exception;
    }

    public void setException(LegoCheckedException exception) {
        this.exception = exception;
    }

    @Override
    public HypermetroPair call() {
        try {
            return this.excuteWork();
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Create Hypermetro pair failed %s.", new Object[]{ex.getMessage()});
            this.setException(ex);
        }
        catch (Exception ex) {
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)String.format(Locale.ROOT, "Create hypermetro pair failed, source LUN id:%s.", this.pair.getSrcLunId()), (long)1073948472L, (String[])new String[]{this.config.findStoragePair().getSrcDevSN(), this.config.findStoragePair().getTgtDevSN()}, (Log)LOGGER);
            LOGGER.error((Object)"Create Hypermetro pair failed %s.", new Object[]{ex.getMessage()});
            this.setException(legoCheckedException);
        }
        return null;
    }

    HypermetroPair excuteWork() {
        LOGGER.debug((Object)"CreateHypermetroPairTask excuteWork enter.");
        Lun srcLun = StorageDiskHelper.getInstance().getLunById(this.pair.getSrcDevSN(), this.pair.getSrcLunId());
        StoragePair storagePair = this.config.findStoragePairBySrcPool(srcLun.getStoragePoolId());
        Lun tgtLun = this.getTargetLun(srcLun, storagePair);
        tgtLun.setEncrypted(srcLun.getEncrypted());
        tgtLun.setCryptAlg(srcLun.getCryptAlg());
        DrmStorageBaseServiceImpl drmStorageService = (DrmStorageBaseServiceImpl)ServiceLocator.getInstance().getService(DrmStorageBaseServiceImpl.class);
        Lun lun = drmStorageService.queryLunByName(tgtLun.getDevSn(), tgtLun.getName());
        if (!VerifyUtil.isEmpty((Object)lun) && !VerifyUtil.isEmpty((String)lun.getName())) {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("localObjName", tgtLun.getName());
            List pairList = this.hyperProxy.getMgrByDevId(this.pair.getSrcDevSN()).queryHypermetroPairs(this.pair.getSrcDevSN(), this.pair.getControlClusterId(), this.pair.getDomainid(), filters);
            if (VerifyUtil.isEmpty((Collection)pairList)) {
                throw new LegoCheckedException(1073947467L, new String[]{lun.getName()});
            }
            HypermetroPair existPair = (HypermetroPair)pairList.get(0);
            this.pair.setId(existPair.getId());
            this.setPair(existPair);
            this.getTargetLun(this.pair.getSrcLunName(), tgtLun, existPair);
            return existPair;
        }
        Lun createdLun = drmStorageService.createLun(tgtLun.getDevSn(), tgtLun);
        if (createdLun == null) {
            LOGGER.error((Object)"Create target lun failed.");
            throw new LegoCheckedException(1073947726L, new String[]{storagePair.getTgtDevSN()});
        }
        this.buildPair(srcLun, createdLun);
        HypermetroPair resultPair = this.createHypermetroPair();
        this.setPair(resultPair);
        this.getTargetLun(this.pair.getSrcLunName(), tgtLun, resultPair);
        LOGGER.debug((Object)"End to create hyperMetroPair(%s).", new Object[]{this.pair.getId()});
        return resultPair;
    }

    private HypermetroPair createHypermetroPair() {
        HypermetroPair resultPair;
        if (this.pair.getSrcDevSN().equals(this.pair.getSrcLunDevSN())) {
            LOGGER.debug((Object)"Start to create pair(srcLun:%s)", new Object[]{this.pair.getLocalobjname()});
            resultPair = this.hyperProxy.getMgrByDevId(this.pair.getSrcDevSN()).createHypermetroPair(this.pair);
        } else {
            LOGGER.debug((Object)"Start to create and swapHyperMetroPair(srcLun:%s)", new Object[]{this.pair.getLocalobjname()});
            String tgetSn = this.config.findStoragePair().getTgtDevSN();
            this.pair.setSrcDevSN(tgetSn);
            resultPair = this.hyperProxy.getMgrByDevId(tgetSn).createHypermetroPair(this.pair);
            this.hyperProxy.getMgrByDevId(tgetSn).swapHyperMetroPair(tgetSn, this.pair.getControlClusterId(), resultPair.getId());
        }
        return resultPair;
    }

    private void buildPair(Lun srcLun, Lun createdLun) {
        this.pair.setLocalobjid(srcLun.getLunId());
        this.pair.setLocalobjname(srcLun.getName());
        this.pair.setRemoteobjid(createdLun.getLunId());
        this.pair.setRemoteobjname(createdLun.getName());
    }

    private void setPair(HypermetroPair onePair) {
        onePair.setControlClusterId(this.pair.getControlClusterId());
        onePair.setSrcLunName(this.pair.getSrcLunName());
        onePair.setSrcLunId(this.pair.getSrcLunId());
        onePair.setSrcLunDevSN(this.pair.getSrcLunDevSN());
        onePair.setSrcDevSN(this.config.findStoragePair().getSrcDevSN());
    }

    private Lun getTargetLun(Lun srcLun, StoragePair storagePair) {
        Lun tgtLun = new Lun();
        String srcPoolId = srcLun.getStoragePoolId();
        String tgtDevSn = this.pair.getSrcLunDevSN().equals(storagePair.getSrcDevSN()) ? storagePair.getTgtDevSN() : storagePair.getSrcDevSN();
        tgtLun.setDevSn(tgtDevSn);
        tgtLun.setName(srcLun.getName());
        tgtLun.setCapacity(srcLun.getCapacity());
        tgtLun.setStoragePoolId(storagePair.getTgtStoragePool(this.pair.getSrcLunDevSN(), srcPoolId));
        return tgtLun;
    }

    private void getTargetLun(String srcLunName, Lun tgtLun, HypermetroPair onePair) {
        ReplicationTargetLun replicationTargetLun = new ReplicationTargetLun();
        replicationTargetLun.setTgtLunName(srcLunName);
        replicationTargetLun.setTgtDevSN(tgtLun.getDevSn());
        replicationTargetLun.setTgtPoolId(tgtLun.getStoragePoolId());
        onePair.setRepTgtLuns(replicationTargetLun);
    }

    private Lun getSrcLun(StorageLunManagerProxy lunManagerProxy) {
        if (StringUtils.isNotEmpty((CharSequence)this.pair.getSrcLunId())) {
            return lunManagerProxy.getLunById(this.pair.getSrcLunDevSN(), this.pair.getSrcLunId());
        }
        LOGGER.error((Object)"Source Lun is not exist, Device SN(%s), Lun ID(%s), Lun name(%s)", new Object[]{this.pair.getSrcLunDevSN(), this.pair.getSrcLunId(), this.pair.getSrcLunName()});
        throw new LegoCheckedException(1073947724L, new String[]{this.pair.getSrcLunId()});
    }
}

