/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroPairConfiguration;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.manager.sdk.service.IHypermetroGroupBuilder;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroGroup;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.ArrayList;
import java.util.List;

public class DefaultHypermetroGroupBuilder
implements IHypermetroGroupBuilder {
    public List<HypermetroGroup> buildHypermetroGroup(ProtectGroup protectGroup) {
        String hypermetroCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        HypermetroPairConfiguration config = new HypermetroPairConfiguration(hypermetroCfg);
        StoragePair storagePair = config.findStoragePair();
        if (storagePair == null) {
            throw new LegoCheckedException(2117645L, "Storage is null.");
        }
        List allStorageInfoList = protectGroup.distinctStorageInfo();
        ArrayList<HypermetroPair> pairList = new ArrayList<HypermetroPair>();
        for (ProtectObjectStorageInfo storageInfo : allStorageInfoList) {
            HypermetroPair pair = new HypermetroPair();
            pair.setSrcDevSN(storagePair.getSrcDevSN());
            pair.setControlClusterId(storagePair.getSrcControlClusterId());
            pair.setDomainid(storagePair.getSrcHyperMetroDomainId());
            pair.setSrcLunDevSN(storageInfo.getResourceProviderSN());
            pair.setSrcLunId(storageInfo.getResourceId());
            pair.setSrcLunWWN(storageInfo.getLunWWN());
            pair.setSrcLunName(storageInfo.getResourceName());
            pairList.add(pair);
        }
        HypermetroGroup hypermetroGroup = new HypermetroGroup();
        hypermetroGroup.setSrcDevSN(storagePair.getSrcDevSN());
        hypermetroGroup.setControlClusterId(storagePair.getSrcControlClusterId());
        hypermetroGroup.setDomainid(storagePair.getSrcHyperMetroDomainId());
        hypermetroGroup.setHypermetroPairs(pairList);
        hypermetroGroup.setDevSn(allStorageInfoList.stream().findFirst().orElse(new ProtectObjectStorageInfo()).getResourceProviderSN());
        ArrayList<HypermetroGroup> cmdGroupList = new ArrayList<HypermetroGroup>();
        cmdGroupList.add(hypermetroGroup);
        return cmdGroupList;
    }
}

