/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderBaseDelegate;
import com.huawei.ism.drm.storage.hypermetro.builder.util.HypermetroUtil;
import com.huawei.ism.drm.storage.manager.sdk.model.EVolHypermetroVolumeInfo;
import com.huawei.ism.drm.storage.manager.sdk.model.FusionStorageHypermetroVolumeInfo;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EnableHypermetroTask
implements Callable<Boolean> {
    private static Log logger = LogFactory.getInstance(EnableHypermetroTask.class);
    private static final String EVOL_URL_PREFIX = "scsi-3";
    private List<HypermetroPair> pairList;
    private ProtectGroup protectGroup;
    private LegoCheckedException exception;

    public EnableHypermetroTask(ProtectGroup protectGroup, List<HypermetroPair> pairList) {
        this.protectGroup = protectGroup;
        this.pairList = pairList;
    }

    public LegoCheckedException getException() {
        return this.exception;
    }

    public void setException(LegoCheckedException exception) {
        this.exception = exception;
    }

    @Override
    public Boolean call() {
        try {
            return this.enableHypermetro();
        }
        catch (LegoCheckedException ex) {
            this.setException(ex);
        }
        catch (Exception ex) {
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)"Enable Hypermetro error.", (long)1073948473L, (String[])new String[0], (Log)logger);
            this.setException(legoCheckedException);
        }
        return false;
    }

    private Boolean enableHypermetro() {
        logger.debug((Object)"EnableHypermetro enter");
        String devSn = this.pairList.iterator().next().getRepTgtLuns().getTgtDevSN();
        StorageUnit storageUnits = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getStorageUnitBySn(devSn);
        if (VerifyUtil.isEmpty((Object)storageUnits)) {
            String msg = "The StorageUnits is empty.";
            logger.error((Object)msg);
            throw new LegoCheckedException(1073947394L, msg);
        }
        Map<String, String> poolIdAndNameMap = HypermetroUtil.getPoolMap();
        int templateType = this.protectGroup.getTemplate().getType();
        ArrayList<Object> hypermetroVolumeInfos = new ArrayList<Object>();
        if (templateType == 38) {
            hypermetroVolumeInfos.addAll(this.buildFusionStorageHypermetroVolumeInfos(devSn, storageUnits, poolIdAndNameMap));
        } else if (templateType == 53) {
            hypermetroVolumeInfos.addAll(this.buildEVolHypermetroVolumeInfos(storageUnits));
        } else {
            logger.error((Object)"Enable hypermetro fail, template type(%s) not supported.", new Object[]{String.valueOf(templateType)});
            throw new LegoCheckedException(1073947393L);
        }
        IProtectObjectBaseProvider provider = ((IProtectObjectProviderBaseDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderBaseDelegate.class)).getProviderByAppType(this.protectGroup.getPoType());
        provider.enablePoHyperMetro(this.protectGroup.getPoProviderSN(), hypermetroVolumeInfos);
        logger.debug((Object)"EnableHypermetro leave");
        return true;
    }

    private List<FusionStorageHypermetroVolumeInfo> buildFusionStorageHypermetroVolumeInfos(String devSn, StorageUnit storageUnits, Map<String, String> poolIdAndNameMap) {
        return this.pairList.stream().map(pair -> {
            FusionStorageHypermetroVolumeInfo fsHyperVolInfo = new FusionStorageHypermetroVolumeInfo();
            String poolId = pair.getRepTgtLuns().getTgtPoolId();
            fsHyperVolInfo.setUuid(pair.getRepTgtLuns().getTgtLunName());
            fsHyperVolInfo.setStandbyDs((String)poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{devSn, poolId})));
            fsHyperVolInfo.setStandbyPoolId(poolId);
            fsHyperVolInfo.setStandbyFloatIp(storageUnits.getIpAddress());
            return fsHyperVolInfo;
        }).collect(Collectors.toList());
    }

    private List<EVolHypermetroVolumeInfo> buildEVolHypermetroVolumeInfos(StorageUnit storageUnits) {
        Map<String, String> volWwnIdMap = this.getVolWwnIdMap();
        ArrayList<EVolHypermetroVolumeInfo> evolHyperVolInfos = new ArrayList<EVolHypermetroVolumeInfo>();
        for (HypermetroPair pair : this.pairList) {
            EVolHypermetroVolumeInfo evolHyperVolInfo = new EVolHypermetroVolumeInfo();
            String wwn = pair.getSrcLunWWN();
            evolHyperVolInfo.setLunWwn(wwn);
            evolHyperVolInfo.setVolId(volWwnIdMap.get(wwn));
            evolHyperVolInfo.setStandbyPoolId(pair.getRepTgtLuns().getTgtPoolId());
            evolHyperVolInfo.setStandbyControllerIps(storageUnits.getManageIps().split(","));
            evolHyperVolInfos.add(evolHyperVolInfo);
        }
        return evolHyperVolInfos;
    }

    private Map<String, String> getVolWwnIdMap() {
        HashMap<String, String> volWwnIdMap = new HashMap<String, String>();
        for (ProtectObject po : this.protectGroup.getPolist()) {
            JSONObject vmMgrInfo = HypermetroUtil.getPoVmMgrInfo(po.getProps());
            List disks = vmMgrInfo.getJSONObject("vmConfig").getJSONArray("disks").toBean(JSONObject.class);
            for (JSONObject disk : disks) {
                String wwn = StringUtils.substringAfter((String)disk.getString("volumeUrl"), (String)EVOL_URL_PREFIX);
                String id = StringUtils.substringAfterLast((String)disk.getString("volumeUrn"), (String)":");
                volWwnIdMap.put(wwn, id);
            }
        }
        return volWwnIdMap;
    }
}

