/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroBaseManager;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroGroup;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class HypermetroGroupRollbackItem
implements IRollbackItem {
    private static final Log logger = LogFactory.getInstance(HypermetroGroupRollbackItem.class);
    private HypermetroGroup group;
    private String storageDevSn;
    private Map<Integer, List<String>> resourceIds;

    public HypermetroGroupRollbackItem(HypermetroGroup group, String storageDevSn) {
        this.group = group;
        this.storageDevSn = storageDevSn;
        this.resourceIds = new HashMap<Integer, List<String>>();
    }

    public String toString() {
        if (this.group == null) {
            return "{}";
        }
        if (!this.resourceIds.containsKey(3)) {
            this.resourceIds.put(3, new ArrayList());
        }
        this.resourceIds.get(3).add(this.group.getId());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storageDevSn", this.storageDevSn);
        paramMap.put("group", JSONObject.fromObject((Object)this.group).toString());
        JSONObject result = new JSONObject();
        result.put((Object)this.getClass().getSimpleName(), (Object)JSONObject.fromObject(paramMap).toString());
        return result.toString();
    }

    public boolean execute() {
        logger.debug((Object)"HypermetroGroupRollbackItem execute enter");
        IStorageHyperMetroBaseManager iStorageHyperMetroManager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(this.group.getSrcDevSN());
        try {
            HypermetroGroup hypermetroGroup = iStorageHyperMetroManager.queryHypermetroCGroup(this.group.getSrcDevSN(), this.group.getControlClusterId(), this.group.getId());
            if (hypermetroGroup == null) {
                return true;
            }
            List hypermetroPairs = iStorageHyperMetroManager.getHypermetroPairsByCgId(this.group.getSrcDevSN(), this.group.getControlClusterId(), this.group.getId());
            if (!iStorageHyperMetroManager.isAccordantExpectForRunningStatus(hypermetroGroup.getRunningStatus(), "PAUSE")) {
                iStorageHyperMetroManager.pausedHypermetroCGroup(hypermetroGroup.getSrcDevSN(), hypermetroGroup.getControlClusterId(), hypermetroGroup.getId(), Boolean.valueOf(!this.storageDevSn.equals(this.group.getSrcDevSN())));
            }
            if (CollectionUtils.isNotEmpty((Collection)hypermetroPairs)) {
                iStorageHyperMetroManager.removeHypermetroPairs(this.group, hypermetroPairs);
            }
            iStorageHyperMetroManager.deleteHypermetroCGroup(this.group.getSrcDevSN(), this.group.getControlClusterId(), this.group.getId());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"HypermetroGroupRollbackItem execute,errorCode={},message={}", new Object[]{e.getErrorCode(), e.getMessage()});
            return e.getErrorCode() == 37100035L || e.getErrorCode() == 1077675010L;
        }
        logger.debug((Object)"HypermetroGroupRollbackItem execute leave");
        return true;
    }

    public Map<Integer, List<String>> getResourceId() {
        return this.resourceIds;
    }
}

