/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.SubDiskInfo;
import com.huawei.ism.drm.recovery.framework.task.CachedProtectThreadPool;
import com.huawei.ism.drm.storage.hypermetro.builder.StopHypermetroTask;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HypermetroRelationRollbackItem
implements IRollbackItem {
    private static final Log logger = LogFactory.getInstance(HypermetroRelationRollbackItem.class);
    private static final long TASK_TIMEOUT = 1073948380L;
    private static final int DEFAULT_TIME_OUT = 300;
    private ProtectGroup protectGroup;
    private Map<Integer, List<String>> resourceIds;
    private Set<DiskInfo> releaseDiskInfo;
    private String storageDevSn;

    public String toString() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        JSONObject groupJson = new JSONObject();
        groupJson.put((Object)"poProviderSN", (Object)this.protectGroup.getPoProviderSN());
        groupJson.put((Object)"poType", (Object)this.protectGroup.getPoType());
        paramMap.put("protectGroup", groupJson.toString());
        JSONArray array = new JSONArray();
        for (DiskInfo diskInfo : this.releaseDiskInfo) {
            JSONObject diskJson = new JSONObject();
            diskJson.put((Object)"deviceName", (Object)diskInfo.getDeviceName());
            diskJson.put((Object)"devSn", (Object)diskInfo.getDevSn());
            diskJson.put((Object)"poolId", (Object)diskInfo.getPoolId());
            diskJson.put((Object)"subDiskInfo", (Object)this.getSubDiskJsonArray(diskInfo));
            array.add((Object)diskJson);
        }
        paramMap.put("releaseDiskInfo", array.toString());
        paramMap.put("storageDevSn", this.storageDevSn);
        JSONObject result = new JSONObject();
        result.put((Object)this.getClass().getSimpleName(), (Object)JSONObject.fromObject(paramMap).toString());
        return result.toString();
    }

    private JSONArray getSubDiskJsonArray(DiskInfo diskInfo) {
        JSONArray subArray = new JSONArray();
        for (SubDiskInfo subDiskInfo : diskInfo.getSubDiskInfo()) {
            JSONObject subDiskJson = new JSONObject();
            subDiskJson.put((Object)"devSn", (Object)subDiskInfo.getDevSn());
            subDiskJson.put((Object)"poolId", (Object)subDiskInfo.getPoolId());
            subArray.add((Object)subDiskJson);
        }
        return subArray;
    }

    public HypermetroRelationRollbackItem(ProtectGroup protectGroup, Set<DiskInfo> releaseDiskInfo, String storageDevSn) {
        this.protectGroup = protectGroup;
        this.releaseDiskInfo = releaseDiskInfo;
        this.storageDevSn = storageDevSn;
        this.resourceIds = new HashMap<Integer, List<String>>();
    }

    public boolean execute() {
        logger.debug((Object)"HypermetroRelationRollbackItem execute enter");
        StopHypermetroTask stopHypermetroTask = new StopHypermetroTask(this.protectGroup, this.releaseDiskInfo, this.storageDevSn);
        Future future = CachedProtectThreadPool.submit((Callable)stopHypermetroTask);
        try {
            Boolean stopHypermetro = (Boolean)future.get(300L, TimeUnit.MINUTES);
            if (stopHypermetro == null || !stopHypermetro.booleanValue()) {
                throw stopHypermetroTask.getException();
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"stopHypermetroTask error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error((Object)"StopHypermetroTask error:%s", (Throwable)e);
            throw new LegoCheckedException(1073948380L);
        }
        logger.debug((Object)"HypermetroRelationRollbackItem execute leave");
        return false;
    }

    public Map<Integer, List<String>> getResourceId() {
        return this.resourceIds;
    }
}

