/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.drm.base.rollback.RollBackTaskManager;
import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.storage.hypermetro.builder.StorageHypermetroRollbackExecutor;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HypermetroRollbackTask {
    public static final int STORAGE_SN_TYPE = 0;
    public static final int STORAGE_RESOURCE_TYPE = 1;
    public static final int HYPER_METRO_PAIR_TYPE = 2;
    public static final int HYPER_METRO_GROUP_TYPE = 3;
    private static final Log logger = LogFactory.getInstance(HypermetroRollbackTask.class);
    private static final String COLON = ":";
    private Stack<IRollbackItem> items = new Stack();

    public boolean execute(ProtectGroup protectGroup) {
        if (this.items.isEmpty()) {
            logger.info((Object)"Rollback hypermetro items is empty.");
        }
        Pair<String, String> alarmAndExePair = this.generatedAlarmAndExeParams();
        String rollbackParam = this.generatedRollBackParams(protectGroup);
        RollBackTaskInfo taskInfo = this.buildRollBackTaskInfo(protectGroup, alarmAndExePair, rollbackParam);
        RollBackTaskManager.getInstance().addTask(taskInfo, true);
        return true;
    }

    private String generatedRollBackParams(ProtectGroup protectGroup) {
        HashSet<String> vmIdSet = new HashSet<String>();
        for (ProtectObject po : protectGroup.getPolist()) {
            vmIdSet.add(po.getMoUuid());
        }
        JSONArray moUuidArray = JSONArray.fromObject(vmIdSet);
        HashMap<String, String> moUuidMap = new HashMap<String, String>();
        moUuidMap.put("moUuid", moUuidArray.toString());
        JSONObject json = JSONObject.fromObject(moUuidMap);
        return json.toString();
    }

    private RollBackTaskInfo buildRollBackTaskInfo(ProtectGroup protectGroup, Pair<String, String> alarmAndExePair, String rollbackParam) {
        RollBackTaskInfo taskInfo = new RollBackTaskInfo();
        taskInfo.setExecutor(StorageHypermetroRollbackExecutor.class.getName());
        taskInfo.setExecuteParam((String)alarmAndExePair.getRight());
        String taskId = UUIDGenerator.getUUID();
        taskInfo.setTaskId(taskId);
        taskInfo.setSourceUuid(taskId);
        taskInfo.setSourceDetail(rollbackParam);
        taskInfo.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        taskInfo.setAlarmId(Long.valueOf(52625520L));
        taskInfo.setAlarmParam((String)alarmAndExePair.getLeft());
        taskInfo.setTargetName(protectGroup.getName());
        return taskInfo;
    }

    private Pair<String, String> generatedAlarmAndExeParams() {
        HashSet<String> devSnSet = new HashSet<String>();
        HashSet<String> lunIdSet = new HashSet<String>();
        HashSet<String> pairIdSet = new HashSet<String>();
        HashSet<String> groupIdSet = new HashSet<String>();
        ArrayList<String> itemParams = new ArrayList<String>();
        while (!this.items.isEmpty()) {
            IRollbackItem item = this.items.pop();
            itemParams.add(item.toString());
            Map resourceIdMap = item.getResourceId();
            this.setResourceIdSet(devSnSet, resourceIdMap, 0);
            this.setResourceIdSet(lunIdSet, resourceIdMap, 1);
            this.setResourceIdSet(pairIdSet, resourceIdMap, 2);
            this.setResourceIdSet(groupIdSet, resourceIdMap, 3);
        }
        StringBuilder params = new StringBuilder();
        params.append(devSnSet).append(COLON).append(lunIdSet).append(COLON).append(pairIdSet).append(COLON).append(groupIdSet);
        return Pair.of((Object)params.toString(), (Object)JSONArray.fromObject(itemParams).toString());
    }

    private void setResourceIdSet(Set<String> resourceSet, Map<Integer, List<String>> resourceIdMap, int key) {
        List<String> infoList = resourceIdMap.get(key);
        if (CollectionUtils.isNotEmpty(infoList)) {
            resourceSet.addAll(infoList);
        }
    }

    public void addItem(IRollbackItem item) {
        this.items.push(item);
    }
}

