/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hypermetro.builder;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.SubDiskInfo;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderBaseDelegate;
import com.huawei.ism.drm.storage.hypermetro.builder.util.HypermetroUtil;
import com.huawei.ism.drm.storage.manager.sdk.model.EVolHypermetroVolumeInfo;
import com.huawei.ism.drm.storage.manager.sdk.model.FusionStorageHypermetroVolumeInfo;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StopHypermetroTask
implements Callable<Boolean> {
    private static final Log logger = LogFactory.getInstance(StopHypermetroTask.class);
    private static final String EVOL_URL_PREFIX = "scsi-3";
    private ProtectGroup protectGroup;
    private Set<DiskInfo> releaseDiskInfo;
    private String storageDevSn;
    private LegoCheckedException exception;

    public StopHypermetroTask(ProtectGroup protectGroup, Set<DiskInfo> releaseDiskInfo, String storageDevSn) {
        this.protectGroup = protectGroup;
        this.releaseDiskInfo = releaseDiskInfo;
        this.storageDevSn = storageDevSn;
    }

    public LegoCheckedException getException() {
        return this.exception;
    }

    public void setException(LegoCheckedException exception) {
        this.exception = exception;
    }

    @Override
    public Boolean call() {
        try {
            return this.stopHypermetro(this.releaseDiskInfo, this.storageDevSn);
        }
        catch (LegoCheckedException ex) {
            this.setException(ex);
        }
        catch (Exception ex) {
            LegoCheckedException legoCheckedException = ExceptionUtil.convertException((Throwable)ex, (String)"Stop Hypermetro error", (long)1073948473L, (String[])new String[0], (Log)logger);
            this.setException(legoCheckedException);
        }
        return false;
    }

    private Boolean stopHypermetro(Set<DiskInfo> releaseDiskInfo, String storageDevSn) {
        logger.info((Object)"Stop hypermetroTask stopHypermetro enter.");
        if (VerifyUtil.isEmpty(releaseDiskInfo)) {
            logger.warn((Object)"No disk to stop Hypermetro.");
            return true;
        }
        DiskInfo diskInfo = releaseDiskInfo.iterator().next();
        SubDiskInfo subDisk = diskInfo.getSubDiskInfo().stream().findFirst().orElse(new SubDiskInfo());
        String devSn = diskInfo.getDevSn().equals(storageDevSn) ? subDisk.getDevSn() : diskInfo.getDevSn();
        StorageUnit storageUnit = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getStorageUnitBySn(devSn);
        if (VerifyUtil.isEmpty((Object)storageUnit)) {
            String msg = "The fusionStorageUnits is empty.";
            logger.error((Object)msg);
            throw new LegoCheckedException(1073947394L, msg);
        }
        IProtectObjectBaseProvider provider = ((IProtectObjectProviderBaseDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderBaseDelegate.class)).getProviderByAppType(this.protectGroup.getPoType());
        int templateType = this.protectGroup.getTemplate().getType();
        if (templateType == 38) {
            Map<String, String> poolIdAndNameMap = HypermetroUtil.getPoolMap();
            List fsHyperVolInfos = releaseDiskInfo.stream().map(disk -> {
                FusionStorageHypermetroVolumeInfo fsHyperVolInfo = new FusionStorageHypermetroVolumeInfo();
                String poolId = this.getPoolId((DiskInfo)disk);
                fsHyperVolInfo.setUuid(disk.getDeviceName());
                fsHyperVolInfo.setStandbyDs((String)poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{devSn, poolId})));
                fsHyperVolInfo.setStandbyPoolId(poolId);
                fsHyperVolInfo.setStandbyFloatIp(storageUnit.getIpAddress());
                return fsHyperVolInfo;
            }).collect(Collectors.toList());
            provider.stopPoHyperMetro(this.protectGroup.getPoProviderSN(), fsHyperVolInfos);
        } else if (templateType == 53) {
            List<EVolHypermetroVolumeInfo> evolHyperVolInfos = this.buildEVolHypermetroVolumes(releaseDiskInfo, storageUnit);
            provider.stopPoHyperMetro(this.protectGroup.getPoProviderSN(), evolHyperVolInfos);
        } else {
            logger.error((Object)"Stop hypermetro fail, template type(%s) not supported.", new Object[]{String.valueOf(templateType)});
            throw new LegoCheckedException(1073947393L);
        }
        logger.info((Object)"StopHypermetroTask stopHypermetro leave.");
        return true;
    }

    private List<EVolHypermetroVolumeInfo> buildEVolHypermetroVolumes(Set<DiskInfo> releaseDiskInfo, StorageUnit storageUnit) {
        ArrayList<EVolHypermetroVolumeInfo> eVolHyperVolInfos = new ArrayList<EVolHypermetroVolumeInfo>();
        ProtectObject po = (ProtectObject)this.protectGroup.getPolist().stream().findAny().orElseThrow(() -> {
            logger.error((Object)"Can not find any protect object in pg(%s).", new Object[]{this.protectGroup.getName()});
            return new LegoCheckedException(1073947394L);
        });
        HashMap<String, String> diskNameWwnMap = new HashMap<String, String>();
        HashMap<String, String> diskNameIdMap = new HashMap<String, String>();
        this.buildDiskInfoInPo(po, diskNameWwnMap, diskNameIdMap);
        for (DiskInfo disk : releaseDiskInfo) {
            EVolHypermetroVolumeInfo eVolHyperVolInfo = new EVolHypermetroVolumeInfo();
            String diskName = disk.getName();
            eVolHyperVolInfo.setVolId((String)diskNameIdMap.get(diskName));
            eVolHyperVolInfo.setLunWwn((String)diskNameWwnMap.get(diskName));
            eVolHyperVolInfo.setStandbyPoolId(this.getEvolStandbyPoolId(disk));
            eVolHyperVolInfo.setStandbyControllerIps(storageUnit.getManageIps().split(","));
            eVolHyperVolInfos.add(eVolHyperVolInfo);
        }
        return eVolHyperVolInfos;
    }

    private String getEvolStandbyPoolId(DiskInfo disk) {
        if (VerifyUtil.isEmpty((Collection)disk.getSubDiskInfo())) {
            logger.error((Object)"Disk(%s) params error.", new Object[]{disk.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return ((SubDiskInfo)disk.getSubDiskInfo().get(0)).getPoolId();
    }

    private String getPoolId(DiskInfo disk) {
        SubDiskInfo subDiskInfo = disk.getSubDiskInfo().stream().findFirst().orElse(new SubDiskInfo());
        return disk.getDevSn().equals(this.storageDevSn) ? subDiskInfo.getPoolId() : disk.getPoolId();
    }

    private void buildDiskInfoInPo(ProtectObject po, Map<String, String> diskNameWwnMap, Map<String, String> diskNameIdMap) {
        JSONObject vmMgrInfo = HypermetroUtil.getPoVmMgrInfo(po.getProps());
        JSONArray disks = vmMgrInfo.getJSONObject("vmConfig").getJSONArray("disks");
        if (disks == null || disks.isEmpty()) {
            logger.error((Object)"Can not find any disk info in protect object property.");
            throw new LegoCheckedException(1073947393L);
        }
        for (JSONObject disk : disks.toBean(JSONObject.class)) {
            String volumeName = disk.getString("diskName");
            String volumeId = StringUtils.substringAfterLast((String)disk.getString("volumeUrn"), (String)":");
            String volumeWwn = StringUtils.substringAfterLast((String)disk.getString("volumeUrl"), (String)EVOL_URL_PREFIX);
            diskNameIdMap.put(volumeName, volumeId);
            diskNameWwnMap.put(volumeName, volumeWwn);
        }
    }
}

