/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica;

import com.huawei.ism.array.sdk.model.FusionStorageUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.BusinessUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSystemManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class StorageDiskHelper {
    private static final Log LOGGER = LogFactory.getInstance(StorageDiskHelper.class);
    private static final StorageDiskHelper INSTANCE = new StorageDiskHelper();
    private static final String ACCOUNT_ID = "0";
    private static final String NOT_ENCRYPTED = "0";
    private static final int NOT_SUPPORT_ENCRYPTED_DISK = 0;

    private StorageDiskHelper() {
    }

    public static StorageDiskHelper getInstance() {
        return INSTANCE;
    }

    public boolean isContainAndTgtDevNotSupportEncryptedDisk(ProtectGroup protectGroup) {
        return this.isContainEncryptedDisk(protectGroup.getPolist()) && this.isTgtDevNotSupportEncryptedDisk(protectGroup);
    }

    public String getTgtDevSN(ProtectGroup protectGroup) {
        String storagePairsStr = (String)protectGroup.getProps().get("storagePoolMapping");
        JSONObject storagePairJsonObject = JSONArray.fromObject((Object)storagePairsStr).getJSONObject(0);
        return storagePairJsonObject.getString("tgtDevSN");
    }

    public Lun getLunById(String srcDevSN, String srcLunId) {
        if (VerifyUtil.isEmpty((String)srcDevSN) || VerifyUtil.isEmpty((String)srcLunId)) {
            LOGGER.error((Object)"Failed to getLunById, cause srcDevSN or srcLunId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        IStorageLunBaseManager manager = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(srcDevSN);
        Optional srcLun = FusionStorageUnit.class.getName().equals(manager.getStorageType()) && BusinessUtil.isUltraVR() ? manager.getLunByIdV2(srcDevSN, srcLunId) : Optional.ofNullable(manager.getLunById(srcDevSN, srcLunId));
        if (!srcLun.isPresent()) {
            LOGGER.error((Object)"Source LUN is not exists, LUN ID:%s, Device SN:%s", new Object[]{srcLunId, srcDevSN});
            throw new LegoCheckedException(1073947724L, new String[]{srcLunId});
        }
        return (Lun)srcLun.get();
    }

    private boolean isTgtDevNotSupportEncryptedDisk(ProtectGroup protectGroup) {
        String tgtDevSN = this.getTgtDevSN(protectGroup);
        StorageSystemManagerProxy storageSystemManagerProxy = StorageSystemManagerProxy.getInstance();
        IStorageSystemManager storageSystemManager = storageSystemManagerProxy.getStorageLunMgrByDevId(tgtDevSN);
        JSONObject accountJson = JSONObject.fromObject((Object)storageSystemManager.queryAccounts(tgtDevSN, "0"));
        return !accountJson.containsKey((Object)"encryptOption") || accountJson.getInt("encryptOption") == 0;
    }

    private boolean isContainEncryptedDisk(Set<ProtectObject> protectObjects) {
        String poUuids = protectObjects.stream().map(ProtectObject::getMoUuid).collect(Collectors.joining(","));
        List vmConfigs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("select vm.vmConfig from GalaxVM as vm where vm.uuid in (?)", new Object[]{poUuids});
        return vmConfigs.stream().map(this::getEncryptedValues).flatMap(Collection::stream).anyMatch(encrypted -> !"0".equals(encrypted));
    }

    private List<String> getEncryptedValues(String vmConfig) {
        JSONObject vmConfigJsonObject = JSONObject.fromObject((Object)vmConfig);
        JSONArray disksJsonArray = vmConfigJsonObject.getJSONArray("disks");
        if (disksJsonArray == null) {
            LOGGER.error((Object)"Get encryptedValues failed, cause disks of vmConfig is null.");
            throw new LegoCheckedException(-1L);
        }
        ArrayList<String> encryptedValues = new ArrayList<String>();
        int arraySize = disksJsonArray.size();
        for (int i = 0; i < arraySize; ++i) {
            JSONObject diskJson = disksJsonArray.getJSONObject(i);
            if (!diskJson.containsKey((Object)"encrypted")) continue;
            encryptedValues.add(diskJson.getString("encrypted"));
        }
        return encryptedValues;
    }
}

