/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.observer;

import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;

public class RecoveryPlanOperateObserver
implements IObjectObserver {
    public static final String PG_PROP_LAST_RECOVERY_EXECUTE_TYPE_KEY = "last_recovery_plan_execute_type";
    private static Log logger = LogFactory.getInstance(RecoveryPlanOperateObserver.class);

    public void before(MessageEvent event) {
        if (!this.checkParam(event)) {
            return;
        }
    }

    public void after(MessageEvent event) {
        if (!this.checkParam(event)) {
            return;
        }
        RecoveryPlan recoveryPlan = (RecoveryPlan)CommonUtil.getFirstElement((Collection)event.getObjectList());
        ProtectGroup protectGroup = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            return;
        }
        protectGroup.getProps().put(PG_PROP_LAST_RECOVERY_EXECUTE_TYPE_KEY, String.valueOf(recoveryPlan.getLastExecuteType()));
        logger.info((Object)("update last recovery plan status for:" + protectGroup.getName()));
    }

    public String getObserverType() {
        return RecoveryPlan.class.getName();
    }

    private boolean checkParam(MessageEvent event) {
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return false;
        }
        DRMObject object = (DRMObject)CommonUtil.getFirstElement((Collection)objectList);
        if (!(object instanceof RecoveryPlan)) {
            return false;
        }
        RecoveryPlan recoveryPlan = (RecoveryPlan)object;
        ProtectGroup protectGroup = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            return false;
        }
        return protectGroup.getTemplate().getType() == 33 || protectGroup.getTemplate().getType() == 39;
    }
}

