/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceBaseService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.ICreateSnapshotHandler;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;

public class CreateSnapshotSubProcessor
extends BaseRecoveryProcessor
implements ICreateSnapshotHandler {
    private static final long serialVersionUID = -7921173469153533993L;
    private static final Log logger = LogFactory.getInstance(CreateSnapshotSubProcessor.class);
    private String replicationId;
    private String srcDeviceId;
    private String srcLunId;
    private Integer relationType;
    private String deviceId;
    private String lunId;
    private String lunName;
    private String snapshotId = null;
    private String snapshotWWN = null;
    private String snapshotNguid = null;
    private String snapshotName = null;
    private String hostOrGroupIds;

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    @Override
    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    @Override
    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setSnapshotWWN(String snapshotWWN) {
        this.snapshotWWN = snapshotWWN;
    }

    public void setSnapshotNguid(String snapshotNguid) {
        this.snapshotNguid = snapshotNguid;
    }

    @Override
    public String getSnapshotWWN() {
        return this.snapshotWWN;
    }

    public String getSnapshotNguid() {
        return this.snapshotNguid;
    }

    @Override
    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String getReplicationId() {
        return this.replicationId;
    }

    public void setReplicationId(String replicationId) {
        this.replicationId = replicationId;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public void setSrcDeviceId(String srcDeviceId) {
        this.srcDeviceId = srcDeviceId;
    }

    public void setSrcLunId(String srcLunId) {
        this.srcLunId = srcLunId;
    }

    public String getSrcLunId() {
        return this.srcLunId;
    }

    public Integer getRelationType() {
        return this.relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public void setHostOrGroupIds(String hostOrGroupIds) {
        this.hostOrGroupIds = hostOrGroupIds;
    }

    public String getHostOrGroupIds() {
        return this.hostOrGroupIds;
    }

    public boolean execute(RecoveryProcessorContext context) {
        IRecoveryResourceBaseService recoveryService = (IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class);
        Lun lun = recoveryService.getTargetLunById(this.getDeviceId(), this.getLunId());
        if (lun == null) {
            this.updateProcessName("ism.drm.recovery.create.snapshot.failed");
            this.dealFail("lego.err.1073948685", new String[]{this.getLunId(), this.getDeviceId()});
            return true;
        }
        this.setLunName(lun.getName());
        if (this.getSnapshotName() == null) {
            this.setSnapshotName(this.generateSnapshotName());
        }
        this.updateProcessNameParams(new String[]{this.getLunName(), this.getSnapshotName()});
        String dataConsistencyCheckingKey = RecoveryProcessResult.getDataConsistencyCheckingResultKey((String)this.deviceId, (String)this.lunId);
        RecoveryProcessResult processResult = context.getProcessResult();
        Boolean dataConsistencyCheckingResult = processResult.getProcessResult(dataConsistencyCheckingKey);
        if (dataConsistencyCheckingResult == null || !dataConsistencyCheckingResult.booleanValue()) {
            this.dealFail("lego.err.1073948710", new String[0]);
            return true;
        }
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        Snapshot paramSnapshot = new Snapshot();
        if (!VerifyUtil.isEmpty((String)this.getSnapshotId())) {
            paramSnapshot.setId(this.getSnapshotId());
        }
        paramSnapshot.setSnapshotName(this.getSnapshotName());
        if (VerifyUtil.isEmpty((String)this.getSnapshotId()) || !proxy.isSnapshotExist(this.getDeviceId(), paramSnapshot)) {
            try {
                Snapshot newSnapshot = this.getSnapshot(lun, proxy, paramSnapshot);
                this.setSnapshotId(String.valueOf(newSnapshot.getSnapshotId()));
                this.setSnapshotWWN(newSnapshot.getWwn());
                this.setSnapshotNguid(newSnapshot.getNguid());
            }
            catch (LegoCheckedException e) {
                this.dealFail(e.getErrorMessageKey(), new String[]{this.getSnapshotName()});
                return true;
            }
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private Snapshot getSnapshot(Lun lun, IStorageSnapshotManager proxy, Snapshot paramSnapshot) {
        ArrayList<String> srcLunIds = new ArrayList<String>();
        srcLunIds.add(lun.getLunId());
        long startTime = System.currentTimeMillis();
        Snapshot newSnapshot = proxy.createSnapshot(this.getDeviceId(), srcLunIds, paramSnapshot);
        logger.debug((Object)"Create snapshot cost time:%s.", new Object[]{String.valueOf(System.currentTimeMillis() - startTime)});
        if (newSnapshot == null) {
            logger.error((Object)"Creating snapshot failed. DevSN:%s, Name:%s, LunId:%s.", new Object[]{SecurityUtil.desensitizeId((String)this.getDeviceId()), this.getSnapshotName(), lun.getLunId()});
            throw new LegoCheckedException(1073948680L);
        }
        return newSnapshot;
    }

    private void dealFail(String errorCode, String[] errorParams) {
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail(errorCode, errorParams);
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getCreateSnapshotProcResultKey((String)this.getDeviceId(), (String)this.getLunId());
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private String generateSnapshotName() {
        StringBuilder builder = new StringBuilder();
        builder.append("DRdata_");
        builder.append(this.getLunId());
        builder.append("_");
        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
        String time = df.format(new Date());
        builder.append(time);
        builder.append(UUID.randomUUID().toString(), 0, 2);
        builder.append("_BAK");
        return builder.toString();
    }
}

