/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReplicationGroupRollbackItem
implements IRollbackItem {
    public static final int REPLICATION_PAIR_TYPE = 2;
    public static final int REPLICATION_GROUP_TYPE = 3;
    private static final long CG_NOT_EXIST_ERRORCODE = 37120037L;
    private static Log logger = LogFactory.getInstance(ReplicationGroupRollbackItem.class);
    private ReplicationGroup group;
    private Map<Integer, List<String>> resourceIds;

    public ReplicationGroupRollbackItem(ReplicationGroup group) {
        this.group = group;
        this.resourceIds = new HashMap<Integer, List<String>>();
    }

    public String toString() {
        if (null == this.group) {
            return "{}";
        }
        String groupId = this.group.getReplicationId();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"srcDevSN", (Object)this.group.getDevSn());
        jsonObject.put((Object)"tgtDevSN", (Object)this.group.getTgtDevSN());
        jsonObject.put((Object)"replicationId", (Object)groupId);
        this.resourceIds.put(3, new ArrayList());
        this.resourceIds.get(3).add(groupId);
        JSONArray jsonArray = new JSONArray();
        ArrayList pairList = new ArrayList();
        if (null != pairList) {
            for (ReplicationPair pair : pairList) {
                JSONObject pairJsonObject = new JSONObject();
                pairJsonObject.put((Object)"replicationId", (Object)pair.getReplicationId());
                jsonArray.add((Object)pairJsonObject);
            }
        }
        JSONObject result = new JSONObject();
        result.put((Object)ReplicationGroup.class.getSimpleName(), (Object)jsonObject);
        return result.toString();
    }

    public boolean execute() {
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        String srcDevSN = this.group.getSrcDevSN();
        String tgtDevSN = this.group.getTgtDevSN();
        try {
            ReplicationGroup replicationGroup = sraProxy.getReplicationGroup(srcDevSN, this.group.getReplicationId());
            if (null == replicationGroup) {
                return true;
            }
        }
        catch (LegoCheckedException e) {
            if (37120037L == e.getErrorCode()) {
                return true;
            }
            throw e;
        }
        sraProxy.splitReplication(srcDevSN, tgtDevSN, this.group.getReplicationId(), true);
        logger.warn((Object)("deleteReplicationGroup:" + this.group.getReplicationId()));
        sraProxy.deleteReplicationGroup(this.group);
        return true;
    }

    public Map<Integer, List<String>> getResourceId() {
        return this.resourceIds;
    }
}

