/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.List;

public class ReplicationPairConfiguration {
    private List<StoragePair> storagePairs;

    public ReplicationPairConfiguration(String config) {
        JSONArray jsonArray = JSONArray.fromObject((Object)config);
        this.storagePairs = JSONArray.toCollection((JSONArray)jsonArray, StoragePair.class);
    }

    public List<StoragePair> findStoragePair(String srcDevSN) {
        if (srcDevSN == null) {
            return null;
        }
        ArrayList<StoragePair> results = new ArrayList<StoragePair>();
        for (StoragePair pair : this.storagePairs) {
            if (!srcDevSN.equals(pair.getSrcDevSN())) continue;
            results.add(pair);
        }
        return results;
    }

    public StoragePair findStoragePair(String srcDevSn, String tgtDevSn) {
        if (srcDevSn == null || tgtDevSn == null) {
            return null;
        }
        StoragePair result = null;
        for (StoragePair pair : this.storagePairs) {
            if (!srcDevSn.equals(pair.getSrcDevSN()) || !tgtDevSn.equals(pair.getTgtDevSN())) continue;
            result = pair;
            break;
        }
        return result;
    }
}

