/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.drm.storage.replication.builder.DeleteReplicationPairTask;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ReplicationPairRollbackItem
implements IRollbackItem {
    private List<ReplicationPair> pairList;
    private Map<Integer, List<String>> resourceIds;
    private Integer recoveryPlanStatus;
    private List<Callable<Boolean>> taskList = new ArrayList<Callable<Boolean>>();

    public ReplicationPairRollbackItem(List<ReplicationPair> pairList, Integer recoveryPlanStatus) {
        this.pairList = pairList;
        this.recoveryPlanStatus = recoveryPlanStatus;
        this.resourceIds = new HashMap<Integer, List<String>>();
    }

    public ReplicationPairRollbackItem(List<ReplicationPair> pairList) {
        this.pairList = pairList;
        this.resourceIds = new HashMap<Integer, List<String>>();
    }

    public List<Callable<Boolean>> getTaskList() {
        return this.taskList;
    }

    public void setTaskList(List<Callable<Boolean>> taskList) {
        this.taskList = taskList;
    }

    public String toString() {
        if (VerifyUtil.isEmpty(this.pairList)) {
            return "{}";
        }
        JSONArray jsonArray = new JSONArray();
        for (ReplicationPair pair : this.pairList) {
            JSONObject jsonObject = new JSONObject();
            String srcDevSN = pair.getSrcDevSN();
            String replicationId = pair.getReplicationId();
            jsonObject.put((Object)"srcDevSN", (Object)srcDevSN);
            jsonObject.put((Object)"replicationId", (Object)replicationId);
            if (!this.resourceIds.containsKey(0)) {
                this.resourceIds.put(0, new ArrayList());
            }
            this.resourceIds.get(0).add(srcDevSN);
            if (!this.resourceIds.containsKey(1)) {
                this.resourceIds.put(1, new ArrayList());
            }
            String srcLunId = pair.getSrcLunId();
            this.resourceIds.get(1).add(srcLunId);
            if (!this.resourceIds.containsKey(2)) {
                this.resourceIds.put(2, new ArrayList());
            }
            this.resourceIds.get(2).add(replicationId);
            List tgtLunList = pair.getRepTgtLuns();
            JSONArray tgtLunJsonArray = new JSONArray();
            for (ReplicationTargetLun tgtLun : tgtLunList) {
                JSONObject tgtLunJsonObject = new JSONObject();
                tgtLunJsonObject.put((Object)"tgtDevSN", (Object)tgtLun.getTgtDevSN());
                tgtLunJsonObject.put((Object)"tgtLunId", (Object)tgtLun.getTgtLunId());
                tgtLunJsonArray.add((Object)tgtLunJsonObject);
            }
            jsonObject.put((Object)"repTgtLuns", (Object)tgtLunJsonArray);
            jsonArray.add((Object)jsonObject);
        }
        JSONObject result = new JSONObject();
        result.put((Object)ReplicationPair.class.getSimpleName(), (Object)jsonArray);
        return result.toString();
    }

    public Map<Integer, List<String>> getResourceId() {
        return this.resourceIds;
    }

    public boolean execute() {
        for (ReplicationPair pair : this.pairList) {
            DeleteReplicationPairTask task = new DeleteReplicationPairTask(pair, this.recoveryPlanStatus);
            this.taskList.add(task);
        }
        List result = ExecutionService.batchSubmit(this.taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)200, (int)30);
        return result.size() == this.pairList.size();
    }
}

