/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.action.util.VsphereTaskResultMonitor;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.discovery.util.PropertyCollectorUtil;
import com.huawei.ism.drm.vsphere.discovery.util.VsphereEnumParse;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereComputeResource;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.VspherePhysicalStorageDevice;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ArrayOfDatastoreHostMount;
import com.huawei.vmware.vim25.ArrayOfManagedObjectReference;
import com.huawei.vmware.vim25.ArrayOfScsiLun;
import com.huawei.vmware.vim25.ConfigTarget;
import com.huawei.vmware.vim25.DatastoreHostMount;
import com.huawei.vmware.vim25.DatastoreSummary;
import com.huawei.vmware.vim25.HostConfigFaultFaultMsg;
import com.huawei.vmware.vim25.HostConfigManager;
import com.huawei.vmware.vim25.HostFibreChannelHba;
import com.huawei.vmware.vim25.HostHostBusAdapter;
import com.huawei.vmware.vim25.HostInternetScsiHba;
import com.huawei.vmware.vim25.HostResignatureRescanResult;
import com.huawei.vmware.vim25.HostScsiDisk;
import com.huawei.vmware.vim25.HostSystemPowerState;
import com.huawei.vmware.vim25.HostUnresolvedVmfsExtent;
import com.huawei.vmware.vim25.HostUnresolvedVmfsResignatureSpec;
import com.huawei.vmware.vim25.HostUnresolvedVmfsResolutionResult;
import com.huawei.vmware.vim25.HostUnresolvedVmfsResolutionSpec;
import com.huawei.vmware.vim25.HostUnresolvedVmfsVolume;
import com.huawei.vmware.vim25.HostVirtualNic;
import com.huawei.vmware.vim25.InvalidStateFaultMsg;
import com.huawei.vmware.vim25.ManagedEntityStatus;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.MethodFault;
import com.huawei.vmware.vim25.NetworkSummary;
import com.huawei.vmware.vim25.NotFoundFaultMsg;
import com.huawei.vmware.vim25.ObjectContent;
import com.huawei.vmware.vim25.ObjectSpec;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertySpec;
import com.huawei.vmware.vim25.ResourceInUseFaultMsg;
import com.huawei.vmware.vim25.RuntimeFaultFaultMsg;
import com.huawei.vmware.vim25.ScsiLun;
import com.huawei.vmware.vim25.TraversalSpec;
import com.huawei.vmware.vim25.VimPortType;
import com.huawei.vmware.vim25.VirtualMachineNetworkInfo;
import com.huawei.vmware.vim25.VmfsDatastoreInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class HostSystemAction {
    private static final int MAX_RETRY = 10;
    private static final int SLEEP_TIME = 30000;
    private static final String UMOUNT_DATASTORE_RETRYTIMES_KEY = "vmware.umount.datastore.retrytimes";
    private static final Log logger = LogFactory.getInstance(HostSystemAction.class);

    public static String processStorageWwn(String storageWwn, Map<String, String> euiToIscsiMap) {
        if (VerifyUtil.isEmpty((String)storageWwn)) {
            logger.error((Object)"Unique identifier storageWwn is null\uff01");
            return storageWwn;
        }
        String prefixNaa = "naa.";
        String prefixEui = "eui.";
        String prefixTl0 = "tl0.";
        String processedStorageWwn = storageWwn;
        if (storageWwn.startsWith("naa.")) {
            processedStorageWwn = storageWwn.replace("naa.", "");
        }
        if (storageWwn.startsWith("eui.") || storageWwn.startsWith("tl0.")) {
            processedStorageWwn = storageWwn.replace("eui.", "").replace("tl0.", "");
            Lun lun = (Lun)CommonDAOLocator.getMoDao().getMo(Lun.class, "nguid", (Object)processedStorageWwn);
            if (lun != null) {
                logger.info((Object)"The Unique identifier storageWwn: [%s],  represents NGUID and replace it with Wwn: [%s].", new Object[]{storageWwn, lun.getWwn()});
                processedStorageWwn = lun.getWwn();
            }
        }
        if (!VerifyUtil.isEmpty(euiToIscsiMap) && euiToIscsiMap.containsKey(processedStorageWwn)) {
            processedStorageWwn = euiToIscsiMap.get(processedStorageWwn);
        }
        logger.debug((Object)"After process, Unique identifier storageWwn is [%s]", new Object[]{processedStorageWwn});
        return processedStorageWwn;
    }

    public List<VsphereHostSystem> queryAllHosts(String vcenterUuid) {
        logger.debug((Object)"Query all hosts in vCenter[%s].", new Object[]{vcenterUuid});
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        if (null == conn) {
            logger.error((Object)"Query all hosts in vCenter[%s], but connection is null.", new Object[]{vcenterUuid});
            throw new LegoCheckedException(1073947393L);
        }
        List<VsphereHostSystem> result = this.queryHostsByContainer(conn.getServiceContent().getRootFolder(), conn);
        return result;
    }

    public List<VsphereHostSystem> queryAllHosts(VmwareConnection conn) {
        logger.debug((Object)"queryAllHosts start");
        if (null == conn) {
            logger.error((Object)"Query all hosts, but connection is null.");
            throw new LegoCheckedException(1073947393L);
        }
        List<VsphereHostSystem> result = this.queryHostsByContainer(conn.getServiceContent().getRootFolder(), conn);
        return result;
    }

    public List<VsphereHostSystem> queryHostsByContainer(ManagedObjectReference containerMor, VmwareConnection conn) {
        logger.debug((Object)"QueryHostsByContainer start");
        if (Objects.isNull(conn)) {
            logger.error((Object)"Query all hosts by container[%s], but connection is null.", new Object[]{containerMor != null ? containerMor.getValue() : "unknown"});
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> hostList = new ArrayList<String>();
        hostList.add("HostSystem");
        ManagedObjectReference containerView = PropertyCollectorUtil.createContainerView(conn, containerMor, hostList, true);
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(containerView);
        oSpec.setSkip(Boolean.valueOf(true));
        TraversalSpec tSpec = PropertyCollectorUtil.createTraversalSpec("traverseEntities", "ContainerView", "view");
        oSpec.getSelectSet().add(tSpec);
        ArrayList<String> pathSet = new ArrayList<String>();
        pathSet.add("name");
        pathSet.add("summary.managementServerIp");
        pathSet.add("summary.overallStatus");
        pathSet.add("summary.config.product.fullName");
        pathSet.add("summary.config.product.osType");
        pathSet.add("summary.config.product.version");
        pathSet.add("runtime.powerState");
        pathSet.add("parent");
        pathSet.add("config.storageDevice.scsiLun");
        pathSet.add("config.network.vnic");
        pathSet.add("config.storageDevice.hostBusAdapter");
        PropertySpec hostSpec = PropertyCollectorUtil.createPropertySpec("HostSystem", pathSet);
        ArrayList<ObjectSpec> objectSet = new ArrayList<ObjectSpec>();
        objectSet.add(oSpec);
        ArrayList<PropertySpec> propSet = new ArrayList<PropertySpec>();
        propSet.add(hostSpec);
        List<PropertyFilterSpec> fSpecList = PropertyCollectorUtil.createPropertyFilterSpecList(objectSet, propSet);
        List<ObjectContent> queryResult = PropertyCollectorUtil.retrievePropertiesEx(conn, fSpecList);
        VMAction.destroyContainerView(containerView, conn.getVimPort());
        ArrayList<VsphereHostSystem> result = new ArrayList<VsphereHostSystem>();
        for (ObjectContent oc : queryResult) {
            VsphereHostSystem host = this.parseHostSystem(oc, conn.getVcenterUuid());
            if (VerifyUtil.isEmpty((Object)host)) continue;
            result.add(host);
        }
        return result;
    }

    public List<String> queryNetworks(String vcenterUuid, String hostUuid) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            ManagedObjectReference hostSystemMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(hostUuid, "HostSystem");
            ManagedObjectReference computeMor = (ManagedObjectReference)GetMoPropsValueUtils.getInstance().entityProps(conn, hostSystemMor, new String[]{"parent"}).get("parent");
            ManagedObjectReference envBrowseMor = (ManagedObjectReference)GetMoPropsValueUtils.getInstance().entityProps(conn, computeMor, new String[]{"environmentBrowser"}).get("environmentBrowser");
            ConfigTarget configTarget = vimPort.queryConfigTarget(envBrowseMor, hostSystemMor);
            if (configTarget.getNetwork() != null) {
                for (int i = 0; i < configTarget.getNetwork().size(); ++i) {
                    VirtualMachineNetworkInfo netInfo = (VirtualMachineNetworkInfo)configTarget.getNetwork().get(i);
                    NetworkSummary netSummary = netInfo.getNetwork();
                    if (!netSummary.isAccessible()) continue;
                    String networkName = netSummary.getName();
                    result.add(networkName);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"query host system networks failed.", (long)-1L, null, (Log)logger);
        }
        return result;
    }

    public void rescanAllHba(String vcenterUuid, String hostMoId) {
        logger.debug((Object)"Rescan all HBA: vcenterUuid[%s], hostMoId[%s]", new Object[]{vcenterUuid, hostMoId});
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)hostMoId)) {
            logger.error((Object)"Rescan all HBA, but parameter is empty: vcenterUuid[%s], hostMoId[%s]", new Object[]{vcenterUuid, hostMoId});
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObjectReference hostMor = new ManagedObjectReference();
        hostMor.setType("HostSystem");
        hostMor.setValue(hostMoId);
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            ManagedObjectReference storMor = (ManagedObjectReference)GetMoPropsValueUtils.getInstance().entityProps(conn, hostMor, new String[]{"configManager.storageSystem"}).get("configManager.storageSystem");
            if (VerifyUtil.isEmpty((Object)storMor)) {
                logger.error((Object)"cant get host storageSystem mor", 90160758786989L);
                throw new LegoCheckedException(1073948871L);
            }
            VimPortType vimPort = conn.getVimPort();
            vimPort.rescanAllHba(storMor);
        }
        catch (HostConfigFaultFaultMsg e) {
            logger.error((Object)("resacnHba failed:hostMoId=" + hostMoId), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948871L, (Throwable)e);
        }
        catch (RuntimeFaultFaultMsg e) {
            logger.error((Object)("resacnHba failed:hostMoId=" + hostMoId), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948871L, (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("resacnHba failed:hostMoId=" + hostMoId), (long)1073948871L, null, (Log)logger);
        }
    }

    public void rescanVmfs(String vcenterUuid, String hostMoId) {
        logger.debug((Object)"Start Rescan all vmfs: vcenterUuid[%s], hostMoId[%s]", new Object[]{vcenterUuid, hostMoId});
        long startMili = System.currentTimeMillis();
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)hostMoId)) {
            logger.error((Object)"Rescan all vmfs, but parameter is empty: vcenterUuid[%s], hostMoId[%s]", new Object[]{vcenterUuid, hostMoId});
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObjectReference hostMor = new ManagedObjectReference();
        hostMor.setType("HostSystem");
        hostMor.setValue(hostMoId);
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            ManagedObjectReference storMor = (ManagedObjectReference)GetMoPropsValueUtils.getInstance().entityProps(conn, hostMor, new String[]{"configManager.storageSystem"}).get("configManager.storageSystem");
            if (VerifyUtil.isEmpty((Object)storMor)) {
                logger.error((Object)("cant get host storageSystem mor:hostMoId=" + hostMoId), 90160758786989L);
                throw new LegoCheckedException(1073948898L);
            }
            VimPortType vimPort = conn.getVimPort();
            vimPort.rescanVmfs(storMor);
            long endMili = System.currentTimeMillis();
            logger.debug((Object)"Finished Rescan all vmfs: vcenterUuid[%s], hostMoId[%s], executeTime[%s]", new Object[]{vcenterUuid, hostMoId, (endMili - startMili) / 1000L});
        }
        catch (HostConfigFaultFaultMsg e) {
            logger.error((Object)("rescanvmfs failed:hostMoId=" + hostMoId), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948898L, (Throwable)e);
        }
        catch (RuntimeFaultFaultMsg e) {
            logger.error((Object)("rescanvmfs failed:hostMoId=" + hostMoId), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948898L, (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("rescanvmfs failed:hostMoId=" + hostMoId), (long)1073948898L, null, (Log)logger);
        }
    }

    public boolean isHostPowerOn(String vcenterUuid, String hostMoId) {
        logger.debug((Object)"Check if the host is power on: vcenterUuid[%s], hostMoId[%s]", new Object[]{vcenterUuid, hostMoId});
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        ManagedObjectReference hostMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(hostMoId, "HostSystem");
        HostSystemPowerState state = (HostSystemPowerState)GetMoPropsValueUtils.getInstance().entityProps(conn, hostMor, new String[]{"summary.runtime.powerState"}).get("summary.runtime.powerState");
        return HostSystemPowerState.POWERED_ON == state;
    }

    public void mountDataStore(String vcenterUuid, String hostMoId, String datastoreMoId) {
        boolean isAccessible;
        logger.debug((Object)"Start to mount dataStore: vcenterUuid[%s], hostMoId[%s], datastoreMoId[%s].", new Object[]{vcenterUuid, hostMoId, datastoreMoId});
        ArrayOfDatastoreHostMount dsHostMount = null;
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        VimPortType vimPort = conn.getVimPort();
        List<String> hostItems = Arrays.asList("name", "configManager");
        Map<ManagedObjectReference, Map<String, Object>> hostDynamicProps = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "HostSystem", hostItems);
        HostConfigManager hcm = new HostConfigManager();
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> result : hostDynamicProps.entrySet()) {
            Map<String, Object> props = result.getValue();
            if (!hostMoId.equals(result.getKey().getValue())) continue;
            hcm = (HostConfigManager)props.get("configManager");
            break;
        }
        if (hcm == null) {
            logger.error((Object)"Hcm is null,hostMoId=%s", new Object[]{hostMoId});
            return;
        }
        List<String> dsItems = Arrays.asList("info", "host");
        String dsUuid = "";
        Map<ManagedObjectReference, Map<String, Object>> dsDynamicProps = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "Datastore", dsItems);
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> dsPropEntry : dsDynamicProps.entrySet()) {
            ManagedObjectReference mor = dsPropEntry.getKey();
            Object infoObj = dsPropEntry.getValue().get("info");
            if (!datastoreMoId.equals(mor.getValue()) || !(infoObj instanceof VmfsDatastoreInfo)) continue;
            VmfsDatastoreInfo vdi = (VmfsDatastoreInfo)infoObj;
            dsUuid = vdi.getVmfs().getUuid();
            dsHostMount = (ArrayOfDatastoreHostMount)dsPropEntry.getValue().get("host");
            break;
        }
        if (!(isAccessible = this.checkDataStoreIsMountOnHost(hostMoId, dsHostMount))) {
            try {
                this.mountVmfsVolume(vimPort, hcm, dsUuid, datastoreMoId);
            }
            catch (LegoCheckedException ex) {
                if (ex.getErrorCode() == 1073947394L) {
                    logger.info((Object)"Cant find datastore, do rescan and try again: hostMoId=%s", new Object[]{hostMoId});
                    this.rescanVmfs(vcenterUuid, hostMoId);
                    logger.info((Object)"Try to mount datastore again: dsUuid=%s, dsMoId=%s", new Object[]{dsUuid, datastoreMoId});
                    this.mountVmfsVolume(vimPort, hcm, dsUuid, datastoreMoId);
                }
                throw ex;
            }
        }
    }

    private boolean checkDataStoreIsMountOnHost(String hostMoId, ArrayOfDatastoreHostMount dsHostMount) {
        boolean isAccessible = false;
        if (null != dsHostMount) {
            List hostMounts = dsHostMount.getDatastoreHostMount();
            for (DatastoreHostMount hostMount : hostMounts) {
                if (!hostMoId.equals(hostMount.getKey().getValue())) continue;
                isAccessible = hostMount.getMountInfo().isAccessible();
                break;
            }
        }
        return isAccessible;
    }

    private void mountVmfsVolume(VimPortType vimPort, HostConfigManager hcm, String dsUuid, String dsMoId) {
        try {
            vimPort.mountVmfsVolume(hcm.getStorageSystem(), dsUuid);
        }
        catch (InvalidStateFaultMsg e) {
            logger.error((Object)("mount datastore - " + dsMoId + "  to host system failed."), 90160758786989L);
            throw new LegoCheckedException(1073948877L, (Throwable)e);
        }
        catch (NotFoundFaultMsg e) {
            logger.error((Object)("mount datastore - " + dsMoId + "  to host system failed."), 90160758786989L);
            throw new LegoCheckedException(1073947394L, (Throwable)e);
        }
        catch (ResourceInUseFaultMsg e) {
            logger.error((Object)("mount datastore - " + dsMoId + "  to host system failed."), 90160758786989L);
            throw new LegoCheckedException(1073948878L, (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("mount datastore - " + dsMoId + "  to host system failed."), (long)1073948876L, null, (Log)logger);
        }
    }

    public DatastoreSummary getDatastoreSummary(String vcenterUuid, String id) {
        logger.debug((Object)"getDatastoreSummary start");
        DatastoreSummary summary = null;
        ArrayList<String> dsItems = new ArrayList<String>();
        dsItems.add("name");
        dsItems.add("info");
        dsItems.add("summary");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        Map<ManagedObjectReference, Map<String, Object>> dsDynamicProps = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "Datastore", dsItems);
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> dsPropEntry : dsDynamicProps.entrySet()) {
            Object infoObj = dsPropEntry.getValue().get("info");
            if (VerifyUtil.isEmpty((Object)infoObj) || !(infoObj instanceof VmfsDatastoreInfo)) continue;
            VmfsDatastoreInfo vdi = (VmfsDatastoreInfo)infoObj;
            String uuid = vdi.getVmfs().getUuid();
            ManagedObjectReference mor = dsPropEntry.getKey();
            if (!id.equals(mor.getValue()) && !id.equals(uuid)) continue;
            summary = (DatastoreSummary)dsPropEntry.getValue().get("summary");
            break;
        }
        return summary;
    }

    public boolean isUnmountedDatastore(String vcenterUuid, String datastoreId) {
        logger.debug((Object)"isUnmountedDatastore start");
        DatastoreSummary summary = this.getDatastoreSummary(vcenterUuid, datastoreId);
        return null == summary || !summary.isAccessible();
    }

    public void unmountDataStore(String vcenterUuid, String hostMoId, String datastoreUuid) {
        try {
            logger.debug((Object)"Start to unmount dataStore: vcenterUuid[%s], hostMoId[%s], datastoreUuid[%s]", new Object[]{vcenterUuid, hostMoId, datastoreUuid});
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            ArrayList<String> hostItems = new ArrayList<String>();
            hostItems.add("configManager");
            Map<ManagedObjectReference, Map<String, Object>> hostDynamicProps = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "HostSystem", hostItems);
            HostConfigManager hcm = new HostConfigManager();
            for (Map.Entry<ManagedObjectReference, Map<String, Object>> result : hostDynamicProps.entrySet()) {
                Map<String, Object> props = result.getValue();
                if (!hostMoId.equals(result.getKey().getValue())) continue;
                hcm = (HostConfigManager)props.get("configManager");
                break;
            }
            if (null == hcm) {
                logger.error((Object)("hcm is null,hostMoId=" + hostMoId));
                return;
            }
            vimPort.unmountVmfsVolume(hcm.getStorageSystem(), datastoreUuid);
        }
        catch (InvalidStateFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unmount datastore - " + datastoreUuid + "  from host system failed."), (long)1073948877L, (String[])new String[0], (Log)logger);
        }
        catch (ResourceInUseFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unmount datastore - " + datastoreUuid + "  from host system failed."), (long)1073948878L, (String[])new String[0], (Log)logger);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("unmount datastore - " + datastoreUuid + "  from host system failed."), (long)1073948879L, null, (Log)logger);
        }
    }

    public void unmountDataStoreByUuid(String vcenterUuid, String datastoreUuid) {
        long ret = LegoConfig.getInstance().getNumber(UMOUNT_DATASTORE_RETRYTIMES_KEY, 3L);
        AtomicLong retryTimes = new AtomicLong(ret);
        while (true) {
            try {
                logger.debug((Object)"Start to mount dataStore by uuid: vcenterUuid[%s], datastoreUuid[%s]", new Object[]{vcenterUuid, datastoreUuid});
                boolean dsIsExist = false;
                VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
                VimPortType vimPort = conn.getVimPort();
                ArrayOfDatastoreHostMount dsHostMount = null;
                ArrayList<String> dsItems = new ArrayList<String>();
                dsItems.add("info");
                dsItems.add("host");
                Map<ManagedObjectReference, Map<String, Object>> dsDynamicProps = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "Datastore", dsItems);
                for (Map.Entry<ManagedObjectReference, Map<String, Object>> dsPropEntry : dsDynamicProps.entrySet()) {
                    String dsUuid;
                    Object dsInfo = dsPropEntry.getValue().get("info");
                    if (!(dsInfo instanceof VmfsDatastoreInfo) || !datastoreUuid.equals(dsUuid = ((VmfsDatastoreInfo)dsInfo).getVmfs().getUuid())) continue;
                    dsIsExist = true;
                    dsHostMount = (ArrayOfDatastoreHostMount)dsPropEntry.getValue().get("host");
                }
                if (!dsIsExist) {
                    logger.info((Object)"datastore not exist.");
                    return;
                }
                if (null == dsHostMount) {
                    throw new LegoCheckedException("dsHostMount is null.");
                }
                List hostMounts = dsHostMount.getDatastoreHostMount();
                Set<String> hostMoIds = this.getHostMiIdsForMount(hostMounts);
                ArrayList<String> hostItems = new ArrayList<String>();
                hostItems.add("configManager");
                Map<ManagedObjectReference, Map<String, Object>> hostDynamicProps = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "HostSystem", hostItems);
                for (Map.Entry<ManagedObjectReference, Map<String, Object>> result : hostDynamicProps.entrySet()) {
                    Map<String, Object> props = result.getValue();
                    if (!hostMoIds.contains(result.getKey().getValue())) continue;
                    vimPort.unmountVmfsVolume(((HostConfigManager)props.get("configManager")).getStorageSystem(), datastoreUuid);
                    logger.debug((Object)("unmount ds success by host " + result.getKey().getValue() + " and ds uuid "), 90160758786988L);
                }
                logger.info((Object)"unmount datastore success. datastoreUuid:%s", new Object[]{datastoreUuid});
                return;
            }
            catch (Exception e) {
                this.handleUmountDatastoreException(e, datastoreUuid, retryTimes);
                if (retryTimes.get() >= 0L) continue;
                return;
            }
            break;
        }
    }

    private void handleUmountDatastoreException(Exception e, String datastoreUuid, AtomicLong retryTimes) {
        logger.error((Object)"umount dataStore failed. datastoreUuid:%s", new Object[]{datastoreUuid});
        if (retryTimes.getAndDecrement() > 0L) {
            CommonUtil.sleep((long)TimeUnit.SECONDS.toMillis(5L));
            return;
        }
        long errorCode = 1073948879L;
        if (e instanceof InvalidStateFaultMsg) {
            errorCode = 1073948877L;
        }
        if (e instanceof ResourceInUseFaultMsg) {
            errorCode = 1073948878L;
        }
        ExceptionUtil.rethrowException((Throwable)e, (String)("unmount datastore - " + datastoreUuid + "  from host system failed."), (long)errorCode, null, (Log)logger);
    }

    private Set<String> getHostMiIdsForMount(List<DatastoreHostMount> hostMounts) {
        HashSet<String> hostMoId = new HashSet<String>();
        for (DatastoreHostMount hostMount : hostMounts) {
            if (!hostMount.getMountInfo().isMounted().booleanValue()) continue;
            hostMoId.add(hostMount.getKey().getValue());
        }
        return hostMoId;
    }

    public void mountScsiLUN(String vcenterUuid, String hostMoId, String lunWWN) {
        logger.debug((Object)"Start to mount scsi lun: vcenterUuid[%s], hostMoId[%s], lunWwn[%s].", new Object[]{vcenterUuid, hostMoId, lunWWN});
        Set<String> hostMoIds = this.getAllHostMoIdsFromCluster(vcenterUuid, hostMoId);
        HashMap<String, ArrayOfScsiLun> hostLuns = new HashMap<String, ArrayOfScsiLun>();
        HashMap<String, HostConfigManager> hostManagers = new HashMap<String, HostConfigManager>();
        this.getHostScsiLunInfo(vcenterUuid, hostMoIds, hostLuns, hostManagers);
        for (Map.Entry<String, ArrayOfScsiLun> entry : hostLuns.entrySet()) {
            this.mountScsiLunFromCluster(vcenterUuid, entry, hostManagers, lunWWN);
        }
    }

    private void mountScsiLunFromCluster(String vcenterUuid, Map.Entry<String, ArrayOfScsiLun> entry, Map<String, HostConfigManager> hostManagers, String lunWWN) {
        logger.debug((Object)"Start to mount scsi lun from cluster: vcenterUuid[%s], lunWwn[%s].", new Object[]{vcenterUuid, lunWWN});
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        ArrayOfScsiLun scsiLUNarr = entry.getValue();
        List scsiLuns = scsiLUNarr.getScsiLun();
        HostConfigManager hostcfgMgr = hostManagers.get(entry.getKey());
        if (null == hostcfgMgr) {
            logger.error((Object)("hostconfgimanager is null,key=" + entry.getKey()));
            return;
        }
        ManagedObjectReference hostMor = hostcfgMgr.getStorageSystem();
        for (ScsiLun lun : scsiLuns) {
            String canName = lun.getCanonicalName();
            if (!canName.contains(lunWWN)) continue;
            this.attachScsiLunOnHost(lunWWN, conn, hostMor, lun);
        }
    }

    private void attachScsiLunOnHost(String lunWWN, VmwareConnection conn, ManagedObjectReference hostMor, ScsiLun lun) {
        List lunState = lun.getOperationalState();
        String uuid = lun.getUuid();
        if (!VerifyUtil.isEmpty((Collection)lunState) && "off".equals(lunState.get(0))) {
            try {
                conn.getVimPort().attachScsiLun(hostMor, uuid);
            }
            catch (HostConfigFaultFaultMsg e) {
                logger.error((Object)("mount lun - " + lunWWN + "  to host system failed."), (Throwable)e, 90160758786989L);
                throw new LegoCheckedException(1073948874L, (Throwable)e);
            }
            catch (InvalidStateFaultMsg e) {
                logger.error((Object)("mount lun - " + lunWWN + "  to host system failed."), (Throwable)e, 90160758786989L);
                throw new LegoCheckedException(1073948875L, (Throwable)e);
            }
            catch (NotFoundFaultMsg e) {
                logger.error((Object)("mount lun - " + lunWWN + "  to host system failed."), (Throwable)e, 90160758786989L);
                throw new LegoCheckedException(1073947394L, (Throwable)e);
            }
            catch (RuntimeFaultFaultMsg e) {
                logger.error((Object)("mount lun - " + lunWWN + "  to host system failed."), (Throwable)e, 90160758786989L);
                throw new LegoCheckedException(1073948874L, (Throwable)e);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("mount lun - " + lunWWN + " from host system failed."), (long)1073948874L, null, (Log)logger);
            }
        }
    }

    public void unmountScsiLunByWwn(String vcenterUuid, String hostMoId, String lunWwn) {
        logger.debug((Object)"Start to unmount scsi lun: vcenterUuid[%s], lunWwn[%s].", new Object[]{vcenterUuid, lunWwn});
        Set<String> hostMoIds = this.getAllHostMoIdsFromCluster(vcenterUuid, hostMoId);
        HashMap<String, ArrayOfScsiLun> hostLuns = new HashMap<String, ArrayOfScsiLun>();
        HashMap<String, HostConfigManager> hostManagers = new HashMap<String, HostConfigManager>();
        this.getHostScsiLunInfo(vcenterUuid, hostMoIds, hostLuns, hostManagers);
        for (Map.Entry<String, ArrayOfScsiLun> entry : hostLuns.entrySet()) {
            this.unMountScsiLunFromCluster(vcenterUuid, entry, hostManagers, lunWwn);
        }
    }

    private void unMountScsiLunFromCluster(String vcenterUuid, Map.Entry<String, ArrayOfScsiLun> entry, Map<String, HostConfigManager> hostManagers, String lunWwn) {
        logger.debug((Object)"Start to unmount scsi lun from cluster: vcenterUuid[%s], lunWwn[%s].", new Object[]{vcenterUuid, lunWwn});
        if (VerifyUtil.isEmpty(hostManagers)) {
            logger.error((Object)"hostManagers is null");
            return;
        }
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        VimPortType vimPort = conn.getVimPort();
        ArrayOfScsiLun scsiLUNarr = entry.getValue();
        List scsiLuns = scsiLUNarr.getScsiLun();
        ManagedObjectReference hostMor = hostManagers.get(entry.getKey()).getStorageSystem();
        for (ScsiLun lun : scsiLuns) {
            String canName = lun.getCanonicalName();
            if (!canName.contains(lunWwn)) continue;
            this.detachScsiLunOnHost(lunWwn, vimPort, hostMor, lun);
        }
    }

    private void detachScsiLunOnHost(String lunWwn, VimPortType vimPort, ManagedObjectReference hostMor, ScsiLun lun) {
        logger.debug((Object)"Start to detach scsi lun: hostId[%s], lunWwn[%s].", new Object[]{hostMor != null ? hostMor.getValue() : "unknown", lunWwn});
        List lunState = lun.getOperationalState();
        String uuid = lun.getUuid();
        if (!VerifyUtil.isEmpty((Collection)lunState) && !"off".equals(lunState.get(0))) {
            try {
                vimPort.detachScsiLun(hostMor, uuid);
            }
            catch (InvalidStateFaultMsg e) {
                logger.error((Object)("unmount lun - " + lunWwn + " from host system failed."), (Throwable)e, 90160758786989L);
                throw new LegoCheckedException(1073948875L, (Throwable)e);
            }
            catch (NotFoundFaultMsg e) {
                logger.error((Object)("unmount lun - " + lunWwn + " from host system failed."), (Throwable)e, 90160758786989L);
                throw new LegoCheckedException(1073947394L, (Throwable)e);
            }
            catch (ResourceInUseFaultMsg e) {
                logger.error((Object)("unmount lun - " + lunWwn + " from host system failed."), (Throwable)e, 90160758786989L);
                throw new LegoCheckedException(1073948872L, (Throwable)e);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("unmount lun - " + lunWwn + " from host system failed."), (long)1073948873L, null, (Log)logger);
            }
        }
    }

    private void getHostScsiLunInfo(String vcenterUuid, Set<String> hostMoIds, Map<String, ArrayOfScsiLun> hostLuns, Map<String, HostConfigManager> hostManagers) {
        logger.debug((Object)"unMountScsiLunFromCluster start");
        ArrayList<String> items = new ArrayList<String>();
        items.add("name");
        items.add("configManager");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        items.add("config.storageDevice.scsiLun");
        Map<ManagedObjectReference, Map<String, Object>> dynamicPropsMap = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "HostSystem", items);
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> result : dynamicPropsMap.entrySet()) {
            Map<String, Object> props = result.getValue();
            if (!hostMoIds.contains(result.getKey().getValue())) continue;
            ArrayOfScsiLun scsiLUNarr = (ArrayOfScsiLun)props.get("config.storageDevice.scsiLun");
            scsiLUNarr.getScsiLun().forEach(item -> item.setCanonicalName(HostSystemAction.processStorageWwn(item.getCanonicalName(), null)));
            HostConfigManager hcm = (HostConfigManager)props.get("configManager");
            hostLuns.put(result.getKey().getValue(), scsiLUNarr);
            hostManagers.put(result.getKey().getValue(), hcm);
        }
    }

    public Set<String> getAllHostMoIdsFromCluster(String vcenterUuid, String hostMoId) {
        ManagedObjectReference hostMor;
        logger.debug((Object)"Get all host's moId from cluster: vcenterUuid[%s], hostMoId[%s].", new Object[]{vcenterUuid, hostMoId});
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)hostMoId)) {
            logger.error((Object)"Get all host's moId from cluster, but parameter is empty: vcenterUuid[%s], hostMoId[%s].", new Object[]{vcenterUuid, hostMoId});
            throw new LegoCheckedException(1073947393L);
        }
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
        ManagedObjectReference compMor = (ManagedObjectReference)util.entityProps(conn, hostMor = util.getMorByObjUuid(hostMoId, "HostSystem"), new String[]{"parent"}).get("parent");
        if (null == compMor) {
            logger.error((Object)("parent is null, hostMoid=" + hostMoId));
            return new HashSet<String>();
        }
        return this.getAllHostsByComputeResId(vcenterUuid, compMor.getValue());
    }

    public Set<String> getAllHostsByComputeResId(String vcenterUuid, String computeResId) {
        logger.debug((Object)"Get all hosts by compute resource: vcenterUuid[%s], computeResId[%s].", new Object[]{vcenterUuid, computeResId});
        HashSet<String> hostMoIdSet = new HashSet<String>();
        GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        ManagedObjectReference compMor = util.getMorByObjUuid(computeResId, "ComputeResource");
        ArrayOfManagedObjectReference morList = (ArrayOfManagedObjectReference)util.entityProps(conn, compMor, new String[]{"host"}).get("host");
        if (null == morList) {
            logger.error((Object)("hostMoIdSet is null, computeResId=" + computeResId));
            return hostMoIdSet;
        }
        for (ManagedObjectReference hostMor : morList.getManagedObjectReference()) {
            HostSystemPowerState state = (HostSystemPowerState)util.entityProps(conn, hostMor, new String[]{"runtime.powerState"}).get("runtime.powerState");
            if (HostSystemPowerState.POWERED_ON == state) {
                hostMoIdSet.add(hostMor.getValue());
                continue;
            }
            logger.error((Object)("The host " + hostMor.getValue() + " is power off,compresUuid=" + computeResId));
        }
        return hostMoIdSet;
    }

    public ManagedObjectReference resignatureUnsolvedVmfs(String vcenterUuid, String hostMoId, String unSolvedDsName, List<HostUnresolvedVmfsVolume> vols, List<String> wwnList) {
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        VimPortType vimPort = conn.getVimPort();
        ManagedObjectReference hostMor = new ManagedObjectReference();
        hostMor.setType("HostSystem");
        hostMor.setValue(hostMoId);
        GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
        HostConfigManager hcm = (HostConfigManager)util.entityProps(conn, hostMor, new String[]{"configManager"}).get("configManager");
        if (null == hcm) {
            logger.error((Object)("hcm is null,hostMoId=" + hostMoId));
            throw new LegoCheckedException(1073948898L);
        }
        String devicePath = this.getDevPath(vols, wwnList, unSolvedDsName);
        if (VerifyUtil.isEmpty((String)devicePath)) {
            logger.error((Object)("mount unresolved datastore:" + unSolvedDsName + " to host:" + hostMoId + " system failed.cant find device path info. wwnlist=" + wwnList), 90160758786989L);
            throw new LegoCheckedException(1073948898L);
        }
        logger.debug((Object)"get devpath successful,device path= %s, wwnlist= %s, %x", new Object[]{devicePath, wwnList, 90160758786988L});
        HostUnresolvedVmfsResignatureSpec spec = new HostUnresolvedVmfsResignatureSpec();
        spec.getExtentDevicePath().add(devicePath);
        ManagedObjectReference newDsMor = null;
        try {
            ManagedObjectReference opTask = vimPort.resignatureUnresolvedVmfsVolumeTask(hcm.getDatastoreSystem(), spec);
            MethodFault fault = new VsphereTaskResultMonitor(conn, opTask).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)fault)) {
                HostResignatureRescanResult ret = (HostResignatureRescanResult)util.entityProps(conn, opTask, new String[]{"info.result"}).get("info.result");
                if (null == ret) {
                    logger.error((Object)("get  resignatureUnresolvedVmfsVolumeTask result failed,hostMoid=" + hostMoId));
                    return null;
                }
                newDsMor = ret.getResult();
            }
        }
        catch (Exception e) {
            logger.error((Object)("mount unresolved datastore - " + unSolvedDsName + " to host system failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            ExceptionUtil.rethrowException((Exception)e, (String)"resignatureunresolvedvmfs failed:", (long)1073948898L, (String[])new String[0]);
        }
        return newDsMor;
    }

    public List<HostUnresolvedVmfsResolutionResult> mountUnSolvedDataStore(String vcenterUuid, String hostMoId, String unSolvedDsName, List<HostUnresolvedVmfsVolume> vols, List<String> wwnList) {
        VerifyUtil.checkObjs((Object[])new Object[]{vcenterUuid, hostMoId, vols, wwnList});
        HostUnresolvedVmfsResolutionSpec vrSpec = new HostUnresolvedVmfsResolutionSpec();
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            ManagedObjectReference hostMor = new ManagedObjectReference();
            hostMor.setType("HostSystem");
            hostMor.setValue(hostMoId);
            GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
            HostConfigManager hcm = (HostConfigManager)util.entityProps(conn, hostMor, new String[]{"configManager"}).get("configManager");
            if (null == hcm) {
                logger.error((Object)("hcm is null,hostMoId=" + hostMoId));
                throw new LegoCheckedException(1073948898L);
            }
            String devicePath = null;
            for (int time = 0; time < 10; ++time) {
                if (null == unSolvedDsName) {
                    devicePath = this.getDevPath(vols, wwnList);
                    unSolvedDsName = "";
                } else {
                    devicePath = this.getDevPath(vols, wwnList, unSolvedDsName);
                }
                if (!VerifyUtil.isEmpty((String)devicePath)) break;
                logger.warn((Object)("Need to retry, can not find the dev path for wwn:" + wwnList + ", retry times:" + time));
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"thread wakeup.");
                }
                List<HostUnresolvedVmfsVolume> tmpVols = this.queryUnresolvedVmfsVolume(vcenterUuid, hostMoId);
                this.mergeUnResolvedVM(vols, tmpVols);
            }
            if (VerifyUtil.isEmpty(devicePath)) {
                logger.error((Object)("mount unresolved datastore:" + unSolvedDsName + " to host:" + hostMoId + " system failed.cant find device path info. wwnlist=" + wwnList), 90160758786989L);
                throw new LegoCheckedException(1073948898L);
            }
            logger.debug((Object)("get devpath successful,device path=" + devicePath + " wwnlist=" + wwnList), 90160758786988L);
            ArrayList<HostUnresolvedVmfsResolutionSpec> vrSpecs = new ArrayList<HostUnresolvedVmfsResolutionSpec>();
            vrSpec.getExtentDevicePath().add(devicePath);
            vrSpec.setUuidResolution("resignature");
            vrSpecs.add(vrSpec);
            List results = vimPort.resolveMultipleUnresolvedVmfsVolumes(hcm.getStorageSystem(), vrSpecs);
            return results;
        }
        catch (HostConfigFaultFaultMsg e) {
            logger.error((Object)("mount unresolved datastore - " + unSolvedDsName + " to host system failed."), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948898L, (Throwable)e);
        }
        catch (RuntimeFaultFaultMsg e) {
            logger.error((Object)("mount unresolved datastore - " + unSolvedDsName + " to host system failed."), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948898L, (Throwable)e);
        }
    }

    private String getDevPath(List<HostUnresolvedVmfsVolume> vols, List<String> wwnList) {
        String devPath = null;
        logger.info((Object)("get device path: wwnList=" + wwnList));
        for (HostUnresolvedVmfsVolume vol : vols) {
            List extendList = vol.getExtent();
            for (HostUnresolvedVmfsExtent extend : extendList) {
                if (!extend.isIsHeadExtent()) continue;
                String diskName = extend.getDevice().getDiskName();
                if (null == diskName) {
                    logger.error((Object)"diskName is null");
                    throw new LegoCheckedException(0x300001L);
                }
                int index = diskName.indexOf(".");
                String tempWwn = diskName.substring(index + 1);
                logger.info((Object)("tempwwn=" + tempWwn));
                if (!wwnList.contains(tempWwn)) continue;
                devPath = extend.getDevicePath();
                if (wwnList.size() == extendList.size()) break;
                throw new LegoCheckedException(1073948903L);
            }
            if (VerifyUtil.isEmpty(devPath)) continue;
            break;
        }
        return devPath;
    }

    private List<HostUnresolvedVmfsVolume> mergeUnResolvedVM(List<HostUnresolvedVmfsVolume> des, List<HostUnresolvedVmfsVolume> src) {
        ArrayList<String> vmUuidList = new ArrayList<String>(des.size());
        for (HostUnresolvedVmfsVolume volume : des) {
            vmUuidList.add(volume.getVmfsUuid());
        }
        for (HostUnresolvedVmfsVolume volume : src) {
            if (vmUuidList.contains(volume.getVmfsUuid())) continue;
            des.add(volume);
        }
        return des;
    }

    private String getDevPath(List<HostUnresolvedVmfsVolume> vols, List<String> wwnList, String tgtDsName) {
        String devPath = null;
        logger.info((Object)("get device path:tgtDsName=" + tgtDsName + " wwnList=" + wwnList));
        for (HostUnresolvedVmfsVolume vol : vols) {
            String label = vol.getVmfsLabel();
            if (!tgtDsName.equals(label)) {
                logger.info((Object)("unresolved vmfs label=" + label));
                continue;
            }
            List extendList = vol.getExtent();
            if (wwnList.size() != extendList.size()) {
                throw new LegoCheckedException(1073948903L);
            }
            for (HostUnresolvedVmfsExtent extend : extendList) {
                if (!extend.isIsHeadExtent()) continue;
                String diskName = extend.getDevice().getDiskName();
                int index = diskName.indexOf(".");
                String tempWwn = diskName.substring(index + 1);
                logger.info((Object)("tempwwn=" + tempWwn));
                if (!wwnList.contains(tempWwn)) continue;
                devPath = extend.getDevicePath();
                break;
            }
            if (VerifyUtil.isEmpty(devPath)) continue;
            break;
        }
        return devPath;
    }

    public List<HostUnresolvedVmfsVolume> queryUnresolvedVmfsVolume(String vcenterUuid, String hostMoid) {
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        VimPortType vimPort = conn.getVimPort();
        ArrayList<String> hostItems = new ArrayList<String>();
        hostItems.add("name");
        hostItems.add("configManager");
        Map<ManagedObjectReference, Map<String, Object>> hostDynamicProps = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "HostSystem", hostItems);
        HostConfigManager hcm = new HostConfigManager();
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> result : hostDynamicProps.entrySet()) {
            Map<String, Object> props = result.getValue();
            if (!hostMoid.equals(result.getKey().getValue())) continue;
            hcm = (HostConfigManager)props.get("configManager");
            break;
        }
        if (null == hcm) {
            logger.error((Object)("hcm is null,hostMoId=" + hostMoid));
            return new ArrayList<HostUnresolvedVmfsVolume>();
        }
        try {
            List vols = vimPort.queryUnresolvedVmfsVolume(hcm.getStorageSystem());
            return null == vols ? new ArrayList() : vols;
        }
        catch (RuntimeFaultFaultMsg e) {
            logger.error((Object)("query unresolved datastore on ESXi[" + hostMoid + "]failed."), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948897L, (Throwable)e);
        }
    }

    private VsphereHostSystem parseHostSystem(ObjectContent oc, String vCenterUuid) {
        VsphereHostSystem host = new VsphereHostSystem();
        try {
            host.setUuid(vCenterUuid + ":" + oc.getObj().getValue());
            host.setName(PropertyCollectorUtil.getPropertyByPath(oc, "name", String.class));
            String osType = PropertyCollectorUtil.getPropertyByPath(oc, "summary.config.product.osType", String.class);
            host.setOsType(VerifyUtil.isEmpty((String)osType) ? "UNKNOWN" : osType);
            host.setIpAddress(PropertyCollectorUtil.getPropertyByPath(oc, "summary.managementServerIp", String.class));
            ManagedEntityStatus overallStatus = PropertyCollectorUtil.getPropertyByPath(oc, "summary.overallStatus", ManagedEntityStatus.class);
            DrmVsphereEnumDefine.VSPHERE_MANAGEDENTITY_STATUS_E status = VsphereEnumParse.parseManagedEntityStatus(overallStatus);
            host.setHealthStatus(Integer.valueOf(status.getValue()));
            host.setHostName(PropertyCollectorUtil.getPropertyByPath(oc, "summary.config.product.fullName", String.class));
            host.setVersion(PropertyCollectorUtil.getPropertyByPath(oc, "summary.config.product.version", String.class));
            HostSystemPowerState powerStatus = PropertyCollectorUtil.getPropertyByPath(oc, "runtime.powerState", HostSystemPowerState.class);
            if (null == powerStatus || powerStatus.equals((Object)HostSystemPowerState.UNKNOWN)) {
                host.setStatus(Integer.valueOf(4));
            } else if (powerStatus.equals((Object)HostSystemPowerState.POWERED_OFF)) {
                host.setStatus(Integer.valueOf(-1));
            } else {
                host.setStatus(Integer.valueOf(0));
            }
            ManagedObjectReference crMor = PropertyCollectorUtil.getPropertyByPath(oc, "parent", ManagedObjectReference.class);
            host.setComputeResourceUuid(vCenterUuid + ":" + crMor.getValue());
            String ipAddress = this.getHostIpAddresses(oc);
            host.setIpAddress(ipAddress);
            List<ScsiLun> scsiLUNs = PropertyCollectorUtil.getPropertyCollectionByPath(oc, "config.storageDevice.scsiLun", ScsiLun.class);
            this.generatePhyStorageByHost(scsiLUNs, host, vCenterUuid);
            List<HostHostBusAdapter> hostBusAdapters = PropertyCollectorUtil.getPropertyCollectionByPath(oc, "config.storageDevice.hostBusAdapter", HostHostBusAdapter.class);
            this.generateHbaByHost(hostBusAdapters, host, vCenterUuid);
        }
        catch (Exception e) {
            logger.error((Object)("parse Host info failed:hostUUid=" + host.getUuid() + " hostName=" + host.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            host = null;
        }
        return host;
    }

    private String getHostIpAddresses(ObjectContent oc) {
        List<HostVirtualNic> virtualNicList = PropertyCollectorUtil.getPropertyCollectionByPath(oc, "config.network.vnic", HostVirtualNic.class);
        String ipAddress = "";
        if (VerifyUtil.isEmpty(virtualNicList)) {
            return ipAddress;
        }
        StringBuilder ipAddressBuilder = new StringBuilder();
        for (HostVirtualNic virtualNic : virtualNicList) {
            if (null == virtualNic.getSpec() || null == virtualNic.getSpec().getIp() || null == virtualNic.getSpec().getIp().getIpAddress() || virtualNic.getSpec().getIp().getIpAddress().isEmpty()) continue;
            ipAddressBuilder.append(";");
            ipAddressBuilder.append(virtualNic.getSpec().getIp().getIpAddress());
        }
        if (ipAddressBuilder.length() > 0) {
            ipAddress = ipAddressBuilder.substring(1);
        }
        return ipAddress;
    }

    private void generatePhyStorageByHost(List<ScsiLun> scsiLUNs, VsphereHostSystem host, String vCenterUuid) {
        if (null != scsiLUNs && !scsiLUNs.isEmpty() && null != host) {
            for (ScsiLun lun : scsiLUNs) {
                if (!(lun instanceof HostScsiDisk)) continue;
                VspherePhysicalStorageDevice storageDev = new VspherePhysicalStorageDevice();
                storageDev.setUuid(vCenterUuid + ":" + lun.getUuid());
                storageDev.setDeviceUuid(lun.getUuid());
                storageDev.setDeviceType(lun.getDeviceType());
                storageDev.setStorageWwn(HostSystemAction.processStorageWwn(lun.getCanonicalName(), null));
                storageDev.setParentMo((ManagedObject)host);
                host.addChildMo((ManagedObject)storageDev);
            }
        }
    }

    private void generateHbaByHost(List<HostHostBusAdapter> hostBusAdapters, VsphereHostSystem host, String vCenterUuid) {
        if (null != hostBusAdapters && !hostBusAdapters.isEmpty() && null != host) {
            for (HostHostBusAdapter hba : hostBusAdapters) {
                if (hba instanceof HostFibreChannelHba) {
                    HostFibreChannelHba fcHba = (HostFibreChannelHba)hba;
                    VspherePhysicalStorageDevice portStorageDev = new VspherePhysicalStorageDevice();
                    String portWwn = Long.toHexString(fcHba.getPortWorldWideName());
                    portStorageDev.setUuid(vCenterUuid + ":" + portWwn);
                    portStorageDev.setDeviceUuid(portWwn);
                    portStorageDev.setDeviceType("FibreChannelHba");
                    portStorageDev.setStorageWwn(portWwn);
                    portStorageDev.setName(fcHba.getDevice());
                    portStorageDev.setParentMo((ManagedObject)host);
                    host.addChildMo((ManagedObject)portStorageDev);
                    continue;
                }
                if (hba instanceof HostInternetScsiHba) {
                    HostInternetScsiHba iscsiHba = (HostInternetScsiHba)hba;
                    VspherePhysicalStorageDevice storageDev = new VspherePhysicalStorageDevice();
                    storageDev.setUuid(vCenterUuid + ":" + iscsiHba.getIScsiName());
                    storageDev.setDeviceUuid(iscsiHba.getIScsiName());
                    storageDev.setDeviceType("InternetScsiHba");
                    storageDev.setStorageWwn(iscsiHba.getIScsiName());
                    storageDev.setName(iscsiHba.getDevice());
                    storageDev.setParentMo((ManagedObject)host);
                    host.addChildMo((ManagedObject)storageDev);
                    continue;
                }
                if (!"nvmerdma".equals(hba.getDriver())) continue;
                VspherePhysicalStorageDevice nvmeDev = new VspherePhysicalStorageDevice();
                nvmeDev.setUuid(vCenterUuid + ":" + hba.getKey());
                nvmeDev.setDeviceUuid(hba.getKey());
                nvmeDev.setDeviceType("NVMe_over_RoCE");
                nvmeDev.setStorageWwn(this.getHostNvme(host.getUuid()));
                nvmeDev.setName(hba.getDevice());
                nvmeDev.setParentMo((ManagedObject)host);
                host.addChildMo((ManagedObject)nvmeDev);
            }
        }
    }

    private String getHostNvme(String hostUuid) {
        VsphereHostSystem host = (VsphereHostSystem)CommonDAOLocator.getMoDao().getMo(VsphereHostSystem.class, "uuid", (Object)hostUuid);
        if (VerifyUtil.isEmpty((Object)host)) {
            return "";
        }
        return host.getNvme();
    }

    public String queryScsiLunByHost(String vcenterUuid, String hostMoId, String lunWwn) {
        logger.debug((Object)"Get scsi lun by host: vcenterUuid[%s], hostMoId[%s], lunWwn[%s].", new Object[]{vcenterUuid, hostMoId, lunWwn});
        ArrayList<String> items = new ArrayList<String>();
        items.add("name");
        items.add("config.storageDevice.scsiLun");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        Map<ManagedObjectReference, Map<String, Object>> dynamicPropsMap = GetMoPropsValueUtils.getInstance().getDynamicProps(conn, "HostSystem", items);
        ArrayOfScsiLun scsiLUNarr = new ArrayOfScsiLun();
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> result : dynamicPropsMap.entrySet()) {
            Map<String, Object> props = result.getValue();
            if (!hostMoId.equals(result.getKey().getValue())) continue;
            scsiLUNarr = (ArrayOfScsiLun)props.get("config.storageDevice.scsiLun");
            break;
        }
        if (null == scsiLUNarr) {
            logger.error((Object)("get lun array failed,hostMoId=" + hostMoId));
            return null;
        }
        String lunPath = null;
        List scsiLuns = scsiLUNarr.getScsiLun();
        if (!VerifyUtil.isEmpty((Collection)scsiLuns)) {
            for (ScsiLun lun : scsiLuns) {
                String canName = HostSystemAction.processStorageWwn(lun.getCanonicalName(), null);
                if (!canName.contains(lunWwn)) continue;
                lunPath = lun.getDeviceName();
                break;
            }
        }
        return lunPath;
    }

    public boolean isPowerOnHostAtLeast(String vcenterUuid, String compResUuid) {
        logger.debug((Object)"isPowerOnHostAtLeast start");
        VsphereComputeResource comRes = (VsphereComputeResource)CommonDAOLocator.getMoDao().getMo(VsphereComputeResource.class, "uuid", (Object)compResUuid);
        List hostList = CommonDAOLocator.getMoDao().getMoList(VsphereHostSystem.class, "computeResourceUuid", (Object)comRes.getUuid());
        ArrayList<ManagedObjectReference> morList = new ArrayList<ManagedObjectReference>();
        for (VsphereHostSystem host : hostList) {
            String hostId = host.getUuid().split(":")[1];
            ManagedObjectReference mor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(hostId, "HostSystem");
            morList.add(mor);
        }
        if (VerifyUtil.isEmpty((Collection)hostList)) {
            logger.warn((Object)"hostList is empty!");
        }
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        Map<ManagedObjectReference, Map<String, Object>> result = GetMoPropsValueUtils.getInstance().entityProps(conn, morList, new String[]{"runtime.powerState"});
        if (VerifyUtil.isEmpty(result)) {
            logger.warn((Object)"result is empty!");
        }
        boolean flag = false;
        for (Map.Entry<ManagedObjectReference, Map<String, Object>> entry : result.entrySet()) {
            Map<String, Object> propMap = entry.getValue();
            HostSystemPowerState state = (HostSystemPowerState)propMap.get("runtime.powerState");
            if (HostSystemPowerState.POWERED_ON != state) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public List<HostUnresolvedVmfsResolutionResult> resignatureDataStore(String vcenterUuid, String hostMoId, String devicePath) {
        String message = String.format("mount unresolved datastore to host system failed.vcenterUuid:[%s], hostId:[%s], devicePaht:[%s]", vcenterUuid, hostMoId, devicePath);
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        VimPortType vimPort = conn.getVimPort();
        ManagedObjectReference hostMor = new ManagedObjectReference();
        hostMor.setType("HostSystem");
        hostMor.setValue(hostMoId);
        GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
        HostConfigManager hcm = (HostConfigManager)util.entityProps(conn, hostMor, new String[]{"configManager"}).get("configManager");
        if (null == hcm) {
            logger.error((Object)("hcm is null,hostMoId=" + hostMoId));
            throw new LegoCheckedException(1073948898L);
        }
        ArrayList<HostUnresolvedVmfsResolutionSpec> vrSpecs = new ArrayList<HostUnresolvedVmfsResolutionSpec>();
        HostUnresolvedVmfsResolutionSpec vrSpec = new HostUnresolvedVmfsResolutionSpec();
        vrSpec.getExtentDevicePath().add(devicePath);
        vrSpec.setUuidResolution("resignature");
        vrSpecs.add(vrSpec);
        List results = null;
        try {
            results = vimPort.resolveMultipleUnresolvedVmfsVolumes(hcm.getStorageSystem(), vrSpecs);
        }
        catch (HostConfigFaultFaultMsg e) {
            logger.error((Object)message, (Throwable)e);
            throw new LegoCheckedException(1073948898L, (Throwable)e);
        }
        catch (RuntimeFaultFaultMsg e) {
            logger.error((Object)message, (Throwable)e);
            throw new LegoCheckedException(1073948898L, (Throwable)e);
        }
        return results;
    }
}

