/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action;

import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.discovery.util.PropertyCollectorUtil;
import com.huawei.ism.drm.vsphere.discovery.util.VsphereEnumParse;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereResourcePool;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedEntityStatus;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.ObjectContent;
import com.huawei.vmware.vim25.ObjectSpec;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertySpec;
import com.huawei.vmware.vim25.TraversalSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ResourcePoolAction {
    public List<VsphereResourcePool> queryAllResourcePool(VmwareConnection conn) {
        if (null == conn) {
            throw new LegoCheckedException(1073947393L);
        }
        return this.queryAllResourcePoolByContainer(conn.getServiceContent().getRootFolder(), conn);
    }

    public List<VsphereResourcePool> queryAllResourcePoolByContainer(ManagedObjectReference containerMor, VmwareConnection conn) {
        if (Objects.isNull(conn)) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> rpList = new ArrayList<String>();
        rpList.add("ResourcePool");
        ManagedObjectReference containerView = PropertyCollectorUtil.createContainerView(conn, containerMor, rpList, true);
        ObjectSpec objSpec = new ObjectSpec();
        objSpec.setObj(containerView);
        objSpec.setSkip(Boolean.valueOf(true));
        TraversalSpec traSpec = PropertyCollectorUtil.createTraversalSpec("traverseEntities", "ContainerView", "view");
        objSpec.getSelectSet().add(traSpec);
        ArrayList<String> pathSet = new ArrayList<String>();
        pathSet.add("name");
        pathSet.add("summary.runtime.overallStatus");
        PropertySpec rpSpec = PropertyCollectorUtil.createPropertySpec("ResourcePool", pathSet);
        ArrayList<ObjectSpec> objectSet = new ArrayList<ObjectSpec>();
        objectSet.add(objSpec);
        ArrayList<PropertySpec> propSet = new ArrayList<PropertySpec>();
        propSet.add(rpSpec);
        List<PropertyFilterSpec> filterSpecList = PropertyCollectorUtil.createPropertyFilterSpecList(objectSet, propSet);
        List<ObjectContent> queryResult = PropertyCollectorUtil.retrievePropertiesEx(conn, filterSpecList);
        VMAction.destroyContainerView(containerView, conn.getVimPort());
        ArrayList<VsphereResourcePool> result = new ArrayList<VsphereResourcePool>();
        if (!VerifyUtil.isEmpty(queryResult)) {
            for (ObjectContent oc : queryResult) {
                VsphereResourcePool rp = new VsphereResourcePool();
                this.parseResourcePool(rp, oc, conn.getVcenterUuid());
                result.add(rp);
            }
        }
        return result;
    }

    private void parseResourcePool(VsphereResourcePool rp, ObjectContent oc, String vCenterUuid) {
        rp.setUuid(vCenterUuid + ":" + oc.getObj().getValue());
        rp.setName(PropertyCollectorUtil.getPropertyByPath(oc, "name", String.class));
        ManagedEntityStatus overallStatus = PropertyCollectorUtil.getPropertyByPath(oc, "summary.runtime.overallStatus", ManagedEntityStatus.class);
        DrmVsphereEnumDefine.VSPHERE_MANAGEDENTITY_STATUS_E status = VsphereEnumParse.parseManagedEntityStatus(overallStatus);
        rp.setHealthStatus(Integer.valueOf(status.getValue()));
    }
}

