/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action;

import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.discovery.util.PropertyCollectorUtil;
import com.huawei.ism.drm.vsphere.sdk.model.VsNetWork;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ArrayOfTag;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.ObjectContent;
import com.huawei.vmware.vim25.ObjectSpec;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertySpec;
import com.huawei.vmware.vim25.Tag;
import com.huawei.vmware.vim25.TraversalSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VsNetworkAction {
    public List<VsNetWork> queryAllNetworks(VmwareConnection conn) {
        List<VsNetWork> result = this.queryVshereNetworks(conn.getServiceContent().getRootFolder(), conn);
        return result;
    }

    public List<VsNetWork> queryVshereNetworks(ManagedObjectReference containerMor, VmwareConnection conn) {
        ArrayList<String> vmList = new ArrayList<String>();
        vmList.add("Network");
        ManagedObjectReference containerView = PropertyCollectorUtil.createContainerView(conn, containerMor, vmList, true);
        ObjectSpec objSpec = new ObjectSpec();
        objSpec.setObj(containerView);
        objSpec.setSkip(Boolean.valueOf(true));
        TraversalSpec traSpec = PropertyCollectorUtil.createTraversalSpec("traverseEntities", "ContainerView", "view");
        objSpec.getSelectSet().add(traSpec);
        ArrayList<String> pathSet = new ArrayList<String>();
        pathSet.add("name");
        pathSet.add("host");
        pathSet.add("vm");
        PropertySpec hostSpec = PropertyCollectorUtil.createPropertySpec("Network", pathSet);
        ArrayList<ObjectSpec> objectSet = new ArrayList<ObjectSpec>();
        objectSet.add(objSpec);
        ArrayList<PropertySpec> propSet = new ArrayList<PropertySpec>();
        propSet.add(hostSpec);
        List<PropertyFilterSpec> filterSpecList = PropertyCollectorUtil.createPropertyFilterSpecList(objectSet, propSet);
        List<ObjectContent> queryResult = PropertyCollectorUtil.retrievePropertiesEx(conn, filterSpecList);
        VMAction.destroyContainerView(containerView, conn.getVimPort());
        ArrayList<VsNetWork> result = new ArrayList<VsNetWork>();
        if (!VerifyUtil.isEmpty(queryResult)) {
            for (ObjectContent oc : queryResult) {
                VsNetWork network = new VsNetWork();
                this.parseVsNetWork(network, oc, conn);
                if (VerifyUtil.isEmpty((String)network.getUuid())) continue;
                result.add(network);
            }
        }
        return result;
    }

    private void parseVsNetWork(VsNetWork network, ObjectContent oc, VmwareConnection conn) {
        String vCenterUuid = conn.getVcenterUuid();
        network.setUuid(vCenterUuid + ":" + oc.getObj().getValue());
        network.setName(PropertyCollectorUtil.getPropertyByPath(oc, "name", String.class));
        List<ManagedObjectReference> hostList = PropertyCollectorUtil.getPropertyCollectionByPath(oc, "host", ManagedObjectReference.class);
        List<ManagedObjectReference> vmList = PropertyCollectorUtil.getPropertyCollectionByPath(oc, "vm", ManagedObjectReference.class);
        network.setHostUuids(this.combineUuids(hostList, vCenterUuid));
        network.setVmUuids(this.combineUuids(vmList, vCenterUuid));
        network.setNetworkType("standardPortGroup");
        ManagedObjectReference networkMor = oc.getObj();
        String netType = networkMor.getType();
        if ("DistributedVirtualPortgroup".equals(netType)) {
            network.setNetworkType("distributePortGroup");
            String[] props = new String[]{"key", "config.distributedVirtualSwitch", "tag"};
            Map<String, Object> ret = GetMoPropsValueUtils.getInstance().entityProps(conn, networkMor, props);
            String portGroupKey = (String)ret.get("key");
            network.setPortGroupKey(portGroupKey);
            ManagedObjectReference vSwitchMor = (ManagedObjectReference)ret.get("config.distributedVirtualSwitch");
            props = new String[]{"uuid"};
            String vswitchUuid = (String)GetMoPropsValueUtils.getInstance().entityProps(conn, vSwitchMor, props).get("uuid");
            network.setVswitchUuid(vswitchUuid);
            ArrayOfTag tagArray = (ArrayOfTag)ret.get("tag");
            if (null != tagArray && !tagArray.getTag().isEmpty() && ((Tag)tagArray.getTag().get(0)).getKey().contains("UPLINK")) {
                network.setUuid("");
            }
        }
    }

    private String combineUuids(List<ManagedObjectReference> objList, String vCenterIP) {
        StringBuilder sb = new StringBuilder();
        for (ManagedObjectReference managedObjectReference : objList) {
            sb.append(vCenterIP + ":" + managedObjectReference.getValue() + ";");
        }
        if (sb.length() != 0) {
            sb.delete(sb.length() - ";".length(), sb.length());
        }
        return sb.toString();
    }
}

