/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action;

import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.discovery.util.PropertyCollectorUtil;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.AboutInfo;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.ObjectContent;
import com.huawei.vmware.vim25.ObjectSpec;
import com.huawei.vmware.vim25.OptionValue;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertySpec;
import com.huawei.vmware.vim25.RetrieveOptions;
import com.huawei.vmware.vim25.RetrieveResult;
import java.util.ArrayList;
import java.util.List;

public class VsphereCenterAction {
    private static final Log logger = LogFactory.getInstance(VsphereCenterAction.class);

    public static Boolean isSupported(String apiType) {
        return "VirtualCenter".equals(apiType);
    }

    public VsphereCenter queryVsphereCenter(String vcenterUuid) {
        if (null == vcenterUuid) {
            logger.error((Object)"connection is null.", 90160758786989L);
            throw new LegoCheckedException(-1L);
        }
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        return this.queryVsphereCenter(conn);
    }

    public VsphereCenter queryVsphereCenter(VmwareConnection conn) {
        AboutInfo detail = conn.getServiceContent().getAbout();
        if (null == detail) {
            logger.error((Object)"AboutInfo is null.", 90160758786989L);
            throw new LegoCheckedException(-1L);
        }
        VsphereCenter vc = new VsphereCenter();
        vc.setApiType(detail.getApiType());
        vc.setApiVersion(detail.getApiVersion());
        vc.setFullName(detail.getFullName());
        vc.setOsType(detail.getOsType());
        vc.setVersion(detail.getVersion());
        if (VerifyUtil.isEmpty((String)detail.getInstanceUuid())) {
            logger.error((Object)"InstanceUuid is null.", 90160758786989L);
            throw new LegoCheckedException(1073947690L);
        }
        vc.setUuid(detail.getInstanceUuid());
        String vcName = this.getVCenterName(conn);
        if (null == vcName || vcName.isEmpty()) {
            vcName = detail.getFullName();
        }
        vc.setName(vcName);
        return vc;
    }

    private String getVCenterName(VmwareConnection conn) {
        RetrieveResult props;
        ManagedObjectReference setting = conn.getServiceContent().getSetting();
        ManagedObjectReference propColl = conn.getServiceContent().getPropertyCollector();
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(setting);
        oSpec.setSkip(Boolean.valueOf(false));
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType("OptionManager");
        pSpec.setAll(Boolean.valueOf(false));
        pSpec.getPathSet().add("setting");
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        fSpec.getObjectSet().add(oSpec);
        fSpec.getPropSet().add(pSpec);
        ArrayList<PropertyFilterSpec> fSpecList = new ArrayList<PropertyFilterSpec>();
        fSpecList.add(fSpec);
        RetrieveOptions ro = new RetrieveOptions();
        try {
            props = conn.getVimPort().retrievePropertiesEx(propColl, fSpecList, ro);
        }
        catch (Exception e) {
            logger.error((Object)"retrievePropertiesEx error.", 90160758786989L);
            return null;
        }
        if (null == props) {
            return null;
        }
        for (ObjectContent oc : props.getObjects()) {
            List<OptionValue> options = PropertyCollectorUtil.getPropertyCollectionByPath(oc, "setting", OptionValue.class);
            if (VerifyUtil.isEmpty(options)) {
                return null;
            }
            for (OptionValue option : options) {
                if (!"VirtualCenter.InstanceName".equals(option.getKey())) continue;
                return (String)option.getValue();
            }
        }
        return null;
    }
}

