/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.connect;

import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.vmware.vim25.InvalidLocaleFaultMsg;
import com.huawei.vmware.vim25.InvalidLoginFaultMsg;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.RuntimeFaultFaultMsg;
import com.huawei.vmware.vim25.ServiceContent;
import com.huawei.vmware.vim25.UserSession;
import com.huawei.vmware.vim25.VimPortType;
import com.huawei.vmware.vim25.VimService;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.xml.ws.BindingProvider;

public class VmwareConnection {
    private static final Log LOGGER = LogFactory.getInstance(VmwareConnection.class);
    private static final Integer DEFAULT_PORT = 443;
    private static final Integer DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final long DEFAULT_REQUEST_TIMEOUT = LegoConfig.getInstance().getNumber("vmware.connection.request.timeout", 1800L) * 1000L;
    private final String ip;
    private final Integer port;
    private final String userName;
    private final String pwd;
    private VimService vimService;
    private VimPortType vimPort;
    private ServiceContent serviceContent;
    private final ManagedObjectReference svcInstRef;
    private final HostnameVerifier hv;
    private UserSession userSession;
    private String vcenterUuid;

    public VmwareConnection(String ip, Integer port, String userName, String pwd, String vCenterUuid) {
        this.ip = ip;
        this.userName = userName;
        this.pwd = this.encryptPwd(pwd);
        this.port = null == port ? DEFAULT_PORT : port;
        this.vcenterUuid = vCenterUuid;
        this.hv = (urlHostName, session) -> true;
        this.svcInstRef = new ManagedObjectReference();
        this.svcInstRef.setType("ServiceInstance");
        this.svcInstRef.setValue("ServiceInstance");
    }

    public void connnect() {
        SSLContext sc;
        try {
            sc = SSLContext.getInstance("TLS");
            SSLSessionContext sslsc = sc.getServerSessionContext();
            sslsc.setSessionTimeout(0);
            sc.init(null, new TrustManager[]{new BcmX509TrustManager(this.ip, String.valueOf(this.port))}, SecureRandomFactory.getInstanceStrongWithDRBG());
        }
        catch (Exception e) {
            sc = null;
            ExceptionUtil.rethrowException((Throwable)e, (String)"Init ssl error.", (long)-1L, (String[])new String[0], (Log)LOGGER);
        }
        if (sc == null) {
            throw new LegoCheckedException(-1L, "Init ssl error.");
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(this.hv);
        try {
            String ipTemp = this.ip;
            if (Ipv6AddressUtil.isIPv6Address((String)this.ip)) {
                ipTemp = Ipv6AddressUtil.convertIpv6((String)this.ip);
            }
            URL url = new URL("https://" + ipTemp + ":" + this.port + "/sdk/vimService");
            Thread.currentThread().setContextClassLoader(VmwareConnection.class.getClassLoader());
            this.vimService = new VimService();
            this.vimPort = this.vimService.getVimPort();
            Map ctxt = ((BindingProvider)this.vimPort).getRequestContext();
            ctxt.put("javax.xml.ws.service.endpoint.address", url.toString());
            ctxt.put("javax.xml.ws.session.maintain", true);
            ctxt.put("com.sun.xml.internal.ws.connect.timeout", DEFAULT_CONNECT_TIMEOUT);
            ctxt.put("com.sun.xml.ws.connect.timeout", DEFAULT_CONNECT_TIMEOUT);
            ctxt.put("com.sun.xml.internal.ws.request.timeout", (int)DEFAULT_REQUEST_TIMEOUT);
            ctxt.put("com.sun.xml.ws.request.timeout", (int)DEFAULT_REQUEST_TIMEOUT);
            this.serviceContent = this.vimPort.retrieveServiceContent(this.svcInstRef);
            this.userSession = this.vimPort.login(this.serviceContent.getSessionManager(), this.userName, this.decryptPwd(), null);
        }
        catch (InvalidLoginFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Log vcenter (" + this.ip + ") error due to a bad user name or password."), (long)1073947691L, (String[])new String[0], (Log)LOGGER);
        }
        catch (InvalidLocaleFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Log vcenter (" + this.ip + ") error due to a bad locale."), (long)1073947691L, (String[])new String[0], (Log)LOGGER);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Log vcenter (" + this.ip + ") error."), (long)1073947398L, (String[])new String[]{this.ip}, (Log)LOGGER);
        }
    }

    public boolean isConnected() {
        if (this.vimPort == null || this.userSession == null || this.serviceContent == null) {
            LOGGER.debug((Object)"UserSession is null.");
            return false;
        }
        boolean isConnect = false;
        try {
            isConnect = this.vimPort.sessionIsActive(this.serviceContent.getSessionManager(), this.userSession.getKey(), this.userSession.getUserName());
        }
        catch (RuntimeFaultFaultMsg e) {
            LOGGER.error((Object)"Get session is active error.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Get session is active error." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return isConnect;
    }

    public void disconnect() {
        if (this.vimPort == null) {
            return;
        }
        try {
            this.vimPort.logout(this.serviceContent.getSessionManager());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Logout vcenter error, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            this.userSession = null;
            this.serviceContent = null;
            this.vimPort = null;
            this.vimService = null;
        }
    }

    private String encryptPwd(String passWord) {
        return WccEncryptor.encrypt((String)passWord);
    }

    public String decryptPwd() {
        return WccEncryptor.decrypt((String)this.pwd);
    }

    public VimService getVimService() {
        return this.vimService;
    }

    public VimPortType getVimPort() {
        return this.vimPort;
    }

    public ServiceContent getServiceContent() {
        return this.serviceContent;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUserName() {
        return this.userName;
    }

    public Integer getPort() {
        return this.port;
    }

    public ManagedObjectReference getSvcInstRef() {
        return this.svcInstRef;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }
}

