/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.connect;

import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.lego.core.sdk.exception.LegoUncaughtExceptionHandler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;
import java.util.TimerTask;

public class VmwareConnectionKeepAlive
extends TimerTask {
    private static final Log logger = LogFactory.getInstance(VmwareConnectionKeepAlive.class);
    private Map<String, VmwareConnection> connectionsManager = null;

    public VmwareConnectionKeepAlive(Map<String, VmwareConnection> connectionsManager) {
        this.connectionsManager = connectionsManager;
    }

    @Override
    public void run() {
        Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LegoUncaughtExceptionHandler.getInstance());
        Thread.currentThread().setName("VmwareConnectionKeepAlive Thread");
        this.updateSession();
    }

    private void updateSession() {
        for (Map.Entry<String, VmwareConnection> tmp : this.connectionsManager.entrySet()) {
            VmwareConnection connection = tmp.getValue();
            String uuid = connection.getVcenterUuid();
            if (!connection.isConnected()) continue;
            try {
                connection.getVimPort().currentTime(connection.getSvcInstRef());
            }
            catch (Exception e) {
                logger.error((Object)("update connection error.uuid :" + uuid + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }
}

