/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.connect;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionKeepAlive;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public final class VmwareConnectionManager {
    private static final Log logger = LogFactory.getInstance(VmwareConnectionManager.class);
    private static final Long DEFAULT_INTERVAL = 300000L;
    private static final Map<String, VmwareConnection> CONNECTIONMANAGER = new ConcurrentHashMap<String, VmwareConnection>();
    private static final VmwareConnectionManager INSTANCE = new VmwareConnectionManager();
    private final Map<String, Object> uuidConnectionLock = new ConcurrentHashMap<String, Object>();

    private VmwareConnectionManager() {
        Timer timer = new Timer(true);
        VmwareConnectionKeepAlive task = new VmwareConnectionKeepAlive(CONNECTIONMANAGER);
        timer.schedule((TimerTask)task, 0L, (long)DEFAULT_INTERVAL);
    }

    public static VmwareConnectionManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmwareConnection getVmwareConnection(String uuid) {
        this.genUuidConnetcionLock(uuid);
        Object object = this.uuidConnectionLock.get(uuid);
        synchronized (object) {
            VmwareConnection conn = this.getVmwareConnectionLock(uuid);
            if (null == conn) {
                logger.error((Object)"conn is null.");
                throw new LegoCheckedException(0x300001L);
            }
            return conn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVmwareConnection(String uuid) {
        this.genUuidConnetcionLock(uuid);
        Object object = this.uuidConnectionLock.get(uuid);
        synchronized (object) {
            this.removeVmwareConnectionLock(uuid);
        }
        this.removeUuidConnetcionLock(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(VmwareConnection connection) {
        if (null == connection || null == connection.getVcenterUuid() || !connection.isConnected()) {
            return;
        }
        this.genUuidConnetcionLock(connection.getVcenterUuid());
        Object object = this.uuidConnectionLock.get(connection.getVcenterUuid());
        synchronized (object) {
            VmwareConnection existConn = CONNECTIONMANAGER.get(connection.getVcenterUuid());
            if (null != existConn && existConn.isConnected()) {
                return;
            }
            CONNECTIONMANAGER.remove(connection.getVcenterUuid());
            CONNECTIONMANAGER.put(connection.getVcenterUuid(), connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVmwareConnection(String uuid) {
        this.genUuidConnetcionLock(uuid);
        Object object = this.uuidConnectionLock.get(uuid);
        synchronized (object) {
            this.updateVmwareConnectionLock(uuid);
        }
    }

    private VmwareConnection getVmwareConnectionLock(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            logger.error((Object)"param \" uuid \" error.", 90160758787071L);
            throw new LegoCheckedException(1073947393L, new String[0]);
        }
        VmwareConnection connection = CONNECTIONMANAGER.get(uuid);
        if (connection == null) {
            connection = this.createNewConnection(uuid);
            CONNECTIONMANAGER.put(uuid, connection);
        } else if (!connection.isConnected()) {
            CONNECTIONMANAGER.remove(uuid);
            connection = this.createNewConnection(uuid);
            CONNECTIONMANAGER.put(uuid, connection);
        }
        return CONNECTIONMANAGER.get(uuid);
    }

    private void removeVmwareConnectionLock(String uuid) {
        logger.info((Object)("removeVmwareConnection vcenter start. uuid" + uuid + "  all connection of this vcenter will disconnection"), 90160758786988L);
        VmwareConnection connection = CONNECTIONMANAGER.get(uuid);
        if (connection != null) {
            CONNECTIONMANAGER.remove(uuid);
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                logger.error((Object)("can not disconnect connection." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    private void updateVmwareConnectionLock(String uuid) {
        logger.info((Object)("updateConnection vcenter start. uuid" + uuid + " all connection of this vcenter will disconnection"), 90160758786988L);
        VmwareConnection connection = CONNECTIONMANAGER.get(uuid);
        if (connection != null) {
            try {
                this.removeVmwareConnectionLock(uuid);
                this.getVmwareConnectionLock(uuid);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"connect vcenter error with LegoCheckedException.", (Throwable)e, 90160758786989L);
            }
            catch (Exception e) {
                logger.error((Object)("connect vcenter error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    private VmwareConnection createNewConnection(String uuid) {
        long moid;
        VsphereCenter vc = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)uuid);
        if (vc == null) {
            logger.error((Object)("vCenter(" + uuid + ") dosen't exist."), 90160758787071L);
            throw new LegoCheckedException(-1L, new String[0]);
        }
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend extend = neMgr.findByMoId(Long.valueOf(moid = vc.getMoId().longValue()));
        if (extend == null) {
            logger.error((Object)("vCenter(" + vc.getUuid() + ")'NeMgrProtocolExtend dosen't exist."), 90160758787071L);
            throw new LegoCheckedException(-1L, new String[0]);
        }
        String ip = extend.getNetworkIpAddress();
        Integer port = Integer.valueOf((String)extend.getExtendParams().get("port"));
        String userName = extend.getNetworkUserName();
        String passWord = extend.getNetworkPassword();
        VmwareConnection connection = new VmwareConnection(ip, port, userName, passWord, uuid);
        connection.connnect();
        return connection;
    }

    private synchronized void genUuidConnetcionLock(String uuid) {
        if (!this.uuidConnectionLock.containsKey(uuid)) {
            this.uuidConnectionLock.put(uuid, new Object());
        }
    }

    private synchronized void removeUuidConnetcionLock(String uuid) {
        if (this.uuidConnectionLock.containsKey(uuid)) {
            this.uuidConnectionLock.remove(uuid);
        }
    }
}

