/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.discovery.util;

import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.DynamicProperty;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.ObjectContent;
import com.huawei.vmware.vim25.ObjectSpec;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertySpec;
import com.huawei.vmware.vim25.RetrieveOptions;
import com.huawei.vmware.vim25.RetrieveResult;
import com.huawei.vmware.vim25.RuntimeFaultFaultMsg;
import com.huawei.vmware.vim25.TraversalSpec;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class PropertyCollectorUtil {
    private static final Log logger = LogFactory.getInstance(PropertyCollectorUtil.class);

    private PropertyCollectorUtil() {
    }

    public static ObjectSpec creatObjectSpec(ManagedObjectReference mor, boolean skip, List<TraversalSpec> selSet) {
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(mor);
        oSpec.setSkip(Boolean.valueOf(skip));
        if (null != selSet) {
            oSpec.getSelectSet().addAll(selSet);
        }
        return oSpec;
    }

    public static PropertySpec createPropertySpec(String type, boolean allProp, List<String> pathSet) {
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType(type);
        pSpec.setAll(Boolean.valueOf(allProp));
        if (null != pathSet) {
            pSpec.getPathSet().addAll(pathSet);
        }
        return pSpec;
    }

    public static PropertySpec createPropertySpec(String type, List<String> pathSet) {
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType(type);
        pSpec.setAll(Boolean.FALSE);
        if (null != pathSet) {
            pSpec.getPathSet().addAll(pathSet);
        }
        return pSpec;
    }

    public static TraversalSpec createTraversalSpec(String name, String type, String path) {
        TraversalSpec ts = new TraversalSpec();
        ts.setName(name);
        ts.setType(type);
        ts.setPath(path);
        ts.setSkip(Boolean.FALSE);
        return ts;
    }

    public static ManagedObjectReference createContainerView(VmwareConnection conn, ManagedObjectReference containerMor, List<String> types, boolean isRecursive) {
        if (Objects.isNull(conn)) {
            throw new LegoCheckedException(1073947393L);
        }
        try {
            return conn.getVimPort().createContainerView(conn.getServiceContent().getViewManager(), containerMor, types, isRecursive);
        }
        catch (RuntimeFaultFaultMsg faultMsg) {
            logger.error((Object)"Create ContainerView error. %s", new Object[]{faultMsg, faultMsg.getLocalizedMessage()});
            throw new LegoCheckedException(-1L, (Throwable)faultMsg);
        }
    }

    public static ManagedObjectReference createContainerView(VmwareConnection conn, List<String> types) {
        return PropertyCollectorUtil.createContainerView(conn, conn.getServiceContent().getRootFolder(), types, Boolean.TRUE);
    }

    public static PropertyFilterSpec createPropertyFilterSpec(List<ObjectSpec> objectSet, List<PropertySpec> propSet) {
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        fSpec.getObjectSet().addAll(objectSet);
        fSpec.getPropSet().addAll(propSet);
        return fSpec;
    }

    public static List<PropertyFilterSpec> createPropertyFilterSpecList(List<ObjectSpec> objectSet, List<PropertySpec> propSet) {
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        fSpec.getObjectSet().addAll(objectSet);
        fSpec.getPropSet().addAll(propSet);
        ArrayList<PropertyFilterSpec> result = new ArrayList<PropertyFilterSpec>();
        result.add(fSpec);
        return result;
    }

    public static List<ObjectContent> retrievePropertiesEx(VmwareConnection conn, List<PropertyFilterSpec> specSet) {
        ArrayList<ObjectContent> result = new ArrayList<ObjectContent>();
        ManagedObjectReference propColl = conn.getServiceContent().getPropertyCollector();
        try {
            RetrieveResult retrieveResult = conn.getVimPort().retrievePropertiesEx(propColl, specSet, new RetrieveOptions());
            if (null != retrieveResult) {
                result.addAll(retrieveResult.getObjects());
                while (!VerifyUtil.isEmpty((String)retrieveResult.getToken())) {
                    retrieveResult = conn.getVimPort().continueRetrievePropertiesEx(propColl, retrieveResult.getToken());
                    result.addAll(retrieveResult.getObjects());
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"retrievePropertiesEx error.", (long)-1L, null, (Log)logger);
        }
        return result;
    }

    public static Object getPropertyByPath(ObjectContent objContent, String path) {
        Object propertyValue = null;
        if (null != objContent && null != path && null != objContent.getPropSet()) {
            for (DynamicProperty dp : objContent.getPropSet()) {
                if (!path.equals(dp.getName())) continue;
                propertyValue = dp.getVal();
                break;
            }
        }
        return propertyValue;
    }

    public static <T> T getPropertyByPath(ObjectContent objContent, String path, Class<T> clazz) {
        Object propertyValue = null;
        if (null != objContent && null != path && null != objContent.getPropSet()) {
            for (DynamicProperty dp : objContent.getPropSet()) {
                if (!path.equals(dp.getName())) continue;
                propertyValue = PropertyCollectorUtil.convertProperty(dp.getVal());
                break;
            }
        }
        try {
            if (clazz == String.class) {
                propertyValue = PropertyCollectorUtil.disEncodeStringResult((String)propertyValue);
            }
            return clazz.cast(propertyValue);
        }
        catch (ClassCastException e) {
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
    }

    public static <T> List<T> getPropertyCollectionByPath(ObjectContent objContent, String path, Class<T> clazz) {
        List propertyValue = null;
        if (null != objContent && null != path && null != objContent.getPropSet()) {
            for (DynamicProperty dp : objContent.getPropSet()) {
                if (!path.equals(dp.getName())) continue;
                propertyValue = PropertyCollectorUtil.convertCollectionProperty(dp.getVal());
                break;
            }
        }
        ArrayList<T> result = new ArrayList<T>();
        if (null != propertyValue) {
            for (Object obj : propertyValue) {
                try {
                    result.add(clazz.cast(obj));
                }
                catch (ClassCastException e) {
                    throw new LegoCheckedException(1073947393L, (Throwable)e);
                }
            }
        }
        return result;
    }

    public static Object convertProperty(Object dynaPropVal) {
        Class<?> propClass = dynaPropVal.getClass();
        String propName = propClass.getName();
        if (propName.indexOf("ArrayOf") != -1) {
            logger.error((Object)("dynaPropVal(" + propName + ") is ArrayOf"), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return dynaPropVal;
    }

    public static List convertCollectionProperty(Object dynaPropVal) {
        Object propertyValue = null;
        Class<?> propClass = dynaPropVal.getClass();
        String propName = propClass.getName();
        if (propName.indexOf("ArrayOf") != -1) {
            String methodName = propName.substring(propName.indexOf("ArrayOf") + "ArrayOf".length());
            try {
                Method getMethod;
                try {
                    getMethod = propClass.getMethod("get" + methodName, null);
                }
                catch (NoSuchMethodException nsme) {
                    logger.error((Object)("method not found by get" + methodName), (Throwable)nsme, 90160758786989L);
                    getMethod = propClass.getMethod("get_" + methodName.toLowerCase(Locale.US), null);
                }
                propertyValue = getMethod.invoke(dynaPropVal, (Object[])null);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"convertProperty error.", (long)-1L, null, (Log)logger);
            }
        } else {
            logger.error((Object)("dynaPropVal(" + propName + ") is not ArrayOf"), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return (List)propertyValue;
    }

    private static Object disEncodeStringResult(String param) {
        if (VerifyUtil.isEmpty((String)param)) {
            return param;
        }
        String decodedParam = param.replaceAll("%2f", "/");
        decodedParam = decodedParam.replaceAll("%5c", "\\\\");
        decodedParam = decodedParam.replaceAll("%25", "%");
        return decodedParam;
    }
}

