/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.vsphere.recovery.process.VsCfgResForVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsCfgResForVmsProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VsCfgVmsProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6738681950856099734L;
    private static final Log logger = LogFactory.getInstance(VsCfgResForVmsProcessor.class);
    private String vcenterUuid;

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.createSubProcessors();
        } else {
            this.updateSubProcessors();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ArrayList subProcessors = new ArrayList();
        subProcessors.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessors, (boolean)false);
        recoveryTemplate.process(context);
        this.calcProcessResultBySubProc();
        return true;
    }

    private void createSubProcessors() {
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsCfgResForVmSubProcessor.class);
        ProtectGroup protectGroup = RecoveryToolsUtil.getInstance().getHistoryProtectGroupFromContext(this.getContextRef());
        HashSet<VsCfgVmSubProcessor> subProcSet = new HashSet<VsCfgVmSubProcessor>();
        for (RecoveryProcessor proc : processors) {
            VsCfgResForVmSubProcessor resSubProc = (VsCfgResForVmSubProcessor)proc;
            ProtectObject po = this.getPoById(protectGroup, resSubProc.getPoId());
            if (null == po) {
                throw new LegoCheckedException(1073947393L, "can not find the vm in pos : " + resSubProc.getPoId());
            }
            if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) continue;
            VsCfgVmSubProcessor cfgSubProcessor = new VsCfgVmSubProcessor();
            this.initProc((RecoveryProcessor)cfgSubProcessor);
            this.initProcFromProtectObject(po, cfgSubProcessor);
            this.initProcFromResSubProc(resSubProc, cfgSubProcessor);
            subProcSet.add(cfgSubProcessor);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProcFromResSubProc(VsCfgResForVmSubProcessor resSubProc, VsCfgVmSubProcessor cfgSubProcessor) {
        cfgSubProcessor.setPoId(resSubProc.getPoId());
        cfgSubProcessor.setVmName(resSubProc.getVmName());
        cfgSubProcessor.setVmxPath(resSubProc.getVmxPath());
        cfgSubProcessor.setPreResult(resSubProc.getProcStatus());
        cfgSubProcessor.setVmMoId(resSubProc.getVmMoId());
    }

    private void initProcFromProtectObject(ProtectObject po, VsCfgVmSubProcessor cfgSubProcessor) {
        cfgSubProcessor.setGuestOsType((String)po.getProps().get("GUESTOSTYPE"));
        cfgSubProcessor.setVcenterUuid(this.vcenterUuid);
        cfgSubProcessor.setHostName((String)po.getProps().get("GUESTHOSTNAME"));
        cfgSubProcessor.setVmNetCardsInfo((String)po.getProps().get("VirtualEthernetCard"));
    }

    private void updateSubProcessors() {
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsCfgResForVmSubProcessor.class);
        Set childProcSet = this.getChildProc();
        block0: for (RecoveryProcessor childProc : childProcSet) {
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == childProc.getProcStatus()) continue;
            VsCfgVmSubProcessor cfgVmSubProc = (VsCfgVmSubProcessor)childProc;
            String childProcVmxPath = cfgVmSubProc.getVmxPath();
            for (RecoveryProcessor tempProc : processors) {
                VsCfgResForVmSubProcessor resSubProc = (VsCfgResForVmSubProcessor)tempProc;
                String vmxPath = resSubProc.getVmxPath();
                if (!vmxPath.equals(childProcVmxPath)) continue;
                cfgVmSubProc.setPreResult(resSubProc.getProcStatus());
                cfgVmSubProc.setVmMoId(resSubProc.getVmMoId());
                continue block0;
            }
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    private ProtectObject getPoById(ProtectGroup protectGroup, String poUuid) {
        for (ProtectObject tempPo : protectGroup.getPolist()) {
            if (!tempPo.getUuid().equals(poUuid)) continue;
            return tempPo;
        }
        return null;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

