/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.virtualization.sdk.model.HostSystem;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.HostUnresolvedVmfsResolutionResult;
import com.huawei.vmware.vim25.HostUnresolvedVmfsVolume;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsConfigDataStoreSubProcessor
extends BaseRecoveryProcessor {
    public static final String MOUNT_WWNS_KEY = "mount_lun_wwns";
    public static final String COMMA = ",";
    private static final long serialVersionUID = 9114701830292527904L;
    private static final String URLPRE = "ds:///vmfs/volumes/";
    private static final long SLEEP_TIME = 30000L;
    private static final List<Integer> NEED_REPLACE_DSURL_EXE_TYPE = Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue());
    private static final Log logger = LogFactory.getInstance(VsConfigDataStoreSubProcessor.class);
    private String oldDataStoreName;
    private String newDataStoreName;
    private String newDataStoreUuid;
    private Map<String, String> lunWwnsMapsnapshotWwn;
    private Set<HostSystem> drHost;
    private String hostMoId;
    private String oldDataStoreUrl;
    private String newDataStoreUrl;
    private Boolean preResult = true;
    private Boolean isMapping = true;
    private String vcenterUuid;
    private List<HostUnresolvedVmfsVolume> vmfsVolums;

    public String getNewDataStoreName() {
        return this.newDataStoreName;
    }

    public void setNewDataStoreName(String newDataStoreName) {
        this.newDataStoreName = newDataStoreName;
    }

    public String getOldDataStoreName() {
        return this.oldDataStoreName;
    }

    public void setOldDataStoreName(String oldDataStoreName) {
        this.oldDataStoreName = oldDataStoreName;
    }

    public String getNewDataStoreUuid() {
        return this.newDataStoreUuid;
    }

    public void setNewDataStoreUuid(String newDataStoreUuid) {
        this.newDataStoreUuid = newDataStoreUuid;
    }

    public Set<HostSystem> getDrHost() {
        return this.drHost;
    }

    public void setDrHost(Set<HostSystem> drHost) {
        this.drHost = drHost;
    }

    public String getHostMoId() {
        return this.hostMoId;
    }

    public void setHostMoId(String hostMoId) {
        this.hostMoId = hostMoId;
    }

    public Map<String, String> getLunWwnsMapsnapshotWwn() {
        return this.lunWwnsMapsnapshotWwn;
    }

    public void setLunWwnsMapsnapshotWwn(Map<String, String> lunWwnsMapsnapshotWwn) {
        this.lunWwnsMapsnapshotWwn = lunWwnsMapsnapshotWwn;
    }

    public String getOldDataStoreUrl() {
        return this.oldDataStoreUrl;
    }

    public void setOldDataStoreUrl(String oldDataStoreUrl) {
        this.oldDataStoreUrl = oldDataStoreUrl;
    }

    public String getNewDataStoreUrl() {
        return this.newDataStoreUrl;
    }

    public void setNewDataStoreUrl(String newDataStoreUrl) {
        this.newDataStoreUrl = newDataStoreUrl;
    }

    public void setIsMapping(Boolean isMapping) {
        this.isMapping = isMapping;
    }

    public Boolean getPreResult() {
        return this.preResult;
    }

    public void setPreResult(Boolean preResult) {
        this.preResult = preResult;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public List<HostUnresolvedVmfsVolume> getVmfsVolums() {
        return this.vmfsVolums;
    }

    public void setVmfsVolums(List<HostUnresolvedVmfsVolume> vmfsVolums) {
        this.vmfsVolums = vmfsVolums;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)("Config DataStore[" + this.oldDataStoreName + "] start,hostMoId=" + this.hostMoId), 90160758786816L);
        this.updateProcessNameParams(new String[]{this.getOldDataStoreName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.dataStore.already.config", new String[]{this.getOldDataStoreName()});
            logger.debug((Object)("dataStore has been config success, dataStoreName=" + this.getOldDataStoreName()), 90160758786988L);
            return true;
        }
        boolean result = true;
        if (!this.preResult.booleanValue()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            if (!this.isMapping.booleanValue()) {
                this.updateProcessDetail("lego.err.1073948691", new String[0]);
            }
            return true;
        }
        if (null == this.vcenterUuid) {
            logger.error((Object)"get vcenter connection failed:", 90160758786988L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        try {
            Map<String, Object> resultMapAgain;
            Map<String, Object> resultMap = this.checkIsAutoMountAllHost(true);
            this.checkAndReplaceOldDatastoreUrl();
            if (((Boolean)resultMap.get("isAutoConfig")).booleanValue()) {
                logger.info((Object)("The datastore is auto mounted:resultMap=" + resultMap), 90160758786988L);
                this.setNewDataStore(resultMap);
            } else {
                result = this.mountDataStore();
            }
            if (!result && ((Boolean)(resultMapAgain = this.checkIsAutoMountAllHost(false)).get("isAutoConfig")).booleanValue()) {
                logger.info((Object)("The datastore is auto mounted:resultMap=" + resultMap), 90160758786988L);
                result = true;
                this.setNewDataStore(resultMap);
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            logger.error((Object)("config datastore[" + this.oldDataStoreName + "] failed."), (Throwable)e, 90160758784001L);
            return true;
        }
        catch (Exception e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreSubProcessor.fail1", new String[]{this.getOldDataStoreName()});
            logger.error((Object)("config datastore[" + this.oldDataStoreName + "] failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return true;
        }
        if (result) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            logger.debug((Object)("Config DataStore[" + this.oldDataStoreName + "] success and finish."), 90160758786816L);
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            logger.debug((Object)("Config DataStore[" + this.oldDataStoreName + "] failed."), 90160758786816L);
        }
        return true;
    }

    private void setNewDataStore(Map<String, Object> resultMap) {
        this.setNewDataStoreName((String)resultMap.get("newDataStoreName"));
        this.setNewDataStoreUuid((String)resultMap.get("newDataStoreUuid"));
        this.setNewDataStoreUrl((String)resultMap.get("newDataStoreUrl"));
    }

    protected String generateResultKey() {
        return null;
    }

    private Map<String, Object> checkIsAutoMountAllHost(boolean wait) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        DataStoreAction dsAction = new DataStoreAction();
        boolean isCorrectDataStore = false;
        int ptType = this.getContextRef().getProtectGroup().getTemplate().getType();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType() && PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(ptType) && wait) {
            for (int time = 0; time < 2 && !(isCorrectDataStore = this.checkAutoMount(dsAction, resultMap)); ++time) {
                CommUtil.pauseThread((long)30000L);
            }
        } else {
            isCorrectDataStore = this.checkAutoMount(dsAction, resultMap);
        }
        resultMap.put("isAutoConfig", isCorrectDataStore);
        return resultMap;
    }

    private boolean checkAutoMount(DataStoreAction dsAction, Map<String, Object> resultMap) {
        boolean isCorrectDataStore = false;
        boolean hasSucess = false;
        boolean hasFail = false;
        List<VsphereDataStore> datastores = dsAction.queryAllDsWithoutValidate(this.vcenterUuid);
        HostSystemAction hostAction = new HostSystemAction();
        Set<String> hostMoIds = hostAction.getAllHostMoIdsFromCluster(this.vcenterUuid, this.hostMoId);
        for (String hostId : hostMoIds) {
            logger.debug((Object)"check host[%s] start.", new Object[]{hostId});
            isCorrectDataStore = this.checkIsAutoMount(resultMap, datastores, hostId);
            if (isCorrectDataStore) {
                logger.info((Object)"check mounted info for host[%s] end. the datastores auto mount success.", new Object[]{hostId});
                hasSucess = true;
                continue;
            }
            logger.info((Object)"check mounted info for host[%s] end. the datastores not found in host.", new Object[]{hostId});
            hasFail = true;
        }
        if (hasSucess && hasFail) {
            logger.error((Object)"the datastore not found in some hosts and mount success in other hosts.");
            throw new LegoCheckedException(1073948876L);
        }
        return isCorrectDataStore;
    }

    private boolean checkIsAutoMount(Map<String, Object> resultMap, List<VsphereDataStore> datastores, String hostId) {
        HostSystemAction hostAction = new HostSystemAction();
        boolean isCorrectDataStore = false;
        for (VsphereDataStore data : datastores) {
            isCorrectDataStore = this.checkIsCorrectDataStore(data, hostId);
            logger.info((Object)"check mounted status for ( datastore : %s, host\uff1a%s). mounted status is %s .", new Object[]{data.getName(), hostId, isCorrectDataStore});
            if (!isCorrectDataStore) continue;
            hostAction.mountDataStore(this.vcenterUuid, hostId, data.getUuid().split(":")[1]);
            resultMap.put("newDataStoreName", data.getName());
            String dataStoreUrl = data.getUrl();
            String dataUuid = dataStoreUrl.substring(URLPRE.length(), dataStoreUrl.length() - 1);
            resultMap.put("newDataStoreUuid", dataUuid);
            resultMap.put("newDataStoreUrl", dataStoreUrl);
            break;
        }
        return isCorrectDataStore;
    }

    private boolean checkIsCorrectDataStore(VsphereDataStore data, String hostId) {
        DataStoreAction dsAction = new DataStoreAction();
        Set<String> moIds = dsAction.getDataStoreMountHostMoId(this.vcenterUuid, data);
        if (!moIds.contains(hostId)) {
            logger.info((Object)"esx auto configure datastore fail. datastore mounted hosts do not contains target hostId.");
            return false;
        }
        HashSet<String> luns = new HashSet<String>();
        HashSet<String> srcLun = new HashSet<String>();
        ArrayList<String> uuidList = new ArrayList<String>();
        uuidList.add(data.getUuid().split(":")[1]);
        List<String> lunWwnList = dsAction.getLunFromDsMoIds(this.vcenterUuid, uuidList);
        for (String lunWwn : lunWwnList) {
            luns.add(lunWwn);
        }
        for (Map.Entry<String, String> m : this.lunWwnsMapsnapshotWwn.entrySet()) {
            if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue()) {
                srcLun.add(m.getValue());
                continue;
            }
            srcLun.add(m.getKey());
        }
        if (VerifyUtil.isEmpty(luns)) {
            return false;
        }
        Iterator srcIt = luns.iterator();
        while (srcIt.hasNext()) {
            if (srcLun.contains(srcIt.next())) continue;
            return false;
        }
        logger.debug((Object)("esx auto configure datastore " + data.getName() + " success"), 90160758786816L);
        return true;
    }

    private void checkAndReplaceOldDatastoreUrl() {
        ProtectGroup pg = this.getContextRef().getProtectGroup();
        int ptType = pg.getTemplate().getType();
        if (!NEED_REPLACE_DSURL_EXE_TYPE.contains(this.getProcType()) || !PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(ptType)) {
            return;
        }
        ProtectGroupReplica replica = (ProtectGroupReplica)this.getContextRef().getAttribute("Recovery_PgReplica");
        if (null == replica) {
            logger.error((Object)"the replica is null");
            throw new LegoCheckedException(1073947394L);
        }
        HashSet<String> backupWwns = new HashSet<String>();
        Set poReplicas = replica.getReplicas();
        HashMap<String, String> masterWwnAndSlaveWwn = new HashMap<String, String>();
        HashMap<String, String> srcAndSlaveMapping = new HashMap<String, String>();
        HashMap<String, String> srcSnLunIdAndWwn = new HashMap<String, String>();
        HashMap<String, String> slaveSnLunIdAndWwn = new HashMap<String, String>();
        VsphereCommUtil.initMasterAndSlaveMap(srcAndSlaveMapping, srcSnLunIdAndWwn, slaveSnLunIdAndWwn, this.getContextRef().getProtectGroup());
        this.initMasterWwnAndSlaveWwn(masterWwnAndSlaveWwn, srcSnLunIdAndWwn, srcAndSlaveMapping, slaveSnLunIdAndWwn);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            this.buildOldDatastoreUrl(masterWwnAndSlaveWwn, poReplicas);
            backupWwns.addAll(this.lunWwnsMapsnapshotWwn.keySet());
        } else {
            Map storageIdAndwwn = (Map)this.getContextRef().getAttribute("storage_id_wwn_map_config_datastore");
            if (null == storageIdAndwwn) {
                logger.error((Object)"StorageIdAndwwn is null");
                throw new LegoCheckedException(1073947394L);
            }
            Set<String> tarWwn = this.lunWwnsMapsnapshotWwn.keySet();
            this.buildOldDatastoreUrl(backupWwns, tarWwn, poReplicas, storageIdAndwwn);
        }
        HashSet<String> tarWwns = new HashSet<String>();
        for (String wwn : backupWwns) {
            for (Map.Entry entry : masterWwnAndSlaveWwn.entrySet()) {
                if (!((String)entry.getKey()).equals(wwn) && !((String)entry.getValue()).equals(wwn)) continue;
                tarWwns.add((String)entry.getKey());
            }
        }
        String wwnStr = this.convertCollectionToString(tarWwns, COMMA);
        logger.info((Object)("backupWwns : " + tarWwns));
        if (VerifyUtil.isEmpty((String)wwnStr)) {
            wwnStr = "null";
        }
        this.getProps().put(MOUNT_WWNS_KEY, wwnStr);
    }

    private void initMasterWwnAndSlaveWwn(Map<String, String> masterWwnAndSlaveWwn, Map<String, String> srcSnLunIdAndWwn, Map<String, String> srcAndSlaveMapping, Map<String, String> slaveSnLunIdAndWwn) {
        Set<Map.Entry<String, String>> masterAndSlaves = srcAndSlaveMapping.entrySet();
        for (Map.Entry<String, String> masterAndSlave : masterAndSlaves) {
            masterWwnAndSlaveWwn.put(srcSnLunIdAndWwn.get(masterAndSlave.getKey()), slaveSnLunIdAndWwn.get(masterAndSlave.getValue()));
        }
    }

    private void buildOldDatastoreUrl(Map<String, String> masterWwnAndSlaveWwn, Set<ProtectObjectReplica> poReplicas) {
        Set<String> tarWwns = this.lunWwnsMapsnapshotWwn.keySet();
        for (String wwn : tarWwns) {
            String convertWwn = null;
            for (Map.Entry<String, String> entry : masterWwnAndSlaveWwn.entrySet()) {
                if (entry.getKey().equals(wwn)) {
                    convertWwn = entry.getValue();
                    continue;
                }
                if (!entry.getValue().equals(wwn)) continue;
                convertWwn = entry.getKey();
            }
            for (ProtectObjectReplica protectObjectReplica : poReplicas) {
                String oldDatastoreUrl = this.getOldDataStoreUrlFromPoMatadata(protectObjectReplica, wwn);
                if (null == oldDatastoreUrl) {
                    oldDatastoreUrl = this.getOldDataStoreUrlFromPoMatadata(protectObjectReplica, convertWwn);
                    if (null != oldDatastoreUrl) {
                        this.setOldDataStoreUrl(oldDatastoreUrl);
                    }
                } else {
                    this.setOldDataStoreUrl(oldDatastoreUrl);
                }
                logger.info((Object)("getOldDataStoreUrlFromPoMatadata is " + oldDatastoreUrl));
            }
        }
    }

    private void buildOldDatastoreUrl(Set<String> backupWwns, Collection<String> tarWwn, Set<ProtectObjectReplica> poReplicas, Map<String, String> storageIdAndwwn) {
        for (ProtectObjectReplica protectObjectReplica : poReplicas) {
            HashSet<String> storageIds = new HashSet<String>();
            for (String wwn : tarWwn) {
                Set<Map.Entry<String, String>> tempEntries = storageIdAndwwn.entrySet();
                for (Map.Entry<String, String> tempEntry : tempEntries) {
                    if (!wwn.equals(tempEntry.getValue())) continue;
                    storageIds.add(tempEntry.getKey());
                }
            }
            Set relicaStorageInfos = protectObjectReplica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)relicaStorageInfos)) {
                logger.error((Object)"relicaStorageInfos is empty.");
                throw new LegoCheckedException(1073947394L);
            }
            Map.Entry<String, String> entry = this.lunWwnsMapsnapshotWwn.entrySet().iterator().next();
            boolean isSnapshot = !entry.getKey().equals(entry.getValue());
            for (RelicaStorageInfo relicaStorageInfo : relicaStorageInfos) {
                String targetSourceId = isSnapshot ? relicaStorageInfo.getSrcStorageId() : relicaStorageInfo.getStorageId();
                if (!storageIds.contains(targetSourceId)) continue;
                String oldDatastoreUrl = this.getOldDataStoreUrlFromPoMatadata(protectObjectReplica, relicaStorageInfo.getProtectObjectStorageWwn());
                if (null != oldDatastoreUrl) {
                    this.setOldDataStoreUrl(oldDatastoreUrl);
                }
                backupWwns.add(relicaStorageInfo.getProtectObjectStorageWwn());
            }
        }
    }

    private String getOldDataStoreUrlFromPoMatadata(ProtectObjectReplica protectObjectReplica, String oldMasterWWn) {
        String poMetadata = protectObjectReplica.getPoMetadata();
        if (null == poMetadata || poMetadata.trim().isEmpty() || null == oldMasterWWn) {
            logger.info((Object)"this protectObjectReplica don't have poMetadata.");
            return null;
        }
        JSONObject poMetadataJson = JSONObject.fromObject((Object)poMetadata);
        JSONArray poStorageInfos = poMetadataJson.getJSONArray("poStorageInfos");
        if (null == poStorageInfos || poStorageInfos.size() == 0) {
            logger.info((Object)"this protectObjectReplica don't have poMetadata.");
            return null;
        }
        for (int i = 0; i < poStorageInfos.size(); ++i) {
            JSONObject storageInfo = poStorageInfos.getJSONObject(i);
            String mountPoint = storageInfo.getString("mountPoint");
            String lunWWN = storageInfo.getString("lunWWN");
            if (!oldMasterWWn.equals(lunWWN)) continue;
            return mountPoint;
        }
        return null;
    }

    private String convertCollectionToString(Collection<String> wwns, String splitStr) {
        StringBuilder buildWwns = new StringBuilder();
        if (VerifyUtil.isEmpty(wwns)) {
            return buildWwns.toString();
        }
        for (String wwn : wwns) {
            buildWwns.append(wwn).append(splitStr);
        }
        return buildWwns.substring(0, buildWwns.length() - 1);
    }

    private boolean mountDataStore() {
        HostSystemAction hostSys = new HostSystemAction();
        List<String> wwnList = this.getTgtLunWwnList();
        logger.info((Object)("begin to resignature the datastore:hostMoId=" + this.hostMoId + " oldDataStoreName=" + this.oldDataStoreName + " wwnList=" + wwnList), 90160758786988L);
        int ptType = this.getContextRef().getProtectGroup().getTemplate().getType();
        List<HostUnresolvedVmfsResolutionResult> results = NEED_REPLACE_DSURL_EXE_TYPE.contains(this.getProcType()) && PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(ptType) ? hostSys.mountUnSolvedDataStore(this.vcenterUuid, this.hostMoId, null, this.vmfsVolums, wwnList) : hostSys.mountUnSolvedDataStore(this.vcenterUuid, this.hostMoId, this.oldDataStoreName, this.vmfsVolums, wwnList);
        if (!VerifyUtil.isEmpty(results)) {
            if (!VerifyUtil.isEmpty((Object)results.get(0).getFault()) || VerifyUtil.isEmpty((String)results.get(0).getVmfs().getUuid())) {
                logger.error((Object)("mountUnSolvedDataStore failed" + results.get(0).getFault().getLocalizedMessage()), 90160758786989L);
                return false;
            }
        } else {
            logger.error((Object)"mountUnSolvedDataStore result is empty", 90160758786989L);
            return false;
        }
        this.newDataStoreName = results.get(0).getVmfs().getName();
        this.newDataStoreUuid = results.get(0).getVmfs().getUuid();
        this.newDataStoreUrl = URLPRE + this.newDataStoreUuid + "/";
        logger.info((Object)("resignature ds sucessfully:oldDsName=" + this.oldDataStoreName + " newDsName=" + this.newDataStoreName + " newDsUuid=" + this.newDataStoreUuid + " newDsUrl=" + this.newDataStoreUrl));
        return true;
    }

    private List<String> getTgtLunWwnList() {
        ArrayList<String> wwnList = new ArrayList<String>();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue() == this.getProcType()) {
            wwnList.addAll(this.lunWwnsMapsnapshotWwn.values());
        } else {
            wwnList.addAll(this.lunWwnsMapsnapshotWwn.keySet());
        }
        return wwnList;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

