/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.vsphere.recovery.process.VsConfigVMProfileSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsUnmountDsAndLunProcessor;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsConfigVMProfileProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 8915083753188430165L;
    private static final List<Integer> NEED_REPLACE_DSURL_EXE_TYPE = Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue());
    private static final Log logger = LogFactory.getInstance(VsConfigVMProfileProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        String vcUuid;
        boolean createResult;
        String dcName = (String)context.getRecoveryPlan().getGlobalSettings().get("VSDATACENTERNAME");
        int procType = this.getProcType();
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && !(createResult = this.createSubProcessors(context, vcUuid = this.getDisasterHostSn(context, procType), dcName))) {
            logger.info((Object)"create subprocessors error.", 90160758786988L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ArrayList subProcessors = new ArrayList();
        subProcessors.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessors, (boolean)false);
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    protected String generateResultKey() {
        logger.debug((Object)"generateResultKey start");
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        logger.debug((Object)"getName start");
        return ((Object)((Object)this)).getClass().getName();
    }

    private boolean createSubProcessors(RecoveryProcessorContext context, String vcUuid, String dcName) {
        logger.debug((Object)"createSubProcessors start");
        HashSet<VsConfigVMProfileSubProcessor> configSubProcessors = new HashSet<VsConfigVMProfileSubProcessor>();
        Set allPOs = RecoveryToolsUtil.getInstance().getHistoryProtectGroupFromContext(context).getPolist();
        for (ProtectObject po : allPOs) {
            int poStatus = po.getPoStatus();
            if (ProtectObjectStatusEnum.INVALID.getValue() == poStatus || ProtectObjectStatusEnum.UNSUPPORTED.getValue() == poStatus) continue;
            String vmName = po.getName();
            if (10 == po.getPoType() && this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue()) {
                vmName = vmName + "_" + context.getProtectGroupReplica().getId();
            }
            VsConfigVMProfileSubProcessor processor = new VsConfigVMProfileSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setPoId(po.getUuid());
            processor.setOldvmxPath((String)po.getProps().get("VMPATH"));
            processor.setVcUuid(vcUuid);
            processor.setDcName(dcName);
            processor.setVmName(vmName);
            int ptType = this.getContextRef().getProtectGroup().getTemplate().getType();
            if (NEED_REPLACE_DSURL_EXE_TYPE.contains(this.getProcType()) && PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(ptType)) {
                Map<String, String> allScsiNOAndLunWwn = this.getAllScsiNOAndLunWwn();
                if (allScsiNOAndLunWwn.isEmpty()) {
                    return false;
                }
                Set<Map.Entry<String, String>> entities = allScsiNOAndLunWwn.entrySet();
                for (Map.Entry<String, String> entry : entities) {
                    if (!entry.getKey().equals(po.getName() + "_scsi_number")) continue;
                    processor.getProps().put(vmName + "_scsi_number", entry.getValue());
                }
            }
            configSubProcessors.add(processor);
        }
        this.setChildProc(configSubProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private Map<String, String> getAllScsiNOAndLunWwn() {
        ProtectGroup pg = this.getContextRef().getProtectGroup();
        HashMap<String, String> allScsiNOAndLunWwn = new HashMap<String, String>();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue() == this.getProcType()) {
            allScsiNOAndLunWwn.putAll(VsphereCommUtil.getPoScsiNumInfo(pg));
        } else {
            List unmountProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsUnmountDsAndLunProcessor.class);
            for (RecoveryProcessor processor : unmountProcessors) {
                Map prop = ((VsUnmountDsAndLunProcessor)((Object)VsUnmountDsAndLunProcessor.class.cast(processor))).getProps();
                Set entities = prop.entrySet();
                for (Map.Entry entry : entities) {
                    if (!((String)entry.getKey()).endsWith("_scsi_number")) continue;
                    allScsiNOAndLunWwn.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        return allScsiNOAndLunWwn;
    }

    private String getDisasterHostSn(RecoveryProcessorContext context, int procType) {
        logger.debug((Object)("getDisasterHostSn start:pgId=" + context.getProtectGroup().getUuid()));
        String deviceSn = (String)context.getRecoveryPlan().getGlobalSettings().get("PG_DISASTER_HOST");
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == procType) {
            return context.getProtectGroup().getPoProviderSN();
        }
        for (RecoverySetting setting : context.getRecoveryPlan().getRecoverySettings()) {
            if (!setting.getOwnerId().equals(context.getProtectGroup().getUuid()) || !setting.getName().equals("PG_DISASTER_HOST")) continue;
            deviceSn = setting.getValue();
            break;
        }
        return deviceSn;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsConfigVMProfileProcessor.des");
    }
}

