/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.sdk.model.NFSShare;
import com.huawei.ism.drm.virtualization.observer.ObserverManager;
import com.huawei.ism.drm.virtualization.sdk.model.DataStoreInfo;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.ism.drm.vsphere.recovery.process.VsCreateNasDsSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;

public class VsCreateNasDsProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6660512498466319320L;
    private static final Log logger = LogFactory.getInstance(VsCreateNasDsProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.createSubProcessor(context);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        ArrayList subProcessors = new ArrayList();
        subProcessors.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessors, (boolean)false);
        recoveryTemplate.process(context);
        this.postCreateDataStoreObserver();
        boolean ret = this.calcProcessResultBySubProc();
        return ret;
    }

    private void postCreateDataStoreObserver() {
        ProtectGroup pg = this.getContextRef().getProtectGroup();
        if (14 != pg.getTemplate().getType() && 17 != pg.getTemplate().getType() && 28 != pg.getTemplate().getType()) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> dsChangeMap = new HashMap<String, String>();
        dataMap.put("pgobj", pg);
        String dsInfosStr = (String)pg.getProps().get("pgDsInfo");
        JSONArray dsArray = JSONArray.fromObject((Object)dsInfosStr);
        HashSet<DataStoreInfo> dataStoreInfoSet = new HashSet<DataStoreInfo>(JSONArray.toCollection((JSONArray)dsArray, DataStoreInfo.class));
        Set childProc = this.getChildProc();
        for (RecoveryProcessor processor : childProc) {
            VsCreateNasDsSubProcessor subProc;
            if (!(processor instanceof VsCreateNasDsSubProcessor) || VerifyUtil.isEmpty((String)(subProc = (VsCreateNasDsSubProcessor)processor).getDsUuid())) continue;
            String oldDsUuid = this.getOldDsuuid(dataStoreInfoSet, subProc.getDsName());
            dsChangeMap.put(oldDsUuid, subProc.getDsUuid());
        }
        dataMap.put("dsmap", dsChangeMap);
        ObserverManager.getInstance((String)"RE_CREATE_DATASTORE_MANAGER").syncNotifyAllObservers(dataMap);
    }

    private String getOldDsuuid(Set<DataStoreInfo> dataStoreInfoSet, String dsName) {
        for (DataStoreInfo dsinfo : dataStoreInfoSet) {
            if (!dsName.equals(dsinfo.getDataStoreName())) continue;
            return dsinfo.getDataStoreUuid();
        }
        return null;
    }

    private void createSubProcessor(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        if (14 == pg.getTemplate().getType() || 17 == pg.getTemplate().getType() || 28 == pg.getTemplate().getType()) {
            this.createSnapshotSubProcessor(pg);
        } else {
            this.createRepliSubProcessor(context);
        }
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    private void createSnapshotSubProcessor(ProtectGroup pg) {
        String tempStr = (String)pg.getProps().get("pg_topo");
        JSONArray jsonArray = JSONArray.fromObject((Object)tempStr);
        JSONObject jsonObj = jsonArray.getJSONObject(0);
        String compResUuid = jsonObj.getString("computResourceUuid");
        String vcenterUuid = pg.getPoProviderSN();
        HashMap<String, String> nameWwnMap = new HashMap<String, String>();
        HashMap<String, String> urlWwnMap = new HashMap<String, String>();
        VirtualizationCommonUtil commonUtil = VirtualizationCommonUtil.getInstance();
        for (ProtectObject po : this.getContextRef().getRecoveryProtectObjects()) {
            ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)commonUtil.getElementFromCollection((Collection)po.getUsedStorageResourceSet());
            String wwn = storageInfo.getLunWWN();
            String dsName = storageInfo.getDeviceName();
            if (nameWwnMap.containsKey(wwn)) continue;
            nameWwnMap.put(wwn, dsName);
            urlWwnMap.put(wwn, storageInfo.getMountPoint());
        }
        HashSet<VsCreateNasDsSubProcessor> subProcSet = new HashSet<VsCreateNasDsSubProcessor>();
        for (Map.Entry entry : nameWwnMap.entrySet()) {
            String[] pathInfo = ((String)entry.getKey()).split(":");
            VsCreateNasDsSubProcessor dsSubProc = new VsCreateNasDsSubProcessor();
            this.initProc((RecoveryProcessor)dsSubProc);
            dsSubProc.setDsName((String)entry.getValue());
            dsSubProc.setVcenterUuid(vcenterUuid);
            dsSubProc.setStorageSrvIp(pathInfo[0]);
            dsSubProc.setCompResUuid(compResUuid);
            dsSubProc.setSharePath(pathInfo[1]);
            dsSubProc.setOldDataStoreUrl((String)urlWwnMap.get(entry.getKey()));
            subProcSet.add(dsSubProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void createRepliSubProcessor(RecoveryProcessorContext context) {
        RecoveryPlan plan = this.getContextRef().getRecoveryPlan();
        Map globalSettings = plan.getGlobalSettings();
        String hostMap = (String)globalSettings.get("recoveryHosts");
        JSONArray jsonArr = JSONArray.fromObject((Object)hostMap);
        JSONObject mapJson = jsonArr.getJSONObject(0);
        String vcenterUuid = (String)mapJson.get("remoteVcenterId");
        String comResUuid = mapJson.getString("remoteHostId");
        HashSet<VsCreateNasDsSubProcessor> subProcSet = new HashSet<VsCreateNasDsSubProcessor>();
        HashedMap dsNameMap = new HashedMap();
        HashedMap dsUrlMap = new HashedMap();
        this.generateNameAndUrl(context, (Map<String, String>)dsNameMap, (Map<String, String>)dsUrlMap);
        Set set = context.getProtectGroup().getReplicaList();
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)CommonUtil.getFirstElement((Collection)set);
        if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
            logger.error((Object)"protectGroupReplica is null");
            return;
        }
        HashSet<String> storageSet = new HashSet<String>();
        for (ProtectObjectReplica poReplica : protectGroupReplica.getReplicas()) {
            RelicaStorageInfo storageInfo = (RelicaStorageInfo)CommonUtil.getFirstElement((Collection)poReplica.getStorageInfos());
            String devSn = storageInfo.getStorageProviderSN();
            String storageId = storageInfo.getStorageId();
            String storageStr = devSn + ":" + storageId;
            if (storageSet.contains(storageStr)) {
                logger.info((Object)("has same name file systems in pg:" + storageStr));
                continue;
            }
            storageSet.add(storageStr);
            IStorageFileSystemManager storageFileSystemManager = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(devSn);
            String vstoreId = RecoveryProcessUtil.getVstoreIdByResourceId((String)devSn, (String)storageId);
            NFSShare shareInfo = storageFileSystemManager.getNFSShare(devSn, storageId, vstoreId);
            if (null == shareInfo) {
                logger.error((Object)("share is not existed!" + storageId));
                subProcSet.clear();
                break;
            }
            VsCreateNasDsSubProcessor dsSubProc = new VsCreateNasDsSubProcessor();
            String key = storageInfo.getSrcStorageProviderSN() + ":" + storageInfo.getSrcStorageId();
            this.initProc((RecoveryProcessor)dsSubProc);
            dsSubProc.setDsName((String)dsNameMap.get(key));
            dsSubProc.setVcenterUuid(vcenterUuid);
            dsSubProc.setSharePath(shareInfo.getSharePath());
            dsSubProc.setCompResUuid(comResUuid);
            dsSubProc.setOldDataStoreUrl((String)dsUrlMap.get(key));
            subProcSet.add(dsSubProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void generateNameAndUrl(RecoveryProcessorContext context, Map<String, String> dsNameMap, Map<String, String> dsUrlMap) {
        ProtectGroup protectGroup = context.getProtectGroup();
        Set set = protectGroup.getReplicaList();
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)CommonUtil.getFirstElement((Collection)set);
        if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
            logger.error((Object)"protectGroupReplica is null");
            return;
        }
        HashedMap poMap = new HashedMap();
        for (ProtectObjectReplica poReplica : protectGroupReplica.getReplicas()) {
            String poId = poReplica.getPoId();
            for (RelicaStorageInfo storageInfo : poReplica.getStorageInfos()) {
                poMap.put(poId, storageInfo.getSrcStorageProviderSN() + ":" + storageInfo.getSrcStorageId());
            }
        }
        for (ProtectObject object : protectGroup.getPolist()) {
            if (!object.getUsedStorageResourceSet().iterator().hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)object.getUsedStorageResourceSet().iterator().next();
            String key = (String)poMap.get(object.getUuid());
            dsNameMap.put(key, storageInfo.getDeviceName());
            dsUrlMap.put(key, storageInfo.getMountPoint());
        }
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreProcessor.des");
    }
}

