/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.SyncLockManager;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import java.util.concurrent.locks.ReentrantLock;

public class VsEndRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 7466261597811296245L;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessName(this.calcProcessName());
        int procResult = this.getPreviousProcessorStatus();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == procResult) {
            procResult = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        }
        this.setProcStatus(procResult);
        return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == procResult;
    }

    public int getPreviousProcessorStatus() {
        RecoveryProcessor preProcessor;
        for (preProcessor = this.getPreviousProcessor(); null != preProcessor && !preProcessor.getIsEnabled().booleanValue(); preProcessor = preProcessor.getPreviousProcessor()) {
        }
        int procResult = DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        if (null != preProcessor) {
            procResult = preProcessor.getProcStatus();
        }
        return procResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRecoveryPlanProgress(String recoveryPlanId, int progressRatio) {
        ReentrantLock lock = SyncLockManager.getSyncLock((String)recoveryPlanId);
        lock.lock();
        try {
            if (0 < progressRatio && 100 >= progressRatio && (null == this.getChildProc() || this.getChildProc().isEmpty()) && !this.getHasChildProc().booleanValue()) {
                IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
                recoveryProcessService.updateRecoveryPlanProgress(recoveryPlanId, 100);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    private String calcProcessName() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            return "ism.drm.clean.end.process.name";
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType()) {
            return "ism.drm.testing.end.process.name";
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            return "ism.drm.planedmotion.end.process.name";
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType()) {
            return "ism.drm.reprotect.end.process.name";
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue() == this.getProcType()) {
            return "ism.drm.mountReplica.end.process.name";
        }
        return "ism.drm.recovery.end.process.name";
    }

    public void updateDescription() {
        this.setDescription("ism.drm.recovery.end.process.des");
    }
}

