/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;
import java.util.Set;

public class VsHangupNoncriticalVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 1L;
    private String vmName = "";
    private String vmUuid = "";
    private final Log logger = LogFactory.getInstance(VsHangupNoncriticalVmSubProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.vmName});
        String vcenterUuid = this.getVmwareConnUuid(context);
        ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(this.vmUuid, "VirtualMachine");
        VMAction action = new VMAction();
        try {
            VirtualMachinePowerState powserState = action.getVMPowerState(vcenterUuid, vmMor.getValue());
            if (null == powserState) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("ism.drm.recovery.vsphere.vm.unregister.already", new String[]{this.vmName});
                this.logger.info((Object)("vm alreay powser off:" + this.vmName), 90160758786988L);
                return true;
            }
            if (VirtualMachinePowerState.POWERED_OFF.equals((Object)powserState)) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                this.logger.info((Object)("vm alreay powser off:" + this.vmName), 90160758786988L);
                return true;
            }
            VirtualMachineToolsRunningStatus vmtoolState = action.getGuestVMToolState(vcenterUuid, this.vmUuid);
            if (VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING.equals((Object)vmtoolState)) {
                action.shutdownGuest(vcenterUuid, vmMor.getValue());
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            } else {
                this.logger.error((Object)("VMTools not ready:vmName=" + this.vmName), 90160758787071L);
                this.updateProcessDetail("lego.err.1073948868", null);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("shutdown noncritical vm failed:" + this.vmName), (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        catch (Exception e) {
            this.logger.error((Object)("shutdown noncritical vms failed:" + this.vmName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.updateProcessDetail(((Object)((Object)this)).getClass().getName() + ".failed", new String[]{this.vmName});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        return true;
    }

    private String getVmwareConnUuid(RecoveryProcessorContext context) {
        RecoveryPlan plan = context.getRecoveryPlan();
        String planId = plan.getPlanId();
        ProtectGroup pg = plan.getProtectGroup();
        String pgId = pg.getUuid();
        RecoverySetting setting = RecoveryUtil.getRecoverySetting((String)planId, (String)pgId, (String)"PG_DISASTER_HOST", (Set)plan.getRecoverySettings());
        String vcenterSn = null;
        if (!VerifyUtil.isEmpty((Object)setting)) {
            vcenterSn = setting.getValue();
        }
        return vcenterSn;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public String getVmUuid() {
        return this.vmUuid;
    }

    public void setVmUuid(String vmUuid) {
        this.vmUuid = vmUuid;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

