/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.vsphere.recovery.process.VsConfigVMProfileSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsInitVmSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VsInitVmsProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -261392725612264076L;
    private static final Log logger = LogFactory.getInstance(VsInitVmsProcessor.class);
    private static final List<Integer> ONLY_SCAN_PT_TYPE = Arrays.asList(30, 31, 32);
    private String vcenterUuid;

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((String)this.vcenterUuid)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            logger.error((Object)"vcenteruuid is null ", 90160758786989L);
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        ArrayList subProcessors = new ArrayList();
        subProcessors.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessors, (boolean)false);
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        return executeResult;
    }

    private void updateSubProcessors() {
        RecoveryPlan plan = this.getContextRef().getRecoveryPlan();
        ProtectGroup pg = RecoveryToolsUtil.getInstance().getHistoryProtectGroupFromContext(this.getContextRef());
        boolean isNasRecovery = RecoveryProcessUtil.isProtectGroupUseNasFileSystem((ProtectGroup)pg);
        HashSet<RecoveryProcessor> subProcSet = new HashSet<RecoveryProcessor>();
        int ptType = this.getContextRef().getProtectGroup().getTemplate().getType();
        if ((isNasRecovery || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) && !ONLY_SCAN_PT_TYPE.contains(ptType)) {
            this.createNasSubProcessor(pg, subProcSet);
        } else {
            this.createLunSubProcessor(plan, subProcSet);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void createNasSubProcessor(ProtectGroup pg, Set<RecoveryProcessor> subProcSet) {
        for (ProtectObject po : pg.getPolist()) {
            String poId = po.getUuid();
            int poStatus = po.getPoStatus();
            String vmName = po.getName();
            vmName = this.updateVmName(vmName);
            if (VerifyUtil.isEmpty((String)poId) || ProtectObjectStatusEnum.INVALID.getValue() == poStatus || ProtectObjectStatusEnum.UNSUPPORTED.getValue() == poStatus) continue;
            VsInitVmSubProcessor subProc = new VsInitVmSubProcessor();
            this.initProc((RecoveryProcessor)subProc);
            subProc.setVmxFilePath((String)po.getProps().get("VMPATH"));
            subProc.setPoId(poId);
            subProc.setVmName(vmName);
            subProc.setVcenterUuid(this.vcenterUuid);
            subProcSet.add((RecoveryProcessor)subProc);
        }
    }

    private void createLunSubProcessor(RecoveryPlan plan, Set<RecoveryProcessor> subProcSet) {
        List processors = this.getRecoveryProcessors(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsConfigVMProfileSubProcessor.class);
        for (RecoveryProcessor processor : processors) {
            VsConfigVMProfileSubProcessor configVmSubProc = (VsConfigVMProfileSubProcessor)processor;
            String vmName = configVmSubProc.getVmName();
            vmName = this.updateVmName(vmName);
            String poId = configVmSubProc.getPoId();
            if (VerifyUtil.isEmpty((String)poId)) continue;
            VsInitVmSubProcessor subProc = new VsInitVmSubProcessor();
            this.initProc((RecoveryProcessor)subProc);
            subProc.setVmxFilePath(configVmSubProc.getVmxPath());
            subProc.setPoId(poId);
            subProc.setVmName(vmName);
            subProc.setVcenterUuid(this.vcenterUuid);
            subProcSet.add((RecoveryProcessor)subProc);
        }
    }

    private String updateVmName(String vmName) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == this.getContextRef().getRecoveryPlan().getPlanType()) {
            vmName = vmName + "_Test";
        }
        return vmName;
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

