/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.virtualization.recovery.process.MappingLunSubProcessor;
import com.huawei.ism.drm.virtualization.recovery.process.MappingSnapshotSubProcessor;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.virtualization.sdk.model.HostSystem;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsRescanHBAProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 5528063538194736252L;
    private static final Log logger = LogFactory.getInstance(VsRescanHBAProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        logger.debug((Object)"Scanning HBA RecoveryProcessor start", 90160758786816L);
        RecoveryPlan plan = context.getRecoveryPlan();
        this.setContextRef(context);
        int ptType = plan.getProtectGroup().getTemplate().getType();
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() && PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(ptType)) {
            try {
                if (this.onlyRescanHBA()) {
                    this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                    logger.debug((Object)"Scanning HBA RecoveryProcessor succesed and finished", 90160758786816L);
                    return true;
                }
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsRescanHBAProcessor.fail", null);
                return false;
            }
            catch (LegoCheckedException e) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail(e);
                logger.error((Object)"Scanning HBA RecoveryProcessor failed", (Throwable)e, 90160758784001L);
                return false;
            }
            catch (Exception e) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsRescanHBAProcessor.fail", null);
                logger.error((Object)("Scanning HBA RecoveryProcessor failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                return false;
            }
        }
        String hostOrGroupUuid = RecoveryToolsUtil.getInstance().getDisasterHostOrHostGroupId(plan, Integer.valueOf(this.getProcType()));
        if (VerifyUtil.isEmpty((String)hostOrGroupUuid)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            logger.error((Object)"Disaster ESXi is null, exit the rescanHBA ", 90160758784001L);
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsRescanHBAProcessor.fail", null);
            return false;
        }
        List<String> secondLunWwns = this.getTgtLunWwn(plan);
        if (VerifyUtil.isEmpty(secondLunWwns) && (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() != plan.getPlanType() || this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() && this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA.getValue())) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            logger.error((Object)"Disaster luns is null, exit the rescanHBA ", 90160758784001L);
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsRescanHBAProcessor.fail", null);
            return false;
        }
        List<HostSystem> powerOnHosts = this.getPowerOnHosts(hostOrGroupUuid);
        if (VerifyUtil.isEmpty(powerOnHosts)) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            logger.error((Object)"have no power on host, exit the rescanHBA ", 90160758784001L);
            this.updateProcessDetail("lego.err.1073948150", null);
            return false;
        }
        HostSystem host = powerOnHosts.get(0);
        this.setLunEsxMapAttr(context, secondLunWwns, host);
        return this.getRescanResult(plan, secondLunWwns, powerOnHosts, host);
    }

    private boolean onlyRescanHBA() {
        RecoveryProcessorContext context = this.getContextRef();
        if (null == context) {
            return false;
        }
        ProtectGroup pg = context.getProtectGroup();
        String tempStr = (String)pg.getProps().get("pg_topo");
        JSONArray jsonArray = JSONArray.fromObject((Object)tempStr);
        JSONObject jsonObj = JSONObject.fromObject((Object)jsonArray.get(0));
        String hostOrGroupUuid = jsonObj.getString("computResourceUuid");
        if (VerifyUtil.isEmpty((String)hostOrGroupUuid)) {
            return false;
        }
        List<HostSystem> powerOnHosts = this.getPowerOnHosts(hostOrGroupUuid);
        if (VerifyUtil.isEmpty(powerOnHosts)) {
            return false;
        }
        this.rescanHBA(powerOnHosts);
        return true;
    }

    private boolean getRescanResult(RecoveryPlan plan, List<String> secondLunWwns, List<HostSystem> powerOnHosts, HostSystem host) {
        try {
            this.rescanHBA(powerOnHosts);
            if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() && DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() != plan.getPlanType()) {
                this.unMountIscsiLun(secondLunWwns, host);
            } else if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
                this.mountIscsiLun(secondLunWwns, host);
            }
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            logger.debug((Object)"Scanning HBA RecoveryProcessor succesed and finished", 90160758786816L);
            return true;
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            logger.error((Object)"Scanning HBA RecoveryProcessor failed", (Throwable)e, 90160758784001L);
            return false;
        }
        catch (Exception e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsRescanHBAProcessor.fail", null);
            logger.error((Object)("Scanning HBA RecoveryProcessor failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return false;
        }
    }

    private void setLunEsxMapAttr(RecoveryProcessorContext context, List<String> secondLunWwns, HostSystem host) {
        HashMap<String, HostSystem> lunEsxMap = new HashMap<String, HostSystem>();
        for (String wwn : secondLunWwns) {
            lunEsxMap.put(wwn, host);
        }
        context.setAttribute("lunEsxMap", lunEsxMap);
    }

    private List<String> getTgtLunWwn(RecoveryPlan plan) {
        ArrayList<String> secondLunWwns = new ArrayList();
        List recoveryProcesses = new ArrayList();
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == plan.getPlanType()) {
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType()) {
                recoveryProcesses = this.getRecoveryProcessors(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, MappingSnapshotSubProcessor.class);
            } else if ((DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA.getValue() == this.getProcType()) && (recoveryProcesses = this.getRecoveryProcessors(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA, MappingSnapshotSubProcessor.class)).isEmpty()) {
                recoveryProcesses = this.getRecoveryProcessors(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA, MappingLunSubProcessor.class);
            }
            for (RecoveryProcessor process : recoveryProcesses) {
                String tgWWN = null;
                if (process instanceof MappingLunSubProcessor) {
                    MappingLunSubProcessor mappingLunProcessor = (MappingLunSubProcessor)process;
                    tgWWN = mappingLunProcessor.getLunWWN();
                } else {
                    MappingSnapshotSubProcessor mappingSubProcessor = (MappingSnapshotSubProcessor)process;
                    tgWWN = mappingSubProcessor.getSnapshotWWN();
                }
                secondLunWwns.add(tgWWN);
            }
        } else {
            secondLunWwns = this.getAllLunWwns(plan);
        }
        return secondLunWwns;
    }

    private void mountIscsiLun(List<String> lunWwns, HostSystem esxHost) {
        logger.debug((Object)"mount iscsiLun start", 90160758786816L);
        String hostMoId = esxHost.getUuid().split(":")[1];
        String vcenterUuid = esxHost.getParentMo().getUuid();
        for (String lunWwn : lunWwns) {
            HostSystemAction action = new HostSystemAction();
            action.mountScsiLUN(vcenterUuid, hostMoId, lunWwn);
        }
        logger.debug((Object)"mount iscsiLun finished", 90160758786816L);
    }

    private List<HostSystem> getPowerOnHosts(String hostOrGroupUuid) {
        String hql = "from VsphereHostSystem where computeResourceUuid = ?";
        List hosts = CommonDAOLocator.getMoDao().find(hql, new Object[]{hostOrGroupUuid});
        ArrayList<HostSystem> powerOnHosts = new ArrayList<HostSystem>();
        Iterator iterator = hosts.iterator();
        while (iterator.hasNext()) {
            String hostMoId;
            HostSystemAction action = new HostSystemAction();
            HostSystem host = (HostSystem)iterator.next();
            String vcenterUuid = host.getParentMo().getUuid();
            if (action.isHostPowerOn(vcenterUuid, hostMoId = host.getUuid().split(":")[1])) {
                powerOnHosts.add(host);
                continue;
            }
            logger.info((Object)("host is power off:hostName=" + host.getName() + " ip=" + host.getIpAddress()));
        }
        return powerOnHosts;
    }

    private void unMountIscsiLun(List<String> lunWwns, HostSystem esxHost) {
        logger.debug((Object)"unMount iscsiLun start", 90160758786816L);
        String hostMoId = esxHost.getUuid().split(":")[1];
        String vcenterUuid = esxHost.getParentMo().getUuid();
        for (String lunWwn : lunWwns) {
            HostSystemAction action = new HostSystemAction();
            action.unmountScsiLunByWwn(vcenterUuid, hostMoId, lunWwn);
        }
        logger.debug((Object)"unMount iscsiLun finished", 90160758786816L);
    }

    private void rescanHBA(List<HostSystem> esxHosts) {
        logger.debug((Object)"rescan HBA start", 90160758786816L);
        HostSystemAction action = new HostSystemAction();
        if (!esxHosts.iterator().hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        HostSystem host = esxHosts.iterator().next();
        String vcenterUuid = host.getParentMo().getUuid();
        for (HostSystem esx : esxHosts) {
            action.rescanAllHba(vcenterUuid, esx.getUuid().split(":")[1]);
            action.rescanVmfs(vcenterUuid, esx.getUuid().split(":")[1]);
        }
        logger.debug((Object)"rescan HBA finished", 90160758786816L);
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    private List<String> getAllLunWwns(RecoveryPlan plan) {
        ArrayList<String> tgtLunIds = new ArrayList<String>();
        RecoveryProcessorContext context = this.getContextRef();
        if (null == context) {
            logger.error((Object)"context is null");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = context.getProtectGroup();
        if (null == pg) {
            logger.error((Object)"pg is null");
            throw new LegoCheckedException(1073947393L);
        }
        int type = pg.getTemplate().getType();
        String tgtDeviceSn = type == 26 || type == 27 ? this.resolveDRRingReplication(context, plan, tgtLunIds) : this.resolveReplica(pg, plan, tgtLunIds);
        List tgtLuns = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getLunsByDeviceSnAndLunIds(tgtDeviceSn, tgtLunIds);
        ArrayList<String> lunWwns = new ArrayList<String>();
        for (Lun lun : tgtLuns) {
            lunWwns.add(lun.getWwn());
        }
        return lunWwns;
    }

    private String resolveReplica(ProtectGroup pg, RecoveryPlan plan, List<String> tgtLunIds) {
        String tgtDeviceSn = "";
        ArrayList replicationRelations = new ArrayList();
        Map replicationRelationBoMap = pg.getAllReplicationRelation();
        Set entrySet = replicationRelationBoMap.entrySet();
        for (Map.Entry entry : entrySet) {
            replicationRelations.addAll((Collection)entry.getValue());
        }
        for (ReplicationRelationBo bo : replicationRelations) {
            if (!VsphereRecoveryUtils.getInstance().isDeviceInSite(bo.getTgtDeviceSn(), (String)plan.getGlobalSettings().get("DISASTER_SITE_ID"))) continue;
            tgtDeviceSn = bo.getTgtDeviceSn();
            tgtLunIds.addAll(bo.getTgtLuns().values());
        }
        return tgtDeviceSn;
    }

    private String resolveDRRingReplication(RecoveryProcessorContext context, RecoveryPlan plan, List<String> tgtLunIds) {
        String tgtDeviceSn = "";
        Collection tasks = (Collection)context.getAttribute("recoveryTasks");
        RecoveryTask task = (RecoveryTask)CommonUtil.getFirstElement((Collection)tasks);
        if (null == task) {
            logger.error((Object)"task is null");
            throw new LegoCheckedException(1073947393L);
        }
        Collection allRelatedPairs = (Collection)task.getParams().get("all-related-replication-pairs");
        if (null == allRelatedPairs || allRelatedPairs.isEmpty()) {
            logger.error((Object)"task is empty");
            throw new LegoCheckedException(1073947393L);
        }
        for (ReplicationPair replicationPair : allRelatedPairs) {
            if (!VsphereRecoveryUtils.getInstance().isDeviceInSite(replicationPair.getTgtDevSN(), (String)plan.getGlobalSettings().get("DISASTER_SITE_ID"))) continue;
            tgtDeviceSn = replicationPair.getTgtDevSN();
            tgtLunIds.add(replicationPair.getTgtLunId());
        }
        return tgtDeviceSn;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsRescanHBAProcessor.des");
    }
}

