/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class VsUnmountDsPmSubProcessor
extends BaseRecoveryProcessor {
    protected static final Log logger = LogFactory.getInstance(VsUnmountDsPmSubProcessor.class);
    private static final long serialVersionUID = 1075392589986752771L;
    private String datastoreMoId;
    private String vcenterUuid;
    private String dataStoreName;

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getStopAppProcResultKey((String)this.datastoreMoId);
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.dataStoreName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.vsphere.datastore.unmount.already", new String[]{this.getDatastoreMoId()});
            logger.debug((Object)("The datastore has been unmounted, datastore name=" + this.dataStoreName), 90160758786988L);
            return true;
        }
        boolean unregiserSucess = this.doUnmount(context);
        if (unregiserSucess) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("", null);
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        return true;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private boolean doUnmount(RecoveryProcessorContext context) {
        for (int i = 0; i <= 2; ++i) {
            if (!this.doInLocal()) continue;
            return true;
        }
        return false;
    }

    private boolean doInLocal() {
        HostSystemAction hostAction = new HostSystemAction();
        try {
            this.datastoreMoId = this.removePrefix(this.datastoreMoId);
            hostAction.unmountDataStoreByUuid(this.vcenterUuid, this.datastoreMoId);
            logger.info((Object)("unmount ds success by moid,dsName=" + this.dataStoreName + " dsMoId=" + this.datastoreMoId), 90160758786988L);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("unmount datastore failed:dsName=" + this.dataStoreName + " dsMoId=" + this.datastoreMoId), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("unmount datastore failed:dsName=" + this.dataStoreName + " dsMoId=" + this.datastoreMoId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail("ism.drm.recovery.vsphere.datastore.unmount.failed", new String[]{this.dataStoreName});
            return false;
        }
        return true;
    }

    public String getDataStoreName() {
        return this.dataStoreName;
    }

    public void setDataStoreName(String dsName) {
        this.dataStoreName = dsName;
    }

    public String getDatastoreMoId() {
        return this.datastoreMoId;
    }

    public void setDatastoreMoId(String datastoreMoId) {
        this.datastoreMoId = datastoreMoId;
    }

    private String removePrefix(String uuid) {
        String result = uuid;
        if (VerifyUtil.isEmpty((String)uuid)) {
            return result;
        }
        if (uuid.contains(":")) {
            result = uuid.split(":")[1];
        }
        return result;
    }
}

