/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.sdk.service.IVsphereRecoveryService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class VsUnmountLunSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5541792266450647907L;
    private static final Log logger = LogFactory.getInstance(VsUnmountLunSubProcessor.class);
    private String lunWwn;
    private String hostMoId;
    private String vcenterUuid;
    private Boolean isPlanned;

    public String getHostMoId() {
        return this.hostMoId;
    }

    public void setHostMoId(String hostMoId) {
        this.hostMoId = hostMoId;
    }

    public String getLunWwn() {
        return this.lunWwn;
    }

    public void setLunWwn(String lunWwn) {
        this.lunWwn = lunWwn;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public Boolean getIsPlanned() {
        return this.isPlanned;
    }

    public void setIsPlanned(Boolean isPlanned) {
        this.isPlanned = isPlanned;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.lunWwn});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.vsphere.lun.unmount.already", new String[]{this.lunWwn});
            logger.debug((Object)("The Lun has been unmounted successfully:wwn=" + this.lunWwn), 90160758786988L);
            return true;
        }
        boolean unregiserSucess = this.doUnmount(context);
        if (unregiserSucess) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        return true;
    }

    private boolean doUnmount(RecoveryProcessorContext context) {
        if (this.getIsPlanned().booleanValue()) {
            String planId = context.getRecoveryPlan().getPlanId();
            return this.doPlannedInLocal(planId);
        }
        return this.doClearInLocal();
    }

    private boolean doClearInLocal() {
        HostSystemAction hostAction = new HostSystemAction();
        try {
            this.hostMoId = this.removePrefix(this.hostMoId);
            hostAction.unmountScsiLunByWwn(this.vcenterUuid, this.hostMoId, this.lunWwn);
            return true;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("unmount lun by wwn - " + this.lunWwn + " failed ."), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("unmount lun by wwn " + this.lunWwn + " failed ." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail("ism.drm.recovery.vsphere.lun.unmount.failed", new String[]{this.lunWwn});
            return false;
        }
    }

    private boolean doPlannedInLocal(String planId) {
        IVsphereRecoveryService service = (IVsphereRecoveryService)ServiceLocator.getInstance().getService(IVsphereRecoveryService.class);
        try {
            boolean ret = service.unmountScsiLun(planId, this.getLunWwn(), this.getVcenterUuid());
            logger.info((Object)("unmount lun result=" + ret + " wwn=" + this.lunWwn), 90160758786988L);
            return ret;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("unmount lun failed:wwn=" + this.lunWwn), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("unmount lun failed:wwn=" + this.lunWwn + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail("ism.drm.recovery.vsphere.lun.unmount.failed", new String[]{this.lunWwn});
            return false;
        }
    }

    private String removePrefix(String uuid) {
        String result = uuid;
        if (VerifyUtil.isEmpty((String)uuid)) {
            return result;
        }
        if (uuid.contains(":")) {
            result = uuid.split(":")[1];
        }
        return result;
    }
}

