/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.ism.drm.vsphere.adapter.action.DataCenterAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.sdk.model.VsDataCenter;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;
import java.util.Collection;
import java.util.List;

public class VsUnregisterVmSubProcessor
extends BaseRecoveryProcessor {
    protected static final Log logger = LogFactory.getInstance(VsUnregisterVmSubProcessor.class);
    private static final long serialVersionUID = 1075392589986752771L;
    private String poId;
    private String vmMoId;
    private String vmName;
    private String vcenterUuid;
    private Boolean isPlanned;
    private String dcMoId;
    private String vmxPath;

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public String getVmMoId() {
        return this.vmMoId;
    }

    public void setVmMoId(String vmMoId) {
        this.vmMoId = vmMoId;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public Boolean getIsPlanned() {
        return this.isPlanned;
    }

    public void setIsPlanned(Boolean isPlanned) {
        this.isPlanned = isPlanned;
    }

    public String getDcMoId() {
        return this.dcMoId;
    }

    public void setDcMoId(String dcMoId) {
        this.dcMoId = dcMoId;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getStopAppProcResultKey((String)this.vmMoId);
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getVmName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.vsphere.vm.unregister.already", new String[]{this.getVmName()});
            logger.debug((Object)("the virtual machine has been shutdown succ, vm name=" + this.vmName), 90160758784001L);
            return true;
        }
        boolean unregiserSucess = this.doUnregister(context);
        if (unregiserSucess) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        return true;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private boolean doUnregister(RecoveryProcessorContext context) {
        this.dcMoId = this.getIsPlanned() != false ? this.getDatacenterId(this.getContextRef()) : (String)context.getRecoveryPlan().getGlobalSettings().get("VSDATACENTERID");
        return this.doInLocal();
    }

    private boolean doInLocal() {
        boolean removeFromListSuccess;
        VMAction vmAction = new VMAction();
        if (vmAction.findVmByPath(this.vcenterUuid, this.dcMoId, this.vmxPath) == null) {
            logger.info((Object)("vm already deleted " + this.vmName), 90160758786988L);
            this.updateProcessDetail("ism.drm.recovery.vsphere.vm.unregister.already", new String[]{this.vmName});
            return true;
        }
        VirtualMachinePowerState powerState = vmAction.getVMPowerState(this.vcenterUuid, this.vmMoId);
        VirtualMachineToolsRunningStatus toolRunningState = vmAction.getGuestVMToolState(this.vcenterUuid, this.vmMoId);
        if (VirtualMachinePowerState.POWERED_ON == powerState && VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING != toolRunningState) {
            logger.error((Object)("this vm is not installed vmtools:" + this.vmName), 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948868", null);
            return false;
        }
        this.vmMoId = this.removePrefix(this.vmMoId);
        ManagedObjectReference vmMor = new ManagedObjectReference();
        vmMor.setType("VirtualMachine");
        vmMor.setValue(this.vmMoId);
        DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E state = vmAction.getGuestOSState(this.vcenterUuid, vmMor);
        if (state != DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E.NOTRUNNING) {
            logger.info((Object)("vm " + this.vmName + "status is " + state + ", shutdown it"), 90160758786988L);
            try {
                vmAction.shutdownGuest(this.vcenterUuid, this.vmMoId);
            }
            catch (LegoCheckedException e) {
                this.updateProcessDetail(e);
                logger.error((Object)("shutdown  guest " + this.vmName + " failed."), 90160758784001L);
                return false;
            }
            if (!this.checkVmShutdownResultAndWait(this.vmMoId)) {
                this.updateProcessDetail("ism.drm.recovery.vsphere.vm.shutdown.failed", new String[]{this.vmName});
                return false;
            }
        }
        logger.info((Object)("shutdown vm success.vmName=" + this.vmName), 90160758786988L);
        try {
            removeFromListSuccess = vmAction.unregisterVM(this.vcenterUuid, this.vmMoId);
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(e);
            logger.error((Object)("unregister vm:" + this.vmName + " failed."), 90160758784001L);
            return false;
        }
        if (!removeFromListSuccess) {
            this.updateProcessDetail("ism.drm.recovery.vsphere.vm.unregister.failed", new String[]{this.vmName});
            return false;
        }
        logger.info((Object)("remove from list succ:vmName=" + this.vmName), 90160758786988L);
        return true;
    }

    private String getDatacenterId(RecoveryProcessorContext context) {
        String dcId = null;
        try {
            RecoveryPlan plan = context.getRecoveryPlan();
            VirtualizationCommonUtil util = VirtualizationCommonUtil.getInstance();
            ProtectGroup pg = (ProtectGroup)util.getElementFromCollection((Collection)plan.getProtectGroups());
            String vcenterSn = pg.getPoProviderSN();
            String networkSetting = (String)((ProtectObject)pg.getPolist().iterator().next()).getProps().get("VirtualEthernetCard");
            JSONArray jsonArr = JSONArray.fromObject((Object)networkSetting);
            String netWorkUuid = jsonArr.getJSONObject(0).getString("netWorkUuid");
            netWorkUuid = netWorkUuid.split(":")[1];
            DataCenterAction action = new DataCenterAction();
            List<VsDataCenter> list = action.queryVsphereDataCenter(vcenterSn);
            for (VsDataCenter dc : list) {
                if (!dc.getNetWorks().contains(netWorkUuid)) continue;
                dcId = dc.getMoId();
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("getDatacenterId failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return dcId;
    }

    private boolean checkVmShutdownResultAndWait(String vmManagedObjectId) {
        VMAction vmAction = new VMAction();
        boolean ret = false;
        try {
            for (int i = 0; i < 50; ++i) {
                VirtualMachinePowerState status = vmAction.getVMPowerState(this.vcenterUuid, vmManagedObjectId);
                if (null != status && VirtualMachinePowerState.POWERED_OFF == status) {
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"shutdown  VM failed: thread interuptted", 90160758786989L);
            return false;
        }
        return ret;
    }

    private String removePrefix(String uuid) {
        String result = uuid;
        if (VerifyUtil.isEmpty((String)uuid)) {
            return result;
        }
        if (uuid.contains(":")) {
            result = uuid.split(":")[1];
        }
        return result;
    }

    public String getVmxPath() {
        return this.vmxPath;
    }

    public void setVmxPath(String vmxPath) {
        this.vmxPath = vmxPath;
    }
}

