/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.task.CleanTestResourcePrepare;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereVirtualMachineUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsDataCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CleanVmResourcePreparer
extends CleanTestResourcePrepare {
    private static final Log logger = LogFactory.getInstance(CleanVmResourcePreparer.class);
    private static final String WWN_REFER_TO_DATASTORE = "wwnReferToDatastore";

    public CleanVmResourcePreparer(BaseRecoveryProcessor processor) {
        super(processor);
    }

    @Override
    public void prepareTargetVirtualMachine(RecoveryProcessorContext context) {
        super.prepareTargetVirtualMachine(context);
        List registeredVmListFromDb = (List)context.getAttribute("Target_VM");
        String registeredSuffix = ":migrated";
        Set toDeleteVmMoIdSet = registeredVmListFromDb.stream().filter(vm -> !vm.getName().endsWith(registeredSuffix)).map(VsphereVirtualMachine::getVmMoId).collect(Collectors.toSet());
        ArrayList targetVms = new ArrayList();
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        if (VerifyUtil.isEmpty((String)vCenterUuid)) {
            logger.warn((Object)"vCenter is empty.");
            context.setAttribute("Target_VM", targetVms);
            return;
        }
        VmwareConnection vmwareConnection = VmwareConnectionManager.getInstance().getVmwareConnection(vCenterUuid);
        VMAction vmAction = new VMAction();
        List<VsphereVirtualMachine> vmFromVmware = vmAction.queryAllVms(vmwareConnection);
        HashMap dataCenter = new HashMap();
        vmFromVmware.stream().filter(vm -> toDeleteVmMoIdSet.contains(vm.getVmMoId())).forEach(vm -> this.fillToList(targetVms, vCenterUuid, dataCenter, (VsphereVirtualMachine)vm));
        context.setAttribute("Target_VM", targetVms);
    }

    private void fillToList(List<VsphereVirtualMachine> targetVms, String vCenterUuid, Map<String, VsDataCenter> dataCenter, VsphereVirtualMachine vm) {
        String dataCenterId = this.getDatacenterMoId(dataCenter, vCenterUuid, vm);
        vm.setDcMoId(dataCenterId);
        targetVms.add(vm);
    }

    private String getDatacenterMoId(Map<String, VsDataCenter> dataCenterMap, String vCenterUuid, VsphereVirtualMachine vm) {
        if (dataCenterMap.containsKey(vCenterUuid)) {
            return dataCenterMap.get(vCenterUuid).getMoId();
        }
        VsDataCenter center = VsphereVirtualMachineUtils.findDataCenter(vm, vCenterUuid);
        dataCenterMap.put(vCenterUuid, center);
        VerifyUtil.checkObject((Object)center);
        return center.getMoId();
    }

    @Override
    protected void prepareTargetDatastore(RecoveryProcessorContext context) {
        super.prepareTargetDatastore(context);
        context.removeAttribute("datastoreChangeMap");
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        if (VerifyUtil.isEmpty((String)vCenterUuid)) {
            logger.info((Object)"vCenter is empty.");
            context.setAttribute("Target_Datastore", Collections.emptyList());
            return;
        }
        DataStoreAction dataStoreAction = new DataStoreAction();
        List<VsphereDataStore> dataStoreListFromVcenter = dataStoreAction.queryAllDsWithoutValidate(vCenterUuid);
        Set dsUuidSetFromVcenter = dataStoreListFromVcenter.stream().map(ds -> VsphereCommUtil.getDatastoreId(ds.getUrl())).collect(Collectors.toSet());
        List targetDatastores = (List)context.getAttribute("Target_Datastore");
        List newTargetDatastoreList = targetDatastores.stream().filter(ds -> dsUuidSetFromVcenter.contains(ds.getUuid())).collect(Collectors.toList());
        context.setAttribute("Target_Datastore", newTargetDatastoreList);
    }

    @Override
    public void prepareTargetStoreageResource(RecoveryProcessorContext context) {
        super.prepareTargetStoreageResource(context);
        List targetResource = (List)context.getAttribute("Target_Storage");
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        if (VerifyUtil.isEmpty((String)vCenterUuid)) {
            logger.warn((Object)"vCenterUuid is empty.");
            context.setAttribute("Target_Storage", Collections.emptyList());
            return;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        VerifyUtil.checkObject((Object)protectGroup);
        String productArray = context.getProtectGroupReplica().getProductArray();
        targetResource = targetResource.stream().filter(res -> Objects.equals(res.getDevSn(), productArray)).collect(Collectors.toList());
        context.setAttribute("Target_Storage", targetResource);
    }

    @Override
    public void prepareTargetHost(RecoveryProcessorContext context) {
        try {
            Object hostObj = context.getAttribute("Target_Host");
            if (!VerifyUtil.isEmpty((Object)hostObj)) {
                return;
            }
            super.prepareTargetHost(context);
        }
        catch (Exception e) {
            logger.error((Object)"prepare host failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            context.setAttribute("Target_Host", Collections.emptyList());
        }
    }

    @Override
    public void prepareTargetVCenter(RecoveryProcessorContext context) {
        try {
            if (!VerifyUtil.isEmpty((Object)context.getAttribute("Target_vCenter"))) {
                return;
            }
            super.prepareTargetVCenter(context);
        }
        catch (Exception e) {
            logger.error((Object)"error for clean prepare: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }
}

