/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsNetWork;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ConfigVMNetworkSubTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(ConfigVMNetworkSubTask.class);
    private static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor.";
    private static final String HAVE_CFGED = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor.haveconfiged";
    private static final String CONFIGNETWORK_FAILED = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor.configVmNetwork.failed";
    private static final String MAC_MAP = "virtualEthernetCardMacMap";
    private VsphereVirtualMachine virtualMachine = null;

    public ConfigVMNetworkSubTask() {
    }

    public ConfigVMNetworkSubTask(VsphereVirtualMachine virtualMachine, RecoveryProcessor parentProc) {
        this.virtualMachine = virtualMachine;
        this.setParentProc(parentProc);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail(HAVE_CFGED, new String[0]);
            logger.debug((Object)"vm network has config yet\u3002", 90160758786988L);
            return true;
        }
        boolean result = this.configVmNetworks(context);
        return this.updateExecuteResult(result);
    }

    private boolean configVmNetworks(RecoveryProcessorContext context) {
        String vmMoId;
        String vcenterUuid;
        VMAction action;
        boolean cfgNetRet;
        if (null == this.virtualMachine) {
            logger.error((Object)"Virtual machine is null. ");
            return false;
        }
        this.updateProcessNameParams(new String[]{this.virtualMachine.getName()});
        String vmName = this.virtualMachine.getName();
        Collection vmNetCardsInfo = this.virtualMachine.getVirtualEthernetCardList();
        logger.debug((Object)"Virtual machine[%s] ethernet card info is %s", new Object[]{vmName, vmNetCardsInfo});
        if (VerifyUtil.isEmpty((Collection)vmNetCardsInfo)) {
            this.updateProcessDetail(CONFIGNETWORK_FAILED, new String[0]);
            return false;
        }
        Map<String, VsNetWork> vmNetworkMap = VsphereRecoveryUtils.buildRecoveryNetworkInfo(this.virtualMachine, context);
        boolean isKeepMac = VsphereRecoveryUtils.getKeepMacParam(context);
        HashMap<String, Object> keepMacMap = new HashMap<String, Object>();
        if (isKeepMac) {
            Map<String, String> virtualEthernetCardMacMap = VsphereRecoveryUtils.buildRecoveryMacInfo(this.virtualMachine);
            keepMacMap.put("keepMac", true);
            keepMacMap.put(MAC_MAP, virtualEthernetCardMacMap);
        }
        if (!(cfgNetRet = (action = new VMAction()).configVMNetWorks(vcenterUuid = (String)context.getAttribute("Target_vCenter"), vmMoId = this.virtualMachine.getVmMoId(), vmNetworkMap, false, keepMacMap))) {
            logger.error((Object)("config vm nic failed " + vmName), 90160758786989L);
            this.updateProcessDetail(CONFIGNETWORK_FAILED, new String[0]);
            return false;
        }
        logger.info((Object)("Config VM " + vmName + " network sucessfully:"));
        return true;
    }
}

