/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigVMNetworkSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class ConfigVMNetworkTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(ConfigVMNetworkSubTask.class);

    protected boolean execute(RecoveryProcessorContext context) {
        List vmList = context.getObjects("Target_VM", VsphereVirtualMachine.class);
        if (CollectionUtils.isEmpty((Collection)vmList)) {
            logger.info((Object)"VmList is empty, no need to config network.");
            return this.success();
        }
        Set<RecoveryProcessor> configVMNetSubTasks = this.createConfigVMNetworkSubTasks(vmList);
        this.setChildProc(configVMNetSubTasks);
        boolean result = this.executeSubProcessor(context);
        logger.info((Object)"ConfigVMNetworkTask result=%s", new Object[]{result});
        return result;
    }

    private Set<RecoveryProcessor> createConfigVMNetworkSubTasks(List<VsphereVirtualMachine> vmList) {
        logger.debug((Object)"createConfigVMNetworkSubTasks");
        HashSet<RecoveryProcessor> childProcessors = new HashSet<RecoveryProcessor>();
        if (vmList == null || vmList.isEmpty()) {
            logger.error((Object)"ConfigVMNetworkTask vmList is empty.");
            return childProcessors;
        }
        for (VsphereVirtualMachine vm : vmList) {
            ConfigVMNetworkSubTask subTask = new ConfigVMNetworkSubTask(vm, (RecoveryProcessor)this);
            childProcessors.add((RecoveryProcessor)subTask);
        }
        return childProcessors;
    }
}

