/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigVirtualMachineRdmDiskTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class ConfigVMRdmDiskTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(ConfigVMRdmDiskTask.class);

    protected boolean execute(RecoveryProcessorContext context) {
        HashSet<ConfigVirtualMachineRdmDiskTask> childProcessors = new HashSet<ConfigVirtualMachineRdmDiskTask>();
        List vmList = context.getObjects("Rdm_Target_VM", VsphereVirtualMachine.class);
        if (CollectionUtils.isEmpty((Collection)vmList)) {
            logger.info((Object)"target vm is empty when config vm rdm.");
            return this.success();
        }
        for (VsphereVirtualMachine vm : vmList) {
            ConfigVirtualMachineRdmDiskTask subTask = new ConfigVirtualMachineRdmDiskTask(vm, (RecoveryProcessor)this, DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E.Add);
            childProcessors.add(subTask);
        }
        this.setChildProc(childProcessors);
        boolean res = this.executeSubProcessor(context);
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(context.getRecoveryPlan().getPlanId());
        Map globalSettings = context.getRecoveryPlan().getGlobalSettings();
        recoveryPlan.getGlobalSettings().put("Rdm_Target_VM", globalSettings.get("Rdm_Target_VM"));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
        return res;
    }
}

