/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.recovery.process.VsCreateNasDsSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigDatastoreSubTask;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ConfigVirtualMachineDiskTask
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6479708279012753060L;
    private static final String AUTO_ANSWER_KEY = "answer.msg.uuid.altered";
    private static final String AUTO_ANSWER_VAULE = "\"I copied it\"";
    private static final String SKIP_KEY_SPLIT = "#@@#";
    private static final String SKIP_KEY_LIST = "skip.keys.vmx.list";
    private static final String ETHERNET = "ethernet";
    private static final String ETHERNET_ = "ethernet";
    private static final String CONFIG_VM_DISK_ERROR = "com.huawei.ism.drm.vsphere.recovery.task.ConfigVirtualMachineDiskTask.configVmDisk.failed";
    private static final Log logger = LogFactory.getInstance(ConfigVirtualMachineDiskTask.class);
    private VsphereVirtualMachine virtualMachine;
    private final Map<String, String> datastoreUrlMap = new HashMap<String, String>();
    private final transient DataStoreAction dataStoreAction = new DataStoreAction();

    public ConfigVirtualMachineDiskTask() {
    }

    public ConfigVirtualMachineDiskTask(VsphereVirtualMachine virtualMachine, RecoveryProcessor parentProc) {
        this.virtualMachine = virtualMachine;
        this.setParentProc(parentProc);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            logger.info((Object)"Last execution success.");
            return true;
        }
        this.updateProcessNameParams(new String[]{this.virtualMachine.getName()});
        this.datastoreUrlMap.putAll(this.getDatastoreUrlMap());
        String vmxPath = this.virtualMachine.getVmPath();
        int lastDotIndex = vmxPath.lastIndexOf(".");
        String vmsdFilePath = vmxPath.substring(0, lastDotIndex) + ".vmsd";
        if (this.modifyVmFile(context, vmxPath) && this.modifyVmFile(context, vmsdFilePath)) {
            this.deleteVswpFile();
            return this.success();
        }
        return this.failure(CONFIG_VM_DISK_ERROR, null);
    }

    private boolean modifyVmFile(RecoveryProcessorContext context, String vmFilePath) {
        if (!this.downloadFile(context, vmFilePath)) {
            logger.error((Object)"downloadFile error.vmFilePath:[%s]", new Object[]{vmFilePath});
            return false;
        }
        return this.updateDatasotreUrl(context, vmFilePath);
    }

    private boolean updateDatasotreUrl(RecoveryProcessorContext context, String vmFilePath) {
        String fileName = VsphereCommUtil.getVmxFileName(vmFilePath);
        String localFileName = this.getLocalFileName(fileName);
        List<AbstractMap.SimpleEntry<String, String>> properties = VsphereCommUtil.loadVmxFile(localFileName);
        if (VerifyUtil.isEmpty(properties)) {
            logger.info((Object)"Load vm file, name: %s, content: %s.", new Object[]{fileName, properties});
            return true;
        }
        boolean isConfigAutoResponse = false;
        boolean isKeepMac = VsphereRecoveryUtils.getKeepMacParam(context);
        HashSet<String> ethernetCardSet = new HashSet<String>();
        for (AbstractMap.SimpleEntry<String, String> entry : properties) {
            String key;
            for (Map.Entry<String, String> data : this.datastoreUrlMap.entrySet()) {
                String value = entry.getValue();
                if (null == value) {
                    logger.error((Object)"The value[%s] of VMX config item[%s] is null", new Object[]{entry.getKey()});
                    continue;
                }
                if (value.contains(data.getKey())) {
                    value = value.replace(data.getKey(), data.getValue());
                }
                entry.setValue(value);
                if (!entry.getKey().contains(AUTO_ANSWER_KEY)) continue;
                isConfigAutoResponse = true;
            }
            if (!isKeepMac || !(key = entry.getKey()).startsWith("ethernet")) continue;
            String[] split = key.split("\\.");
            ethernetCardSet.add(split[0]);
        }
        if (fileName.endsWith(".vmx") && !isConfigAutoResponse) {
            AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(AUTO_ANSWER_KEY, AUTO_ANSWER_VAULE);
            properties.add(entry);
        }
        this.configMacAddressCheck(properties, isKeepMac, ethernetCardSet);
        properties = properties.stream().filter(i -> this.filterVmxByKey((String)i.getKey())).distinct().collect(Collectors.toList());
        return VsphereCommUtil.storeProperties(properties, localFileName) && this.uploadFile(context, vmFilePath, localFileName);
    }

    private void configMacAddressCheck(List<AbstractMap.SimpleEntry<String, String>> properties, boolean isKeepMac, Set<String> ethernetCardSet) {
        if (isKeepMac && !ethernetCardSet.isEmpty()) {
            for (String ethernetCard : ethernetCardSet) {
                String tempKey = ethernetCard + ".checkMACAddress";
                int macAddressParamIndex = this.getMacAddressCheckParamIndex(properties, tempKey);
                if (macAddressParamIndex == -1) {
                    AbstractMap.SimpleEntry<String, String> tmp = new AbstractMap.SimpleEntry<String, String>(tempKey, "FALSE");
                    properties.add(tmp);
                    continue;
                }
                AbstractMap.SimpleEntry<String, String> tmpEntry = properties.get(macAddressParamIndex);
                tmpEntry.setValue("FALSE");
            }
        }
    }

    private int getMacAddressCheckParamIndex(List<AbstractMap.SimpleEntry<String, String>> properties, String key) {
        for (int i = 0; i < properties.size(); ++i) {
            AbstractMap.SimpleEntry<String, String> entry = properties.get(i);
            if (!entry.getKey().startsWith(key)) continue;
            return i;
        }
        return -1;
    }

    private boolean filterVmxByKey(String candidateKey) {
        String skipKeys = LegoConfig.getInstance().getKeyValue(SKIP_KEY_LIST);
        if (StringUtils.isBlank((CharSequence)candidateKey) || StringUtils.isBlank((CharSequence)skipKeys)) {
            return true;
        }
        String[] keys = skipKeys.split(SKIP_KEY_SPLIT);
        candidateKey = candidateKey.trim();
        for (String key : keys) {
            if (!candidateKey.equals(key.trim())) continue;
            logger.info((Object)"The candidateKey be filter, hit the skip list %s", new Object[]{candidateKey});
            return false;
        }
        return true;
    }

    protected Map<String, String> getDatastoreUrlMap() {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue()) {
            return (Map)this.getContextRef().getAttribute("datastoreIdChangeMap");
        }
        HashMap<String, String> datastoreUrlsMap = new HashMap<String, String>();
        List processors = RecoveryProcessUtil.isProtectGroupUseNasFileSystem((ProtectGroup)this.getContextRef().getProtectGroup()) ? this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsCreateNasDsSubProcessor.class) : this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), ConfigDatastoreSubTask.class);
        for (RecoveryProcessor proc : processors) {
            String key = null;
            String value = null;
            if (proc instanceof ConfigDatastoreSubTask) {
                ConfigDatastoreSubTask configDsProc = (ConfigDatastoreSubTask)proc;
                key = configDsProc.getSourceDatastoreUuid();
                value = configDsProc.getTargetDatastoreUuid();
            } else if (proc instanceof VsCreateNasDsSubProcessor) {
                VsCreateNasDsSubProcessor nasDsSubProcessor = (VsCreateNasDsSubProcessor)proc;
                key = nasDsSubProcessor.getOldDataStoreUrl();
                key = key.substring("ds:///vmfs/volumes/".length(), key.length() - 1);
                value = nasDsSubProcessor.getNewDataStoreUrl();
                value = value.substring("ds:///vmfs/volumes/".length(), value.length() - 1);
            }
            logger.info((Object)"oldDatastoreUuid:[%s], newDatastoreUuid:[%s]", new Object[]{key, value});
            if (VerifyUtil.isEmpty((String)key) || VerifyUtil.isEmpty((String)value)) continue;
            datastoreUrlsMap.put(key, value);
        }
        return datastoreUrlsMap;
    }

    private void deleteVswpFile() {
        String vcenterUuid = (String)this.getContextRef().getAttribute("Target_vCenter");
        String dataStoreName = VsphereCommUtil.getDatastoreName(this.virtualMachine.getVmPath());
        List<VsphereDataStore> dataStoreList = new DataStoreAction().queryAllDsWithoutValidate(vcenterUuid);
        VsphereDataStore dataStore = dataStoreList.stream().filter(ds -> dataStoreName.equals(ds.getName())).findFirst().orElse(null);
        if (null == dataStore) {
            logger.error((Object)"Config lun or snapshot of rdm disk[%s], but dataStore cannot find.", new Object[]{dataStoreName});
            throw new LegoCheckedException(2117645L);
        }
        List<String> list = this.dataStoreAction.listDatastoreFiles(vcenterUuid, dataStore.getDsMoId(), dataStoreName);
        if (VerifyUtil.isEmpty(list)) {
            logger.error((Object)"vswp files is null. dataStoreName : [%s]", new Object[]{dataStoreName});
            return;
        }
        this.dataStoreAction.deleteDatastoreFiles(vcenterUuid, dataStore.getDsMoId(), this.getDeletePaths(list));
        logger.debug((Object)"delete vswp file success .");
    }

    private Set<String> getDeletePaths(List<String> fullFilePaths) {
        String vmxPath = this.virtualMachine.getVmPath();
        String vmFolderPrefix = VsphereCommUtil.getVmFolderPrefix(vmxPath);
        logger.debug((Object)"vmFolderName : [%s]", new Object[]{vmFolderPrefix});
        HashSet<String> deletePaths = new HashSet<String>();
        for (String fullFilePath : fullFilePaths) {
            String folderPrefix = VsphereCommUtil.getVmFolderPrefix(fullFilePath);
            if (!folderPrefix.equals(vmFolderPrefix) || !fullFilePath.endsWith(".vswp")) continue;
            deletePaths.add(fullFilePath);
        }
        return deletePaths;
    }

    private boolean downloadFile(RecoveryProcessorContext context, String vmxFilePath) {
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        String dcName = (String)context.getRecoveryPlan().getGlobalSettings().get("VSDATACENTERNAME");
        logger.debug((Object)"Begin to backup vm(%s) config file from vCenter[%s] ,file path is %s and dataCenter Name is %s", new Object[]{this.virtualMachine.getName(), vCenterUuid, dcName, vmxFilePath});
        String fileName = VsphereCommUtil.getVmxFileName(vmxFilePath);
        String localFileName = this.getLocalFileName(fileName);
        return VsphereCommUtil.downloadVmxFile(vCenterUuid, dcName, vmxFilePath, localFileName);
    }

    private boolean uploadFile(RecoveryProcessorContext context, String vmxFilePath, String localFileName) {
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        String dcName = (String)context.getRecoveryPlan().getGlobalSettings().get("VSDATACENTERNAME");
        return VsphereCommUtil.uploadVmxFile(vCenterUuid, dcName, vmxFilePath, localFileName);
    }

    private String getLocalFileName(String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append("Backup").append("_").append(this.getPlanId()).append("_").append(this.virtualMachine.getUuid()).append("_").append(fileName).append(".").append("temp");
        return sb.toString();
    }
}

