/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMGuestAction;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigVMIpAddressSubTask;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VCenterNicIpInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;
import java.util.Map;

public class ConfigWindowsVMIpAddressSubTask
extends ConfigVMIpAddressSubTask {
    private static final Log logger = LogFactory.getInstance(ConfigWindowsVMIpAddressSubTask.class);
    private static final String START_TIMEOUT = "com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.starttimeout";
    private static final String START_VM_FAILED = "com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMSubTask.powerOnVm.failed";

    public ConfigWindowsVMIpAddressSubTask() {
    }

    public ConfigWindowsVMIpAddressSubTask(VsphereVirtualMachine virtualMachine, RecoveryProcessor parentProc) {
        super(virtualMachine, parentProc);
    }

    @Override
    public boolean configVmIpAddr(RecoveryProcessorContext context, Map<String, VCenterNicIpInfo> configMap) {
        boolean result;
        VMGuestAction action = new VMGuestAction();
        String vcenterUuid = (String)context.getAttribute("Target_vCenter");
        String vmMoId = this.getVirtualMachine().getVmMoId();
        String vmName = this.getVirtualMachine().getName();
        try {
            String poId = this.getVirtualMachine().getUuid();
            boolean ret = this.waitForVmStarted(vcenterUuid);
            if (!ret) {
                logger.error((Object)("start VM failed " + vmName), 90160758786989L);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
            JSONObject vmAuthJson = VsphereRecoveryUtils.getInstance().getWindowsVmAuthJson(poId, context.getRecoveryPlan());
            if (!vmAuthJson.isEmpty() && vmAuthJson.containsKey((Object)"username") && vmAuthJson.containsKey((Object)"password")) {
                String username = vmAuthJson.getString("username");
                String password = vmAuthJson.getString("password");
                result = action.configWindowsVMIp(vcenterUuid, vmMoId, username, WccEncryptor.decrypt((String)password), configMap);
            } else {
                logger.info((Object)("vm auth info is empty,no need to config ip: " + vmName), 90160758786988L);
                result = true;
            }
            if (result) {
                result = this.shutdownVm(context);
                logger.debug((Object)"config vm[%s] ip success, shutdownVm result=%s", new Object[]{vmName, result});
            }
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(e);
            result = false;
        }
        if (!result) {
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.configiperror", new String[]{vmName});
        }
        logger.info((Object)"config vm[%s] ip result=%s", new Object[]{vmName, result});
        return result;
    }

    private boolean waitForVmStarted(String vcenterUuid) {
        boolean ret = false;
        String vmName = this.getVirtualMachine().getName();
        String vmMoId = this.getVirtualMachine().getVmMoId();
        try {
            VMAction action = new VMAction();
            for (int i = 0; i < 50; ++i) {
                VirtualMachineToolsRunningStatus state = action.getGuestVMToolState(vcenterUuid, vmMoId);
                if (VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING == state) {
                    logger.debug((Object)("start VM " + vmName + " sucessfully"), 90160758786988L);
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
            if (!ret) {
                this.updateProcessDetail(START_TIMEOUT, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("start vm start failed " + vmName), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            ret = false;
        }
        catch (Exception e) {
            logger.error((Object)("start vm start failed " + vmName));
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            this.updateProcessDetail(START_VM_FAILED, new String[]{vmName});
            ret = false;
        }
        return ret;
    }
}

