/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public abstract class HandleScsiLunTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(HandleScsiLunTask.class);
    private static final String SCSI_LUN_NOT_EXIST = "com.huawei.ism.drm.vsphere.recovery.task.scsiLunNotExist";

    static String getHandleParameter(RecoveryProcessorContext context, VsphereHostSystem hostSystem, StorageResource sr) {
        RecoveryPlan plan = context.getRecoveryPlan();
        String planName = plan.getName();
        String planId = plan.getPlanId();
        return String.format("plan Id=%s, planName=%s, host=%s, wwn=%s", planId, planName, hostSystem.getIpAddress(), sr.getResourceIndentifier());
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String key = "Target_Host";
        List hostSystemList = context.getObjects(key, VsphereHostSystem.class);
        if (null == hostSystemList || hostSystemList.isEmpty()) {
            logger.error((Object)"Recovery target host is null");
            return this.failure("lego.err.1073948150", null);
        }
        List resourceList = context.getObjects("Target_Storage", StorageResource.class);
        if (null == resourceList || resourceList.isEmpty()) {
            logger.info((Object)"Target storage resource is null");
            return this.success(SCSI_LUN_NOT_EXIST, null);
        }
        List<VsphereHostSystem> powerOnHostList = this.getPowerOnHost(hostSystemList);
        if (null == powerOnHostList || powerOnHostList.isEmpty()) {
            logger.error((Object)"The number of power on host is 0.");
            return this.failure("lego.err.1073948150", null);
        }
        this.createSubTasks(powerOnHostList.get(0), resourceList);
        return this.executeSubProcessor(context);
    }

    protected abstract RecoveryProcessor newSubTask(RecoveryProcessor var1, VsphereHostSystem var2, StorageResource var3);

    private void createSubTasks(VsphereHostSystem hostSystem, List<StorageResource> storageResourceList) {
        HashSet<RecoveryProcessor> results = new HashSet<RecoveryProcessor>();
        for (StorageResource storageResource : storageResourceList) {
            RecoveryProcessor task = this.newSubTask((RecoveryProcessor)this, hostSystem, storageResource);
            results.add(task);
        }
        this.setChildProc(results);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private List<VsphereHostSystem> getPowerOnHost(List<VsphereHostSystem> hostSystemList) {
        String vCenterUuid = (String)this.getContextRef().getAttribute("Target_vCenter");
        HostSystemAction action = new HostSystemAction();
        return hostSystemList.stream().filter(hostSystem -> action.isHostPowerOn(vCenterUuid, hostSystem.getHostMoId())).collect(Collectors.toList());
    }
}

