/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public interface ISnapshotUpdater {
    public static final Log logger = LogFactory.getInstance(ISnapshotUpdater.class);

    default public void update(List<StorageResource> storageResourceList) {
        if (null == storageResourceList || storageResourceList.isEmpty()) {
            logger.info((Object)"Storage resource is null, No resources to update");
            return;
        }
        for (StorageResource storageResource : storageResourceList) {
            String deviceSn = storageResource.getDevSn();
            StorageSnapshotManagerProxy proxy = StorageSnapshotManagerProxy.getInstance();
            IStorageSnapshotManager manager = proxy.getStorageSnapshotMgrByDevId(deviceSn);
            Snapshot snapshot = new Snapshot();
            snapshot.setSnapshotId(storageResource.getResourceId());
            List snapshots = manager.getSnapshot(deviceSn, snapshot);
            if (null == snapshots || snapshots.isEmpty()) {
                logger.error((Object)"Update snapshot wwn failed, because cannot get snapshot by deviceSn[%s] and snapshot Id[%s]", new Object[]{deviceSn, snapshot.getSnapshotId()});
                throw new LegoCheckedException(1073947393L);
            }
            storageResource.setResourceIndentifier(((Snapshot)snapshots.stream().findFirst().get()).getWwn());
        }
    }
}

